/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.vhsm.net;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.multichip.process.vhsm.net.NetVhsmJniApi;
import java.io.File;

public class VhsmFileHandle {
    private static final String TAG = "VhsmFileHandle";
    private static final VhsmFileHandle INSTANCE = new VhsmFileHandle();
    private static final String FILE_NAME = "vhsm_file";
    private static final String VHSM_PATH = "vhsm_path";
    static final String DEFAULT_FILE_DIR = new File(Environment.getExternalStorageDirectory(), "xdja/vhsm/net").getAbsolutePath();
    private String currentVhsmPath = DEFAULT_FILE_DIR;

    private VhsmFileHandle() {
    }

    public static VhsmFileHandle getInstance() {
        return INSTANCE;
    }

    public int setVhsmCustomPath(Context context, String path) {
        Log.d((String)TAG, (String)("set file path " + path));
        this.currentVhsmPath = path;
        this.saveVhsmPath(context, path);
        NetVhsmJniApi netVhsmJniApi = new NetVhsmJniApi(context);
        int ret = netVhsmJniApi.SetVhsmPath(path);
        return ret;
    }

    public void saveVhsmPath(Context context, String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = "";
        }
        SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(FILE_NAME, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(VHSM_PATH, path);
        editor.commit();
    }

    public String getLocalVhsmPath(Context context) {
        SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences(FILE_NAME, 0);
        return sharedPreferences.getString(VHSM_PATH, "");
    }

    private String getCacheVhsmPath() {
        if (TextUtils.isEmpty((CharSequence)this.currentVhsmPath)) {
            this.currentVhsmPath = DEFAULT_FILE_DIR;
        }
        Log.e((String)TAG, (String)("get current vhsm path " + this.currentVhsmPath));
        return this.currentVhsmPath;
    }

    public String getRandfilePath() {
        return this.getCacheVhsmPath() + File.separator + "rand.bin";
    }

    public String getWboxfilePath() {
        return this.getCacheVhsmPath() + File.separator + "wbox.lib";
    }

    public String getKdatfilePath() {
        return this.getCacheVhsmPath() + File.separator + "vhsm.dat";
    }

    public String getVhsmlibfilePath() {
        return this.getCacheVhsmPath() + File.separator + "vhsm.lib";
    }

    public boolean judgeVhsmFileComplete() {
        File randFile = new File(this.getRandfilePath());
        if (!randFile.exists()) {
            return false;
        }
        File wboxFile = new File(this.getWboxfilePath());
        if (!wboxFile.exists()) {
            return false;
        }
        File kdatFile = new File(this.getKdatfilePath());
        return kdatFile.exists();
    }
}

