package com.xdja.uniteauth;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.v4.hardware.fingerprint.FingerprintManagerCompat;
import android.util.Log;

import com.tencent.soter.core.SoterCore;
import com.tencent.soter.core.model.ConstantsSoter;
import com.tencent.soter.wrapper.SoterWrapperApi;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessCallback;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessKeyPreparationResult;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessNoExtResult;
import com.tencent.soter.wrapper.wrap_core.SoterProcessErrCode;
import com.tencent.soter.wrapper.wrap_task.InitializeParam;
import com.xdja.uniteauth.data.ApiGen;
import com.xdja.uniteauth.data.local.UacPreference;
import com.xdja.uniteauth.utils.AuthModeUtil;
import com.xdja.uniteauth.utils.KeyStoreUtil;
import com.xdja.uniteauth.utils.SafeCardUtil;
import com.xdja.uniteauth.utils.UacActivityManager;
import com.xdja.uniteauth.utils.UacColorConfig;
import com.xdja.uniteauth.utils.UacConstant;
import com.xdja.uniteauth.utils.UserInfoUtil;

/**
 * @author wzg
 */

public class ApplicationContext {

    private static final String TAG = "UacApplicationTag";

    private static Context context = null;

    public static Context getContext() {
        return context;
    }

    /**
     * 应用初始化完成标识
     */
    public static volatile boolean isAppInitialized;

    public static void setContext(final Context context) {
        ApplicationContext.context = context;
        ThreadPoolManager.getInstance().execute(new Runnable() {
            @Override
            public void run() {
                initApp(context);
            }
        });
        initSoterWrapperApi();
        registerReceiver();
    }

    /**
     * 初始化
     */
    private static void initApp(Context context) {
        SafeCardUtil.getInstance().init(context);
        UacColorConfig.getInstance().init(context);
        KeyStoreUtil.getInstance().init(context);
        UacPreference.getInstance().init(context);
        UserInfoUtil.getInstance().loadUserInfo();
        ApiGen.initUnitAuthApi(context);
        isAppInitialized = true;
    }

    /**
     * 初始化soterApi
     */
    public static void initSoterWrapperApi() {
        Log.d(TAG, "initSoterWrapperApi()");

        FingerprintManagerCompat fingerprintManagerCompat = FingerprintManagerCompat
                .from(context.getApplicationContext());
        boolean isHardwareDetected = fingerprintManagerCompat.isHardwareDetected();
        Log.d(TAG, "isHardwareDetected = " + isHardwareDetected);
        AuthModeUtil.getInstance().setHasFingerprintHardware(isHardwareDetected);

        // initApp 的时机有多种情况，应用方可以自己选择。如果多账号共享同一个密钥的话，则只需要在 Application 的 onCreate 中初始化；如果需要切换账户，则在账户登录成功之后初始化。如果需要
        // 不同账户不共享密钥，则需要填入区分不同账户的字符串 setDistinguishSalt，比如账户名。正常情况下，没有特殊需求，不用调用 setCustomAppSecureKeyName。此接口仅仅作为前期已经接入
        // 如果有自己的log实现，可以将实现通过 setSoterLogger 接口写入
        InitializeParam param = new InitializeParam.InitializeParamBuilder()
                .setGetSupportNetWrapper(null)
                .setScenes(UacConstant.TENCENT_SOTER_SCENE)
                .build();

        SoterWrapperApi.init(context.getApplicationContext(), new SoterProcessCallback<SoterProcessNoExtResult>() {
            @Override
            public void onResult(@NonNull SoterProcessNoExtResult result) {
                Log.d(TAG, "SoterWrapperApi initApp result = " + result.getErrCode());
                if (result.errCode == SoterProcessErrCode.ERR_OK) {
                    prepareAuthKey();
                    AuthModeUtil.getInstance().setSupportSoterFingerprint(
                            SoterCore.isSupportBiometric(context, ConstantsSoter.FINGERPRINT_AUTH));
                }

            }
        }, param);

    }

    private static void prepareAuthKey() {
        Log.d(TAG, "prepareAuthKey()");
        SoterWrapperApi.prepareAuthKey(
                new SoterProcessCallback<SoterProcessKeyPreparationResult>() {
                    @Override
                    public void onResult(@NonNull SoterProcessKeyPreparationResult result) {
                        Log.d(TAG, "prepare AuthKey result = " + result.getErrCode());
//                        AuthModeUtil.getInstance().setSupportSoterFingerprint(result.getErrCode() == SoterProcessErrCode.ERR_OK);
                    }
                }, false, true,
                UacConstant.TENCENT_SOTER_SCENE, null, null);
    }

    /**
     * 监听TF卡、SIM卡状态，插拔卡后重新初始化数据并关闭当前界面
     */
    private static void registerReceiver() {
        Log.d(TAG, "registerReceiver()");
        IntentFilter intentFilter = new IntentFilter();
        //tf卡
        intentFilter.addAction(Intent.ACTION_MEDIA_MOUNTED);
        intentFilter.addAction(Intent.ACTION_MEDIA_REMOVED);
        intentFilter.addAction(Intent.ACTION_MEDIA_EJECT);
        intentFilter.addDataScheme("file");

        //贴膜卡（sim）
        intentFilter.addAction("android.intent.action.SIM_STATE_CHANGED");
        context.registerReceiver(new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                Log.d(TAG, "onReceive(), intent action = " + intent.getAction());
                if (AuthModeUtil.getInstance().isOpenPlatformApp()) {
                    UacActivityManager.getInstance().finishAllActivity();
                }
            }
        }, intentFilter);
    }
}
