package com.xdja.uniteauth;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.uniteauth.bean.LoginMode;

import java.util.List;

/**
 * @author kongguoguang
 * Date:2019/9/24
 * Time:8:54
 * Summary:
 */
public class AuthModeGridAdapter extends BaseAdapter {

    private List<LoginMode> items;

    public AuthModeGridAdapter(List<LoginMode> items) {
        this.items = items;
    }

    @Override
    public int getCount() {
        return items == null ? 0 : items.size();
    }

    @Override
    public Object getItem(int position) {
        return items.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = LayoutInflater.from(parent.getContext()).inflate(R.layout.uac_item_auth_mode_grid, parent, false);
            holder = new ViewHolder();
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        holder.authModeName = (TextView) convertView.findViewById(R.id.tv_auth_mode_name);
        LoginMode loginMode = items.get(position);
        holder.authModeName.setText(loginMode.getName());

        if (getCount() == 2) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) holder.authModeName.getLayoutParams();
            if (position == 0) {
                layoutParams.removeRule(RelativeLayout.CENTER_IN_PARENT);
                layoutParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                layoutParams.rightMargin = dp2px(parent.getContext(), 16);

            } else {
                layoutParams.removeRule(RelativeLayout.CENTER_IN_PARENT);
                layoutParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
                layoutParams.leftMargin = dp2px(parent.getContext(), 16);
            }
            holder.authModeName.setLayoutParams(layoutParams);
        }

        return convertView;
    }

    private class ViewHolder {
        private TextView authModeName;
    }

    private int dp2px(Context context, int dpVal) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dpVal * scale + 0.5f);
    }
}
