package com.xdja.uniteauth;

import android.graphics.Bitmap;
import android.util.LruCache;

/**
 * @author kgg
 * Date:2019/9/30
 * Time:9:30
 * Summary:
 */
public class LogoImageCache {
    private static final LogoImageCache INSTANCE = new LogoImageCache();

    public static LogoImageCache getInstance() {
        return INSTANCE;
    }

    private LogoImageCache() {
    }

    /**
     * 进程可用最大内存的1/8作为缓存最大容量
     */
    private LruCache<String, Bitmap> cache = new LruCache<String, Bitmap>(
            (int) (Runtime.getRuntime().maxMemory() / 8)) {
        @Override
        protected int sizeOf(String key, Bitmap value) {
            return value.getByteCount();
        }
    };

    public void setLogoImage(String url, Bitmap logo) {
        cache.put(url, logo);
    }

    public Bitmap getLogoImage(String appName) {
        return cache.get(appName);
    }
}
