package com.xdja.uniteauth;

import android.util.Log;

import java.util.HashMap;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/8/1 <br/>
 */
public class PkgInfoCache {
    private static final String TAG = "PkgInfoCacheTag";
    private static PkgInfoCache instance;

    private PkgInfoCache() {

    }

    public static PkgInfoCache getInstance() {
        if (instance == null) {
            synchronized (PkgInfoCache.class) {
                if (instance == null) {
                    instance = new PkgInfoCache();
                }
            }
        }
        return instance;
    }

    /**
     * uid和pid对应的包名
     * key为 uid#pid
     * value为 pkgName
     */
    private HashMap<String, String> pkgMap = new HashMap<>();

    /**
     * 缓存
     *
     * @param uid
     * @param pid
     * @param pkgName
     */
    public void setPkgName(int uid, int pid, String pkgName) {
        String key = getKey(uid, pid);
        pkgMap.put(key, pkgName);
        Log.d(TAG, "uid:" + uid + " pid:" + pid + " pkgName: " + pkgName);
    }

    /**
     * 得到缓存中uid 和 pid 对应的包名
     *
     * @param uid
     * @param pid
     * @return
     */
    public String getPkgName(int uid, int pid) {
        String key = getKey(uid, pid);
        String pkgName = pkgMap.get(key);
        if (pkgName == null) {
            pkgName = "";
        }
        return pkgName;
    }

    /**
     * 得到pkgMap要用的key
     *
     * @param uid
     * @param pid
     * @return
     */
    private String getKey(int uid, int pid) {
        return uid + "#" + pid;
    }
}
