package com.xdja.uniteauth;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author kgg
 * Date:2019/9/30
 * Time:10:20
 * Summary:
 */
public class ThreadPoolManager {
    private static final ThreadPoolManager INSTANCE = new ThreadPoolManager();

    public static ThreadPoolManager getInstance() {
        return INSTANCE;
    }

    private ThreadPoolManager() {
    }

    private ExecutorService singleThreadExecutor;

    public void execute(Runnable runnable) {
        if (singleThreadExecutor == null) {
            singleThreadExecutor = Executors.newSingleThreadExecutor();
        }
        singleThreadExecutor.execute(runnable);
    }

    /**
     * 关闭线程池，重新实例化，防止当前三方应用获取授权码时上一个三方应用的授权码网络请求还没完成
     * 若IAM应用正在初始化则不允许关闭
     */
    public void shutdownNow() {
        if (ApplicationContext.isAppInitialized &&
                singleThreadExecutor != null && !singleThreadExecutor.isShutdown()) {
            singleThreadExecutor.shutdownNow();
            singleThreadExecutor = null;
        }
    }
}
