package com.xdja.uniteauth;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.uniteauth.domain.GetAuthCodeWithoutActivity;
import com.xdja.uniteauth.jar.ErrorCode;
import com.xdja.uniteauth.jar.IUniteAuth;
import com.xdja.uniteauth.jar.ParamKeywords;
import com.xdja.uniteauth.presenter.AuthLoginActivity;
import com.xdja.uniteauth.utils.SafeCardUtil;
import com.xdja.uniteauth.utils.UacActivityManager;
import com.xdja.uniteauth.utils.UacColorConfig;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/7/31 <br/>
 */
public class UniteAuthBinder extends IUniteAuth.Stub {
    private static final String TAG = "UniteAuthBinderTag";

    private static UniteAuthBinder instance;
    private Context context;

    private UniteAuthBinder(Context context) {
        this.context = context;
    }

    public static UniteAuthBinder getInstance(Context context) {
        if (instance == null) {
            synchronized (UniteAuthBinder.class) {
                if (instance == null) {
                    instance = new UniteAuthBinder(context);
                }
            }
        }
        return instance;
    }


    @Override
    public Bundle call(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        String method = bundle.getString(ParamKeywords.KEY_METHOD);
        if (TextUtils.isEmpty(method)) {
            return getBundleForNoSuchMethod();
        }

        if (method.equals(ParamKeywords.KEY_METHOD_getAuthCode)) {
            return getAuthCode(bundle);
        }

        //add 2018年12月13日16:58:42 weizg
        if (ParamKeywords.KEY_METHOD_getAarPackageName.equals(method)) {
            return getPackageName(bundle);
        }

        return getBundleForNoSuchMethod();
    }

    //add 2018年12月13日17:07:11 weizg
    private Bundle getPackageName(Bundle bundle) {
        UacColorConfig.getInstance().changeTitleBarColor(bundle.getString(ParamKeywords.KEY_String_titleBarColor));
        UacColorConfig.getInstance().changeOtherColor(bundle.getString(ParamKeywords.KEY_String_buttonColor));
        Bundle result = new Bundle();
        result.putInt(ParamKeywords.KEY_int_ret, 0);
        result.putString(ParamKeywords.KEY_String_pkgName, context.getPackageName());
        return result;
    }

    /**
     * 得到没有此方法的Bundle
     */
    private Bundle getBundleForNoSuchMethod() {
        Bundle result = new Bundle();
        result.putInt(ParamKeywords.KEY_int_ret, ErrorCode.RET_NO_SUCH_METHOD);
        return result;
    }

    /**
     * 获取验证码
     *
     * @param bundle
     * @return
     */
    private Bundle getAuthCode(Bundle bundle) {
        int uid = bundle.getInt(ParamKeywords.KEY_int_uid);
        int pid = bundle.getInt(ParamKeywords.KEY_int_pid);

        if (uid == 0) {
            uid = getCallingUid();
            bundle.putInt(ParamKeywords.KEY_int_uid, uid);
        }

        if (pid == 0) {
            pid = getCallingPid();
            bundle.putInt(ParamKeywords.KEY_int_pid, pid);
        }

        Log.d(TAG, "getAuthCode(), uid：" + uid + ", pid：" + pid);

        String pkgName = PkgInfoCache.getInstance().getPkgName(uid, pid);
        if (TextUtils.isEmpty(pkgName)) {
            Bundle result = new Bundle();
            result.putInt(ParamKeywords.KEY_int_ret, ErrorCode.RET_NO_POWER);
            return result;
        }

        bundle.putString(ParamKeywords.KEY_String_pkgName, pkgName);
        int ret = getAuthCode(context, bundle);

        Bundle result = new Bundle();
        result.putInt(ParamKeywords.KEY_int_ret, ret);
        return result;
    }

    private final static int MSG_START_ACTIVITY = 1;

    private Handler handler;

    private synchronized Handler getHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper()) {
                @Override
                public void handleMessage(Message msg) {
                    super.handleMessage(msg);

                    if (msg.what == MSG_START_ACTIVITY) {
                        UacActivityManager.getInstance().finishAllActivity();
                        Intent intent = new Intent(context, AuthLoginActivity.class);
                        intent.putExtra(ParamKeywords.KEY_Bundle_bundle, (Bundle) msg.obj);
                        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK);
                        context.startActivity(intent);
                    }
                }
            };
        }

        return handler;
    }

    /**
     * @param context
     * @param bundle
     */
    private int getAuthCode(Context context, Bundle bundle) {

        //PIN码不存在或者验证失败，进入获取授权码界面
        String pin = SafeCardUtil.getInstance().getPin();
        if (TextUtils.isEmpty(pin) || SafeCardUtil.getInstance().isLastVerifyPinFailed()) {
            return gotoGetAuthCodeActivity(bundle);
        }

        //pin模式，不进入获取授权码界面
        boolean pinModuleFlag = UniteAuthConfig.getInstance(context).isPinModule();
        if (pinModuleFlag) {
            return getAuthCodeWithoutActivity(bundle);
        }

        //配置文件中showAuthActivity为false，不进入获取授权码界面
        boolean showAuthActivity = UniteAuthConfig.getInstance(context).isShowAuthActivity();
        if (!showAuthActivity) {
            return getAuthCodeWithoutActivity(bundle);
        }

        //其他情况均要进入获取授权码界面
        return gotoGetAuthCodeActivity(bundle);
    }

    /**
     * 进入获取授权码界面
     */
    private int gotoGetAuthCodeActivity(Bundle bundle) {
        UacColorConfig.getInstance().changeTitleBarColor(bundle.getString(ParamKeywords.KEY_String_titleBarColor));
        UacColorConfig.getInstance().changeOtherColor(bundle.getString(ParamKeywords.KEY_String_buttonColor));
        Message msg = Message.obtain();
        msg.what = MSG_START_ACTIVITY;
        msg.obj = bundle;
        getHandler().sendMessage(msg);
        return 0;
    }

    /**
     * 不进入界面，直接获取授权码
     */
    private int getAuthCodeWithoutActivity(Bundle bundle) {
        GetAuthCodeWithoutActivity uniteAuth = new GetAuthCodeWithoutActivity();
        return uniteAuth.getAuthCode(context, bundle);
    }

}
