package com.xdja.uniteauth;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;

import com.xdja.uniteauth.jar.ErrorCode;
import com.xdja.uniteauth.jar.ParamKeywords;

import org.jetbrains.annotations.NotNull;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/7/31 <br/>
 */
public class UniteAuthProvider extends ContentProvider {

    @Override
    public boolean onCreate() {
        ApplicationContext.setContext(getContext().getApplicationContext());
        return false;
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    @Override
    public String getType(Uri uri) {
        return null;
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public Bundle call(@NotNull String method, String arg, Bundle extras) {
        if (TextUtils.isEmpty(method) || TextUtils.isEmpty(arg) || extras == null) {
            return null;
        }

        int uid = extras.getInt(ParamKeywords.KEY_int_uid);
        int pid = extras.getInt(ParamKeywords.KEY_int_pid);

        if (uid == 0) {
            uid = Binder.getCallingUid();
        }

        if (pid == 0) {
            pid = Binder.getCallingPid();
        }

//      addd 2019年2月22日15:14:23 weizg
//      发现如下问题：一个客户端应用调用到一个服务端应用的provider1的call方法，在call方法中再调用另外一个同一进程的provider2的call方法，
//      此时在provider2的call方法中调用系统的“getCallingPackage”会出现异常：getCallingUid与pkgName不一致的异常，
//      getCallingUid方法返回的是客户端应用的Uid，但是pkgName却是服务端应用的。
//       为了解决该问题，使用下面方法。
//        如果应用在安全盒内，统一认证在安全盒外，则获取到的为安全盒包名而非应用的包名
        String pkgName = getCallingPackageSafe(getContext());

        PkgInfoCache.getInstance().setPkgName(uid, pid, pkgName);

        //先判断调用过来的jar包的版本，看是否支持
        int version = extras.getInt(ParamKeywords.KEY_int_version);
        if (!judgeIsSupport(version)) {
            Bundle result = new Bundle();
            result.putInt(ParamKeywords.KEY_int_ret, ErrorCode.RET_NOT_SUPPORT);
            return result;
        }

        //判断是否支持此方法
        if (method.equals(ParamKeywords.KEY_METHOD_GetBinder)) {
            Bundle result = new Bundle();
            result.putInt(ParamKeywords.KEY_int_ret, 0);
            result.putBinder(ParamKeywords.KEY_Binder_Binder, UniteAuthBinder.getInstance(getContext()));
            return result;
        } else {
            Bundle result = new Bundle();
            result.putInt(ParamKeywords.KEY_int_ret, ErrorCode.RET_NO_SUCH_METHOD);
            return result;
        }
    }

    /**
     * 判断是否支持此版本
     *
     * @param version
     * @return
     */
    private boolean judgeIsSupport(int version) {
        //当前只支持版本1
        if (version == 1) {
            return true;
        }
        return false;
    }

    /**
     * 安全的获取调用者的包名
     *
     * @param context
     * @return
     */
    private String getCallingPackageSafe(Context context) {
        String pkgName = "";
        try {
            pkgName = getCallingPackage();
            return pkgName;
        } catch (Exception e) {
            int uid = Binder.getCallingUid();
            PackageManager pm = context.getPackageManager();
            pkgName = pm.getNameForUid(uid);
        }
        if (TextUtils.isEmpty(pkgName)) {
            pkgName = "";
        }
        return pkgName;
    }


}
