package com.xdja.uniteauth.bean;

import com.xdja.uniteauth.utils.UacConstant;

/**
 * Author:kongguoguang
 * Date:2019/8/12
 * Time:10:58
 * Summary:登录方式枚举类，指纹、手势需要配合其他登录方式使用
 *
 * @author kgg
 */
public enum LoginMode {
    /**
     * 老平台证书登录
     */
    OldCert(UacConstant.LOGIN_MODE_NAME_OLD_CERT),

    /**
     * 用户名密码登录
     */
    UserPwd(UacConstant.LOGIN_MODE_NAME_USER_PWD),

    /**
     * 证书登录
     */
    Cert(UacConstant.LOGIN_MODE_NAME_CERT),

    /**
     * 指纹登录
     */
    FINGERPRINT(UacConstant.LOGIN_MODE_NAME_FINGERPRINT),

    /**
     * 手势登录
     */
    GESTURE(UacConstant.LOGIN_MODE_NAME_GESTURE);

    private final String name;

    LoginMode(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }
}
