package com.xdja.uniteauth.data;

import android.content.Context;
import android.util.Log;

import com.xdja.uniteauth.UniteAuthConfig;
import com.xdja.uniteauth.data.net.UnitAuthApi;
import com.xdja.uniteauth.net.RetrofitBuilder;
import com.xdja.uniteauth.net.RetrofitOkClient;

import retrofit.Callback;
import retrofit.RestAdapter;
import retrofit.client.Response;


/**
 * date:   2017/10/17 15:12 <br/>
 * @author kgg
 */

public class ApiGen {


    public static UnitAuthApi genUnitAuthApi(Context context) {
        return generateApi(context, UnitAuthApi.class);
    }

    public static UnitAuthApi getUnitAuthApi() {
        if (unitAuthApi == null) {
            throw new NullPointerException("unitAuthApi is null.");
        }
        return unitAuthApi;
    }

    private static UnitAuthApi unitAuthApi;

    public static void initUnitAuthApi(Context context) {
        String endPoint = UniteAuthConfig.getInstance(context).getUacServerAddress();
        unitAuthApi = RetrofitBuilder.INSTANCE.getRetrofitBuilder()
                .setClient(RetrofitOkClient.INSTANCE.getOkClient())
                .setEndpoint(endPoint)
                .setLogLevel(getRestLogLevel())
                .setLog(getRestLog())
                .build()
                .create(UnitAuthApi.class);
    }

    private static <T> T generateApi(Context context, Class<T> service) {

//        ConfigCacheUAC configCacheUAC = ConfigCacheUAC.getInstance();
//        String endPoint = configCacheUAC.get().get(DataConstDefUAC.KEY_APP_ENDPOINT_UAC);
        String endPoint = UniteAuthConfig.getInstance(context).getUacServerAddress();

        return RetrofitBuilder.INSTANCE.getRetrofitBuilder()
                .setClient(RetrofitOkClient.INSTANCE.getOkClient())
                .setEndpoint(endPoint)
//                .setRequestInterceptor(new RequestInterceptor() {
//                    @Override
//                    public void intercept(RequestFacade request) {
////                        request.addHeader(CARD_ID, cardId);
////                        request.addHeader(SN,sn);
//                        request.addHeader(HEAD_CONTENT_TYPE, "application/json; charset=UTF-8");
//                    }
//                })
                .setLogLevel(getRestLogLevel())
                .build()
                .create(service);
    }


    //设置log
    private static RestAdapter.LogLevel getRestLogLevel() {
        return RestAdapter.LogLevel.FULL;
    }

    //设置loglevel 级别
    private static RestAdapter.Log getRestLog() {
        return new RestAdapter.Log() {
            @Override
            public void log(String message) {
                Log.d("UnitAuthApiTag", message);
            }
        };
    }

    public static void loadImg(String imageUrl, Callback<Response> callback) {
        try {
            int lastIndex = imageUrl.lastIndexOf("/");
            String endPoint = imageUrl.substring(0, lastIndex);
            String imageName = imageUrl.substring(lastIndex);

            RetrofitBuilder.INSTANCE.getRetrofitBuilder()
                    .setClient(RetrofitOkClient.INSTANCE.getOkClient())
                    .setEndpoint(endPoint)
                    //必须设置为FULL，Retrofit 1.x版本bug
                    .setLogLevel(RestAdapter.LogLevel.FULL)
                    .build()
                    .create(UnitAuthApi.class)
                    .loadImg(imageName, callback);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
