package com.xdja.uniteauth.data.net;

import com.xdja.uniteauth.data.net.model.CheckPkgRequest;
import com.xdja.uniteauth.data.net.model.GetAuthCodeRequest;
import com.xdja.uniteauth.data.net.model.LoginRequest;
import com.xdja.uniteauth.data.net.model.UASResponseBean;

import retrofit.Callback;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.Field;
import retrofit.http.FormUrlEncoded;
import retrofit.http.GET;
import retrofit.http.Header;
import retrofit.http.POST;
import retrofit.http.Path;
import retrofit.http.Query;
import retrofit.http.Streaming;

/**
 * <br>author: wzg@xdja.com <br/>
 * date:   2018/7/31 16:45 <br/>
 */
public interface UnitAuthApi {

    @GET("/api/v1/authorize/challenge")
    void getChallenge(Callback<UASResponseBean> cb);

    @GET("/api/v1/authorize/challenge")
    UASResponseBean getChallenge();

    /**
     * 验证包公钥指纹
     *
     * @param appId 应用标识
     * @param cb    结果回调
     */
    @POST("/api/v1/authorize/package")
    void checkPkgSign(@Header("appId") String appId,
                      @Body CheckPkgRequest checkPkgRequest,
                      Callback<UASResponseBean> cb);


    @POST("/api/v1/authorize/code")
    void getAuthCode(@Header("appId") String appId,
                     @Header("chipId") String chipId,
                     @Header("sn") String sn,
                     @Body GetAuthCodeRequest getAuthCodeRequest,
                     Callback<UASResponseBean> cb);

    @POST("/api/v1/authorize/code")
    UASResponseBean getAuthCode(@Header("appId") String appId,
                                @Header("chipId") String chipId,
                                @Header("sn") String sn,
                                @Body GetAuthCodeRequest getAuthCodeRequest);


    @FormUrlEncoded
    @POST("/api/v2/getAuthMode")
    UASResponseBean getAuthMode(@Field("client_id") String clientId,
                                @Field("redirect_uri") String redirectUri,
                                @Field("scope") String scope,
                                @Field("response_type") String responseType);


    @POST("/api/v2/verifyIdentity")
    UASResponseBean login(@Body LoginRequest loginRequest);

    @POST("/api/v1/web/authorize/verifyIdentity")
    void login(@Body LoginRequest loginRequest,
               Callback<UASResponseBean> callback);

    @FormUrlEncoded
    @POST("/api/v1/web/logout")
    void logout(@Field("sessionId") String sessionId,
                @Field("appId") String appId);

    @GET("/api/v1/web/logout")
    UASResponseBean testScheme(@Query("packageName") String packageName,
                               @Query("packageSign") String packageSign);

    @Streaming
    @GET("/{image}")
    void loadImg(@Path("image") String imageName, Callback<Response> callback);

}
