package com.xdja.uniteauth.domain;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.uniteauth.UniteAuthConfig;
import com.xdja.uniteauth.data.ApiGen;
import com.xdja.uniteauth.data.net.model.ErrInfoBean;
import com.xdja.uniteauth.data.net.model.GetChallengeResponse;
import com.xdja.uniteauth.data.net.model.LoginRequest;
import com.xdja.uniteauth.data.net.model.LoginResponse;
import com.xdja.uniteauth.data.net.model.UASResponseBean;
import com.xdja.uniteauth.jar.ErrorCode;
import com.xdja.uniteauth.utils.CallbackAppUtil;
import com.xdja.uniteauth.utils.ErrorCodeUtil;
import com.xdja.uniteauth.utils.SafeCardUtil;
import com.xdja.uniteauth.utils.UacConstant;
import com.xdja.uniteauth.utils.UserInfoUtil;

import java.util.Arrays;

import it.sauronsoftware.base64.Base64;

/**
 * Author:kongguoguang
 * Date:2019/10/22
 * Time:15:31
 * Summary:
 *
 * @author kgg
 */
public class CertLoginManager {
    private String clientId;
    private String state;
    private String scope;
    private String redirectUri;
    private JarJniApiProxy jarJniApiProxy;
    private String cardId;

    private int containNo;
    private int certType;

    private String sn;
    private Gson gson = new Gson();

    public int login(Context context, Bundle bundle) {
        scope = bundle.getString(UacConstant.KEY_SCOPE);
        state = bundle.getString(UacConstant.KEY_STATE);
        clientId = bundle.getString(UacConstant.KEY_CLIENT_ID);
        redirectUri = bundle.getString(UacConstant.KEY_REDIRECT_URI);
        jarJniApiProxy = SafeCardUtil.getInstance().getJniApiProxy();
        cardId = jarJniApiProxy.getCardId().second;
        containNo = UniteAuthConfig.getInstance(context).getContain();
        certType = UniteAuthConfig.getInstance(context).getCertType();
        sn = SafeCardUtil.getInstance().getSn();
        if (TextUtils.isEmpty(sn)) {
            return ErrorCode.RET_GET_CERT_SN_FAIL;
        }
        try {
            UASResponseBean uasResponseBean = ApiGen.getUnitAuthApi().getChallenge();
            if (uasResponseBean == null) {
                return ErrorCode.RET_SERVER_RETURN_ERR;
            }
            if (uasResponseBean.isIsSuccess()) {
                //获取挑战值成功

                GetChallengeResponse getChallengeResponse =
                        gson.fromJson(gson.toJson(uasResponseBean.getInfo()), GetChallengeResponse.class);

                return login(getChallengeResponse);
            } else {
                ErrInfoBean errInfoBean = gson.fromJson(gson.toJson(uasResponseBean.getInfo()), ErrInfoBean.class);
                return errInfoBean.getErrCode();
            }

        } catch (Exception e) {
            e.printStackTrace();
            return ErrorCodeUtil.getErrorCode(e);
        }
    }


    private int login(GetChallengeResponse getChallengeResponse) {
        byte[] challengeBytes = getChallengeResponse.getChallengeStr().getBytes();

        byte[] dataOut = new byte[512];
        int[] outLen = new int[2];

        //签名
        int ret = SafeCardUtil.getInstance().signByContainNo(jarJniApiProxy, challengeBytes, challengeBytes.length,
                dataOut, outLen, certType, containNo);
        //解析签名结果
        if (ret != 0) {
            return ErrorCode.RET_CHALLENGE_SIGN_FAIL;
        }

        //如果签名正确
        byte[] signResult = Arrays.copyOfRange(dataOut, 0, outLen[0]);
        String challenge = getChallengeResponse.getChallengeStr();
        int index = getChallengeResponse.getIndex();

        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setScope(scope);
        loginRequest.setState(state);
        loginRequest.setClient_id(clientId);
        loginRequest.setRedirect_uri(redirectUri);
        loginRequest.setClientType(UacConstant.CLIENT_TYPE);
        loginRequest.setChipId(cardId);
        loginRequest.setSn(sn);
        loginRequest.setChallenge(challenge);
        loginRequest.setIndex(index + "");
        loginRequest.setSign(new String(Base64.encode(signResult)));
        loginRequest.setAuthMode(UacConstant.AUTH_MODE_CERT);

        try {
            UASResponseBean uasResponseBean = ApiGen.getUnitAuthApi().login(loginRequest);
            if (uasResponseBean == null) {
                return ErrorCode.RET_SERVER_RETURN_ERR;
            }

            if (uasResponseBean.isIsSuccess()) {
                LoginResponse loginResponse = gson.fromJson(gson.toJson(uasResponseBean.getInfo()), LoginResponse.class);
                loginResponse.setSn(sn);
                UserInfoUtil.getInstance().saveUserInfo(loginResponse);
                CallbackAppUtil.getInstance().saveLoginResponse(loginResponse);
                return 0;
            } else {
                ErrInfoBean errInfoBean = gson.fromJson(gson.toJson(uasResponseBean.getInfo()), ErrInfoBean.class);
                if (ErrorCodeUtil.isIdpError(errInfoBean.getErrCode())) {
                    ErrorCodeUtil.idpErrorMsg = errInfoBean.getDesc();
                }
                return errInfoBean.getErrCode();
            }
        } catch (Exception e) {
            e.printStackTrace();
            return ErrorCodeUtil.getErrorCode(e);
        }
    }
}
