package com.xdja.uniteauth.domain;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;

import com.xdja.uniteauth.jar.ErrorCode;
import com.xdja.uniteauth.utils.CallbackAppUtil;
import com.xdja.uniteauth.utils.ErrorCodeUtil;
import com.xdja.uniteauth.utils.SafeCardUtil;

/**
 * Author:kongguoguang
 * Date:2019/10/22
 * Time:15:23
 * Summary:
 *
 * @author kgg
 */
public class CertLoginThread extends ThreadWithMainHandler {
    public static final String THREAD_NAME = "UserPwdLoginThread";

    private Context context;

    private String pin;

    private Bundle bundle;

    public CertLoginThread(Context context, Handler handler, String pin, Bundle bundle) {
        super(THREAD_NAME, handler);
        this.context = context;
        this.pin = pin;
        this.bundle = bundle;
    }

    @Override
    public void run() {
        super.run();
        int result;
        //流程：
        //1. 得到PIN
        //2. 验证PIN是否正确
        //3. 登录

        //1. 得到PIN
        if (TextUtils.isEmpty(pin)) {
            pin = SafeCardUtil.getInstance().getPin();
        }
        if (TextUtils.isEmpty(pin)) {
            sendMessage(ErrorCode.RET_GET_PIN_NULL);
            return;
        }

        //2. 验证PIN是否正确
        int ret = SafeCardUtil.getInstance().verifyPin(pin);
        if (ret != 0) {
            sendMessage(ErrorCode.RET_VERIFY_SAFE_PIN_ERR);
            //PIN码验证错误码暂存在ErrorCodeUtil pinErrorCode字段
            ErrorCodeUtil.pinErrorCode = ret;
            return;
        }

        //3. 登录
        CertLoginManager certLoginManager = new CertLoginManager();
        result = certLoginManager.login(context, bundle);
        sendMessage(result);
    }

    @Override
    protected void sendMessage(int errorCode) {
        CallbackAppUtil.getInstance().setErrorCode(errorCode);
        super.sendMessage(errorCode);
    }
}
