package com.xdja.uniteauth.domain;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;

import com.xdja.uniteauth.UniteAuthConfig;
import com.xdja.uniteauth.jar.ErrorCode;
import com.xdja.uniteauth.jar.ParamKeywords;
import com.xdja.uniteauth.utils.CallbackAppUtil;
import com.xdja.uniteauth.utils.ErrorCodeUtil;
import com.xdja.uniteauth.utils.SafeCardUtil;
import com.xdja.uniteauth.utils.UacConstant;

/**
 * Author:kongguoguang
 * Date:2019/8/22
 * Time:11:38
 * Summary:
 * @author kgg
 */
public class GetAuthCodeThread extends ThreadWithMainHandler {

    public static final String THREAD_NAME = "GetAuthCodeThread";

    private String appId;

    private String random;

    private String pin;

    private Context context;

    public GetAuthCodeThread(Context context, Handler handler, Bundle bundle) {
        super(THREAD_NAME, handler);
        this.context = context;
        this.appId = bundle.getString(UacConstant.KEY_CLIENT_ID);
        this.random = bundle.getString(ParamKeywords.KEY_String_random);
        this.pin = "";
    }


    public GetAuthCodeThread(Context context, Handler handler, Bundle bundle, String pin) {
        super(THREAD_NAME, handler);
        this.context = context;
        this.appId = bundle.getString(UacConstant.KEY_CLIENT_ID);
        this.random = bundle.getString(ParamKeywords.KEY_String_random);
        this.pin = pin;
    }

    @Override
    public void run() {
        super.run();
        int result;
        //流程：
        //1. 先判断关于needFirstInputPin这个相关的属性
        //2. 得到PIN
        //3. 验证PIN是否正确
        //4. 得到授权码

        //1. 先判断关于needFirstInputPin这个相关的属性
        boolean flag = UniteAuthConfig.getInstance(context).judgeInputPinFlag();
        if (!flag) {
            sendMessage(ErrorCode.RET_NEED_VERIFY_PIN);
            return;
        }


        //2. 得到PIN
        if (TextUtils.isEmpty(pin)) {
            pin = SafeCardUtil.getInstance().getPin();
        }
        if (TextUtils.isEmpty(pin)) {
            sendMessage(ErrorCode.RET_GET_PIN_NULL);
            return;
        }

        //3. 验证PIN是否正确
        int ret = SafeCardUtil.getInstance().verifyPin(pin);
        if (ret != 0) {
            sendMessage(ErrorCode.RET_VERIFY_SAFE_PIN_ERR);
            //PIN码验证错误码暂存在ErrorCodeUtil pinErrorCode字段
            ErrorCodeUtil.pinErrorCode = ret;
            return;
        }

        //4. 得到授权码
        result = GetAuthCodeManager.getInstance(context).getAuthCode(random, appId);
        sendMessage(result);
    }

    @Override
    protected void sendMessage(int errorCode) {
        CallbackAppUtil.getInstance().setErrorCode(errorCode);
        super.sendMessage(errorCode);
    }
}
