package com.xdja.uniteauth.domain;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Pair;

import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.uniteauth.ThreadPoolManager;
import com.xdja.uniteauth.UniteAuthConfig;
import com.xdja.uniteauth.jar.ErrorCode;
import com.xdja.uniteauth.jar.IRealCallback;
import com.xdja.uniteauth.jar.ParamKeywords;
import com.xdja.uniteauth.utils.SafeCardUtil;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/1/2 <br/>
 * <p>
 * 没有界面的获取code码流程
 */
public class GetAuthCodeWithoutActivity {
    //不要改为单例

    private IRealCallback callback;
    private String random;

    public int getAuthCode(final Context context, final Bundle bundle) {

        if (context == null) {
            throw new NullPointerException("Context is null!");
        }

        final IRealCallback callback = IRealCallback.Stub.asInterface(bundle.getBinder(ParamKeywords.KEY_Binder_callbackBinder));
        final String random = bundle.getString(ParamKeywords.KEY_String_random, "");

        if (callback == null || TextUtils.isEmpty(random)) {
            return ErrorCode.RET_KEY_PARAM_NULL;
        }

        this.callback = callback;
        this.random = random;

        ThreadPoolManager.getInstance().execute(new Runnable() {
            @Override
            public void run() {
                //流程：
                //0. 先判断关于needFirstInputPin这个相关的属性
                //1. 先验证APK是否合法
                //2. 得到PIN
                //3. 验证PIN是否正确
                //4. 得到授权码

                int ret;

                //0. 先判断关于needFirstInputPin这个相关的属性
                boolean flag = UniteAuthConfig.getInstance(context).judgeInputPinFlag();
                if (!flag) {
                    callbackError(ErrorCode.RET_NEED_VERIFY_PIN);
                }

                //1.先验证APK是否合法
                Pair<Integer, String> verifyPkgPair = GetAuthCodeManager.getInstance(context).verifyPkg(bundle);
                ret = verifyPkgPair.first;
                if (ret != 0) {
                    callbackError(ret);
                    return;
                }
                String appId = verifyPkgPair.second;

                //2. 得到PIN
                String cardId = bundle.getString(ParamKeywords.KEY_String_cardId, "");
                int cardType = bundle.getInt(ParamKeywords.KEY_int_cardType, -1);
                JarJniApiProxy jarJniApiProxy = SafeCardUtil.getInstance().getJniApiProxy(context, cardId, cardType);
                if (jarJniApiProxy == null) {
                    callbackError(ErrorCode.RET_OPEN_SAFE_CHIP_FAIL);
                    return;
                }

                String defaultSn = SafeCardUtil.getInstance().getSn();
                if (TextUtils.isEmpty(defaultSn)) {
                    callbackError(ErrorCode.RET_GET_CERT_SN_FAIL);
                    return;
                }

                String pin = SafeCardUtil.getInstance().getPin();
                if (TextUtils.isEmpty(pin)) {
                    callbackError(ErrorCode.RET_GET_PIN_NULL);
                    return;
                }

                //3. 验证PIN是否正确
                ret = SafeCardUtil.getInstance().verifyPin(pin);
                if (ret != 0) {
                    callbackError(ret);
                    return;
                }

                //4. 得到授权码
                GetAuthCodeManager.getInstance(context).getAuthCodeWithoutActivity(random, appId, callback);
            }
        });
        return 0;
    }


    /**
     * 错误时回调
     *
     * @param ret
     */
    private void callbackError(int ret) {
        try {
            callback.callback(random, ret, "", "");
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

}
