package com.xdja.uniteauth.domain;

import com.google.gson.Gson;
import com.xdja.uniteauth.data.ApiGen;
import com.xdja.uniteauth.data.net.model.ErrInfoBean;
import com.xdja.uniteauth.data.net.model.GetAuthModeRequest;
import com.xdja.uniteauth.data.net.model.GetAuthModeResponse;
import com.xdja.uniteauth.data.net.model.UASResponseBean;
import com.xdja.uniteauth.utils.AuthModeUtil;
import com.xdja.uniteauth.utils.ErrorCodeUtil;

/**
 * Author:kongguoguang
 * Date:2019/8/20
 * Time:20:06
 * Summary:
 * @author kgg
 */
public class GetAuthModeManager {

    public int getAuthMode(GetAuthModeRequest request) {
        try {
            AuthModeUtil.getInstance().reset();
            UASResponseBean uasResponseBean = ApiGen.getUnitAuthApi().getAuthMode(request.getClient_id(),
                    request.getRedirect_uri(), request.getScope(), request.getResponse_type());
            Gson gson = new Gson();
            if (uasResponseBean.isIsSuccess()) {
                GetAuthModeResponse authModeResponse = gson.fromJson(
                        gson.toJson(uasResponseBean.getInfo()), GetAuthModeResponse.class);
                AuthModeUtil.getInstance().saveAuthModeResponse(authModeResponse);
                return 0;
            } else {
                ErrInfoBean errInfoBean = gson.fromJson(gson.toJson(uasResponseBean.getInfo()), ErrInfoBean.class);
                return errInfoBean.getErrCode();
            }

        } catch (Exception e) {
            e.printStackTrace();
            return ErrorCodeUtil.getErrorCode(e);
        }
    }

}
