package com.xdja.uniteauth.domain;

import android.os.Handler;

import com.xdja.uniteauth.ApplicationContext;
import com.xdja.uniteauth.data.net.model.GetAuthModeRequest;
import com.xdja.uniteauth.utils.CallbackAppUtil;

/**
 * Author:kongguoguang
 * Date:2019/9/17
 * Time:10:49
 * Summary:
 *
 * @author kgg
 */
public class GetAuthModeThread extends ThreadWithMainHandler {

    public static final String THREAD_NAME = "GetAuthModeThread";

    private GetAuthModeRequest getAuthModeRequest;

    public GetAuthModeThread(Handler handler, GetAuthModeRequest getAuthModeRequest) {
        super(THREAD_NAME, handler);
        this.getAuthModeRequest = getAuthModeRequest;
    }

    @Override
    public void run() {
        GetAuthModeManager getAuthModeManager = new GetAuthModeManager();
        int result = getAuthModeManager.getAuthMode(getAuthModeRequest);
        if (result != 0) {
            CallbackAppUtil.getInstance().setErrorCode(result);
        }
        sendMessage(result);
    }
}
