package com.xdja.uniteauth.domain;

import android.os.Bundle;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.xdja.uniteauth.data.ApiGen;
import com.xdja.uniteauth.data.net.model.ErrInfoBean;
import com.xdja.uniteauth.data.net.model.GetChallengeResponse;
import com.xdja.uniteauth.data.net.model.LoginRequest;
import com.xdja.uniteauth.data.net.model.LoginResponse;
import com.xdja.uniteauth.data.net.model.UASResponseBean;
import com.xdja.uniteauth.jar.ErrorCode;
import com.xdja.uniteauth.utils.CallbackAppUtil;
import com.xdja.uniteauth.utils.ErrorCodeUtil;
import com.xdja.uniteauth.utils.UacConstant;
import com.xdja.uniteauth.utils.UserInfoUtil;

/**
 * Author:kongguoguang
 * Date:2019/9/23
 * Time:10:37
 * Summary:
 *
 * @author kgg
 */
public class UserPwdLoginManager {

    private String clientId;
    private String state;
    private String scope;
    private String redirectUri;
    private String userName;
    private String password;
    private Gson gson = new Gson();


    public int login(String userName, String password, Bundle bundle) {
        this.userName = userName;
        this.password = password;
        scope = bundle.getString(UacConstant.KEY_SCOPE);
        state = bundle.getString(UacConstant.KEY_STATE);
        clientId = bundle.getString(UacConstant.KEY_CLIENT_ID);
        redirectUri = bundle.getString(UacConstant.KEY_REDIRECT_URI);
        try {
            UASResponseBean uasResponseBean = ApiGen.getUnitAuthApi().getChallenge();
            if (uasResponseBean == null) {
                return ErrorCode.RET_SERVER_RETURN_ERR;
            }

            if (uasResponseBean.isIsSuccess()) {
                GetChallengeResponse getChallengeResponse =
                        gson.fromJson(gson.toJson(uasResponseBean.getInfo()), GetChallengeResponse.class);
                return login(getChallengeResponse);
            } else {
                ErrInfoBean errInfoBean = gson.fromJson(gson.toJson(uasResponseBean.getInfo()), ErrInfoBean.class);
                return errInfoBean.getErrCode();
            }
        } catch (Exception e) {
            return ErrorCodeUtil.getErrorCode(e);
        }
    }

    private int login(GetChallengeResponse challengeResponse) {
        String challenge = challengeResponse.getChallengeStr();
        int index = challengeResponse.getIndex();

        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setScope(scope);
        loginRequest.setState(state);
        loginRequest.setClient_id(clientId);
        loginRequest.setRedirect_uri(redirectUri);
        loginRequest.setClientType(UacConstant.CLIENT_TYPE);
        loginRequest.setUname(userName);
        loginRequest.setPwd(password);
        loginRequest.setChallenge(challenge);
        loginRequest.setIndex(index + "");
        loginRequest.setAuthMode(UacConstant.AUTH_MODE_USER_PWD);

        try {
            UASResponseBean uasResponseBean = ApiGen.getUnitAuthApi().login(loginRequest);
            if (uasResponseBean == null) {
                return ErrorCode.RET_SERVER_RETURN_ERR;
            }

            if (uasResponseBean.isIsSuccess()) {
                LoginResponse loginResponse = gson.fromJson(gson.toJson(uasResponseBean.getInfo()), LoginResponse.class);
                if (TextUtils.isEmpty(loginResponse.getUname())) {
                    loginResponse.setUname(userName);
                }
                loginResponse.setUserName(userName);
                loginResponse.setPassword(password);
                UserInfoUtil.getInstance().saveUserInfo(loginResponse);
                CallbackAppUtil.getInstance().saveLoginResponse(loginResponse);
                return 0;
            } else {
                ErrInfoBean errInfoBean = gson.fromJson(gson.toJson(uasResponseBean.getInfo()), ErrInfoBean.class);
                if (ErrorCodeUtil.isIdpError(errInfoBean.getErrCode())) {
                    ErrorCodeUtil.idpErrorMsg = errInfoBean.getDesc();
                }
                return errInfoBean.getErrCode();
            }
        } catch (Exception e) {
            e.printStackTrace();
            return ErrorCodeUtil.getErrorCode(e);
        }
    }
}
