package com.xdja.uniteauth.domain;


import android.os.Bundle;
import android.os.Handler;

import com.xdja.uniteauth.utils.CallbackAppUtil;

/**
 * Author:kongguoguang
 * Date:2019/8/22
 * Time:9:05
 * Summary:该线程用于用户名密码登录，成功后通过handler通知界面更新
 * @author kgg
 */
public class UserPwdLoginThread extends ThreadWithMainHandler {

    public static final String THREAD_NAME = "UserPwdLoginThread";

    private String userName;

    private String password;

    private Bundle bundle;

    public UserPwdLoginThread(Handler handler, String userName, String password, Bundle bundle) {
        super(THREAD_NAME, handler);
        this.userName = userName;
        this.password = password;
        this.bundle = bundle;
    }

    @Override
    public void run() {
        super.run();
        UserPwdLoginManager userPwdLoginManager = new UserPwdLoginManager();
        int errorCode = userPwdLoginManager.login(userName, password, bundle);
        CallbackAppUtil.getInstance().setErrorCode(errorCode);
        sendMessage(errorCode);
    }
}
