package com.xdja.uniteauth.domain;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Pair;

import com.xdja.uniteauth.ApplicationContext;
import com.xdja.uniteauth.data.net.model.GetAuthModeRequest;
import com.xdja.uniteauth.jar.ErrorCode;
import com.xdja.uniteauth.utils.CallbackAppUtil;
import com.xdja.uniteauth.utils.UacConstant;

/**
 * Author:kongguoguang
 * Date:2019/9/26
 * Time:20:02
 * Summary:
 *
 * @author kgg
 */
public class VerifyPkgAndGetAuthModeThread extends ThreadWithMainHandler {

    public static final String THREAD_NAME = "VerifyPkgAndGetAuthModeThread";

    private Context context;
    private Bundle bundle;

    public VerifyPkgAndGetAuthModeThread(Handler handler, Context context, Bundle bundle) {
        super(THREAD_NAME, handler);
        this.context = context;
        this.bundle = bundle;
    }

    @Override
    public void run() {
        super.run();
        int ret = 0;
        //第一步，检查apk合法性
        Pair<Integer, String> verifyPkgPair = GetAuthCodeManager.getInstance(context).verifyPkg(bundle);
        ret = verifyPkgPair.first;
        if (ret != 0) {
            sendMessage(ret);
            return;
        }

        String appId = verifyPkgPair.second;
        if (TextUtils.isEmpty(appId)) {
            sendMessage(ErrorCode.RET_APP_ID_NULL);
            return;
        }

        bundle.putString(UacConstant.KEY_CLIENT_ID, appId);

        //第二步，获取AuthMode
        GetAuthModeManager getAuthModeManager = new GetAuthModeManager();
        GetAuthModeRequest getAuthModeRequest = new GetAuthModeRequest();
        getAuthModeRequest.setClient_id(appId);
        ret = getAuthModeManager.getAuthMode(getAuthModeRequest);
        sendMessage(ret);
    }

    @Override
    protected void sendMessage(int errorCode) {
        if (errorCode != 0) {
            CallbackAppUtil.getInstance().setErrorCode(errorCode);
        }
        super.sendMessage(errorCode);
    }
}
