package com.xdja.uniteauth.domain;

import android.os.Bundle;
import android.os.Handler;

import com.xdja.uniteauth.utils.CallbackAppUtil;

/**
 * Author:kongguoguang
 * Date:2019/9/25
 * Time:11:13
 * Summary:
 *
 * @author kgg
 */
public class VerifyUserPwdThread extends ThreadWithMainHandler {

    public static final String THREAD_NAME = "VerifyUserPwdThread";

    private String userName;

    private String password;

    private Bundle bundle;

    public VerifyUserPwdThread(Handler handler, String userName, String password, Bundle bundle) {
        super(THREAD_NAME, handler);
        this.userName = userName;
        this.password = password;
        this.bundle = bundle;
    }

    @Override
    public void run() {
        super.run();
        UserPwdLoginManager userPwdLoginManager = new UserPwdLoginManager();
        int errorCode = userPwdLoginManager.login(userName, password, bundle);
        CallbackAppUtil.getInstance().setErrorCode(errorCode);
        sendMessage(errorCode);
    }

}
