package com.xdja.uniteauth.presenter;

import android.os.Bundle;
import android.support.design.widget.BottomSheetDialog;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.GridView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.uniteauth.AuthModeGridAdapter;
import com.xdja.uniteauth.R;
import com.xdja.uniteauth.bean.LoginMode;
import com.xdja.uniteauth.jar.ParamKeywords;
import com.xdja.uniteauth.utils.AuthModeUtil;
import com.xdja.uniteauth.utils.DisplayUtil;
import com.xdja.uniteauth.utils.SettingInfoUtil;
import com.xdja.uniteauth.utils.UacConstant;
import com.xdja.uniteauth.view.UacTitleBar;

import java.util.ArrayList;
import java.util.List;

/**
 * @author kgg
 * 用户名密码、证书认证基类
 */
public class BaseLoginActivity extends UacBaseActivity {

    protected Bundle bundle;

    private BottomSheetDialog bottomSheetDialog;

    private GridView gridView;
    private List<LoginMode> otherLoginModes = new ArrayList<>();
    private AuthModeGridAdapter adapter = new AuthModeGridAdapter(otherLoginModes);

    protected LoginMode currentLoginMode;

    /**
     * 防止连续点击
     */
    private long lastClickTime = 0L;

    private final int interval = 1000;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        bundle = getIntent().getBundleExtra(ParamKeywords.KEY_Bundle_bundle);
    }

    protected void initTitle() {
        UacTitleBar titleBar = (UacTitleBar) findViewById(R.id.uac_title_bar);
        titleBar.setBackListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });

        if (AuthModeUtil.getInstance().isSupportFingerprintLogin() ||
                AuthModeUtil.getInstance().isSupportGestureLogin()) {

            titleBar.setSettingListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    bundle.putBoolean(UacConstant.KEY_NEED_VERIFY_IDENTITY, true);
                    bundle.putBoolean(UacConstant.KEY_ENABLE_GESTURE, false);
                    bundle.putBoolean(UacConstant.KEY_ENABLE_FINGERPRINT, false);
                    gotoSettingActivity(bundle);
                }
            });
        }
    }

    protected void initView() {
        gridView = (GridView) findViewById(R.id.grid_view);
        gridView.setAdapter(adapter);
        gridView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastClickTime < interval) {
                    return;
                }
                lastClickTime = currentTime;
                LoginMode loginMode = otherLoginModes.get(position);
                changeLoginMode(loginMode);
            }
        });
    }

    protected void initBottomSheetDialog() {
        bottomSheetDialog = new BottomSheetDialog(this, R.style.BottomSheetDialog);
        bottomSheetDialog.setCancelable(false);
        View view;
        if (AuthModeUtil.getInstance().isSupportFingerprintLogin() && AuthModeUtil.getInstance().isSupportGestureLogin()) {
            view = getLayoutInflater().inflate(R.layout.uac_layout_enable_fingerprint_gesture, null);
        } else if (AuthModeUtil.getInstance().isSupportFingerprintLogin()) {
            view = getLayoutInflater().inflate(R.layout.uac_layout_enable_fingerprint, null);
        } else {
            view = getLayoutInflater().inflate(R.layout.uac_layout_enable_gesture, null);
        }
        bottomSheetDialog.setContentView(view);
        TextView skip = (TextView) view.findViewById(R.id.tv_skip);
        skip.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                SettingInfoUtil.getInstance().setRecommendFingerprintAndGesture(false);
                bottomSheetDialog.dismiss();
                finish();
            }
        });

        final Button enableFingerprintLogin = (Button) view.findViewById(R.id.bt_enable_fingerprint_login);
        enableFingerprintLogin.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                enableFingerprintLogin();
            }
        });

        Button enableGestureLogin = (Button) view.findViewById(R.id.bt_enable_gesture_login);
        enableGestureLogin.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                enableGestureLogin();
            }
        });
    }

    /**
     * 切换登录方式
     *
     * @param loginMode 新的登录方式
     */
    protected void changeLoginMode(LoginMode loginMode) {

    }

    /**
     * 刷新界面底部其他认证方式列表
     */
    protected void refreshOtherLoginMode() {
        otherLoginModes.clear();
        adapter.notifyDataSetChanged();
        if (AuthModeUtil.getInstance().getLoginModeList().size() == 1) {
            gridView.setVisibility(View.INVISIBLE);
            return;
        }

        gridView.setVisibility(View.VISIBLE);
        for (LoginMode loginMode : AuthModeUtil.getInstance().getLoginModeList()) {
            if (loginMode != currentLoginMode) {
                otherLoginModes.add(loginMode);
            }
        }
        adapter.notifyDataSetChanged();
        int count = otherLoginModes.size();
        if (count == 0) {
            gridView.setVisibility(View.GONE);
        } else {
            gridView.setVisibility(View.VISIBLE);
            gridView.setNumColumns(count);
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) gridView.getLayoutParams();
            layoutParams.width = DisplayUtil.dp2px(getApplicationContext(), count * 88) + DisplayUtil.dp2px(getApplicationContext(), count - 1);
            gridView.setLayoutParams(layoutParams);
        }
    }

    /**
     * 开启指纹登录
     */
    private void enableFingerprintLogin() {
        bottomSheetDialog.dismiss();
        bundle.putBoolean(UacConstant.KEY_NEED_VERIFY_IDENTITY, false);
        bundle.putBoolean(UacConstant.KEY_ENABLE_FINGERPRINT, true);
        bundle.putBoolean(UacConstant.KEY_ENABLE_GESTURE, false);
        gotoSettingActivity(bundle);
        finish();
    }

    /**
     * 开启手势登录
     */
    private void enableGestureLogin() {
        bottomSheetDialog.dismiss();
        bundle.putBoolean(UacConstant.KEY_NEED_VERIFY_IDENTITY, false);
        bundle.putBoolean(UacConstant.KEY_ENABLE_GESTURE, true);
        bundle.putBoolean(UacConstant.KEY_ENABLE_FINGERPRINT, false);
        gotoSettingActivity(bundle);
        finish();
    }

    /**
     * 推荐用户开启指纹/手势登录
     */
    protected void recommendFingerprintGesture() {
        if (SettingInfoUtil.getInstance().isRecommendFingerprintAndGesture()) {
            bottomSheetDialog.show();
        } else {
            finish();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (bottomSheetDialog != null) {
            bottomSheetDialog.dismiss();
        }
    }
}
