package com.xdja.uniteauth.presenter;


import android.os.Bundle;
import android.view.View;

import com.xdja.uniteauth.R;
import com.xdja.uniteauth.utils.AuthModeUtil;
import com.xdja.uniteauth.utils.SettingInfoUtil;
import com.xdja.uniteauth.view.UacFingerprintDialog;
import com.xdja.uniteauth.view.UacTitleBar;

/**
 * @author kgg
 */
public class FingerprintSettingActivity extends UacBaseActivity {

    private UacFingerprintDialog dialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.uac_activity_fingerprint_setting);

        UacTitleBar titleBar = (UacTitleBar) findViewById(R.id.uac_title_bar);
        titleBar.setBackListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });

        View view = findViewById(R.id.layout_fingerprint);
        view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.show();
            }
        });

        if (AuthModeUtil.getInstance().isSupportSoterFingerprint()) {
            dialog = new UacFingerprintDialog(this, UacFingerprintDialog.FINGERPRINT_TYPE_SOTER);
        } else {
            dialog = new UacFingerprintDialog(this, UacFingerprintDialog.FINGERPRINT_TYPE_SYSTEM);
        }

        dialog.setSuccessCallback(new UacFingerprintDialog.SuccessCallback() {
            @Override
            public void onSuccess(String fid) {
                SettingInfoUtil.getInstance().setFingerprintId(fid);
                dialog.dismiss();
                setResult(RESULT_OK);
                finish();
            }
        });
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (!dialog.isShowing()) {
            dialog.show();
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }
}
