package com.xdja.uniteauth.presenter;


import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import com.andrognito.patternlockview.PatternLockView;
import com.andrognito.patternlockview.listener.PatternLockViewListener;
import com.andrognito.patternlockview.utils.PatternLockUtils;
import com.xdja.uniteauth.R;
import com.xdja.uniteauth.utils.SettingInfoUtil;
import com.xdja.uniteauth.view.UacTitleBar;

import java.util.List;

/**
 * @author kgg
 */
public class GestureSettingActivity extends UacBaseActivity implements PatternLockViewListener {

    private PatternLockView patternLockView;

    private PatternLockView smallPatternLockView;

    private boolean isFirstDraw = true;

    private String firstGesturePwd;

    private String secondGesturePwd;

    private TextView textTips;

    private int gesturePwdWrongColor;

    private int gesturePwdNormalColor;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.uac_activity_gesture_setting);
        initView();
    }

    private void initView() {

        UacTitleBar uacTitleBar = (UacTitleBar) findViewById(R.id.uac_title_bar);
        uacTitleBar.setBackListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });

        textTips = (TextView) findViewById(R.id.tv_gesture_tips);

        patternLockView = (PatternLockView) findViewById(R.id.pattern_lock_view);
        patternLockView.addPatternLockListener(this);

        smallPatternLockView = (PatternLockView) findViewById(R.id.small_pattern_lock_view);
        smallPatternLockView.setInputEnabled(false);//不可输入
        smallPatternLockView.setInStealthMode(true);//不绘制连接线

        gesturePwdNormalColor = Color.parseColor("#5F5F5F");
        gesturePwdWrongColor = Color.parseColor("#CD4849");
    }

    @Override
    public void onStarted() {
        textTips.setTextColor(gesturePwdNormalColor);
        textTips.setText(R.string.uac_release_finger);
        smallPatternLockView.clearPattern();
    }


    @Override
    public void onProgress(List<PatternLockView.Dot> progressPattern) {
        smallPatternLockView.setPattern(PatternLockView.PatternViewMode.CORRECT, progressPattern);
    }

    @Override
    public void onComplete(List<PatternLockView.Dot> pattern) {
        if (isFirstDraw) {
            firstGesturePwd = PatternLockUtils.patternToSha1(patternLockView, pattern);
            checkFirstDraw(pattern);
        } else {
            secondGesturePwd = PatternLockUtils.patternToSha1(patternLockView, pattern);
            checkSecondDraw(pattern);
        }

        patternLockView.clearPattern();
    }

    @Override
    public void onCleared() {

    }


    private void checkFirstDraw(List<PatternLockView.Dot> dots) {
        if (dots.size() < 4) {
            textTips.setTextColor(gesturePwdWrongColor);
            textTips.setText(R.string.uac_at_least_four_dots);
        } else {
            textTips.setTextColor(gesturePwdNormalColor);
            textTips.setText(R.string.uac_gesture_draw_again);
            isFirstDraw = false;
        }
    }

    private void checkSecondDraw(List<PatternLockView.Dot> dots) {
        if (dots.size() < 4) {
            textTips.setTextColor(gesturePwdWrongColor);
            textTips.setText(R.string.uac_at_least_four_dots);
        } else if (!secondGesturePwd.equals(firstGesturePwd)) {
            textTips.setTextColor(gesturePwdWrongColor);
            textTips.setText(R.string.uac_gesture_not_same);
        } else {
            SettingInfoUtil.getInstance().setGesturePwd(secondGesturePwd);
            setResult(RESULT_OK);
            finish();
        }
    }
}
