package com.xdja.uniteauth.presenter;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import com.xdja.uniteauth.R;
import com.xdja.uniteauth.jar.ParamKeywords;
import com.xdja.uniteauth.utils.AuthModeUtil;
import com.xdja.uniteauth.utils.UserInfoUtil;

/**
 * @author kgg
 */
public class IdpChangedActivity extends UacBaseActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.uac_activity_idp_changed);

        final Bundle bundle = getIntent().getBundleExtra(ParamKeywords.KEY_Bundle_bundle);

        TextView tips = (TextView) findViewById(R.id.tv_tips);
        tips.setText(R.string.uac_idp_changed);

        final TextView changeUser = (TextView) findViewById(R.id.tv_change_user);
        changeUser.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                UserInfoUtil.getInstance().clearUserInfo();
                if (AuthModeUtil.getInstance().isCertAuthMode()) {
                    gotoCertLoginActivity(bundle);
                } else {
                    gotoUserLoginActivity(bundle);
                }
            }
        });
    }
}
