package com.xdja.uniteauth.presenter;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.util.Log;

import com.xdja.uniteauth.R;
import com.xdja.uniteauth.ThreadPoolManager;
import com.xdja.uniteauth.data.net.model.GetAuthModeRequest;
import com.xdja.uniteauth.domain.GetAuthModeThread;
import com.xdja.uniteauth.utils.AuthModeUtil;
import com.xdja.uniteauth.utils.CallbackAppUtil;
import com.xdja.uniteauth.utils.ErrorCodeUtil;
import com.xdja.uniteauth.utils.UacActivityManager;
import com.xdja.uniteauth.utils.UacColorConfig;
import com.xdja.uniteauth.utils.UacConstant;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

/**
 * @author kgg
 */
public class UacInitActivity extends UacBaseActivity {

    private final String TAG = "UacInitActivityTag";

    private String scope;
    private String responseType;
    private String clientId;
    private String redirectUri;
    private String state;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Log.d(TAG, "onCreate()");
        super.onCreate(savedInstanceState);
        UacActivityManager.getInstance().removeOtherActivity(this);
        parseUri(getIntent());
    }

    private void parseUri(Intent intent) {
        Log.d(TAG, "parseUri()");
        ThreadPoolManager.getInstance().shutdownNow();
        Uri uri = intent.getData();
        //uri不为空，说明是通过Scheme方式启动的
        if (uri != null) {
            Log.d(TAG, "uri authority = " + uri.getAuthority());

            scope = uri.getQueryParameter(UacConstant.KEY_SCOPE);
            responseType = uri.getQueryParameter(UacConstant.KEY_RESPONSE_TYPE);
            clientId = uri.getQueryParameter(UacConstant.KEY_CLIENT_ID);
            redirectUri = uri.getQueryParameter(UacConstant.KEY_REDIRECT_URI);
            state = uri.getQueryParameter(UacConstant.KEY_STATE);
            String agentUri = uri.getQueryParameter(UacConstant.KEY_AGENT);
            try {
                agentUri = URLDecoder.decode(agentUri, "UTF-8");
                if (agentUri.endsWith("?")){
                    agentUri = agentUri.substring(0, agentUri.length() - 1);
                }
            } catch (Exception e){
                e.printStackTrace();
            }

            UacColorConfig.getInstance().resetColor();
            CallbackAppUtil.getInstance().setRedirectUri(redirectUri);
            CallbackAppUtil.getInstance().setState(state);
            CallbackAppUtil.getInstance().setAgentUri(agentUri);

            GetAuthModeRequest getAuthModeRequest = new GetAuthModeRequest();
            getAuthModeRequest.setClient_id(clientId);
            getAuthModeRequest.setRedirect_uri(redirectUri);
            getAuthModeRequest.setResponse_type(responseType);
            getAuthModeRequest.setScope(scope);
            getAuthMode(getAuthModeRequest);
        } else {
            showToast(R.string.str_param_err);
            finish();
        }

    }

    @Override
    public void handleThreadMessage(Message msg) {
        super.handleThreadMessage(msg);

        int resultCode = msg.what;
        handleGetAuthModeResult(resultCode);

    }

    /**
     * 获取认证方式
     */
    private void getAuthMode(GetAuthModeRequest getAuthModeRequest) {
        Log.d(TAG, "getAuthMode()");
        showLoadingDialog(R.string.uac_load_ing);
        ThreadPoolManager.getInstance().execute(new GetAuthModeThread(uacHandler, getAuthModeRequest));
    }

    /**
     * 处理获取认证方式结果
     */
    private void handleGetAuthModeResult(int resultCode) {
        //获取认证方式结果处理
        if (resultCode == 0) {
            Bundle bundle = new Bundle();
            bundle.putString(UacConstant.KEY_SCOPE, scope);
            bundle.putString(UacConstant.KEY_RESPONSE_TYPE, responseType);
            bundle.putString(UacConstant.KEY_CLIENT_ID, clientId);
            bundle.putString(UacConstant.KEY_REDIRECT_URI, redirectUri);
            bundle.putString(UacConstant.KEY_STATE, state);
            if (AuthModeUtil.getInstance().isDifferentIdp()) {
                gotoIdpChangedActivity(bundle);
            } else if (AuthModeUtil.getInstance().isCertAuthMode()) {
                gotoCertLoginActivity(bundle);
            } else {
                gotoUserLoginActivity(bundle);
            }

        } else if (ErrorCodeUtil.isServerErrCode(resultCode)) {

            if (!ErrorCodeUtil.isInvalidScope(resultCode) &&
                    !ErrorCodeUtil.isUnsupportedResponseType(resultCode)) {
                showErrorToast(resultCode);
            }
        } else {
            showErrorToast(resultCode);
        }

        finish();
    }

}
