package com.xdja.uniteauth.presenter;


import android.os.Bundle;
import android.os.Message;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.TextView;

import com.xdja.uniteauth.R;
import com.xdja.uniteauth.ThreadPoolManager;
import com.xdja.uniteauth.domain.VerifyUserPwdThread;
import com.xdja.uniteauth.jar.ParamKeywords;
import com.xdja.uniteauth.utils.UacConstant;
import com.xdja.uniteauth.view.UacTitleBar;

/**
 * @author kgg
 */
public class VerifyUserPwdActivity extends UacBaseActivity {

    private TextView tips;

    private EditText userNameEt;

    private EditText passwordEt;

    private Button commitBt;

    private Bundle bundle;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.uac_activity_verify_user_pwd);
        initView();
        initData();
    }

    private void initView() {

        UacTitleBar titleBar = (UacTitleBar) findViewById(R.id.uac_title_bar);
        titleBar.setBackListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });

        tips = (TextView) findViewById(R.id.tv_tips);

        userNameEt = (EditText) findViewById(R.id.et_user_name);
        userNameEt.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                setViewEnable(commitBt, s.length() > 0 && passwordEt.length() > 0);
            }
        });

        passwordEt = (EditText) findViewById(R.id.et_pin);
        passwordEt.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                setViewEnable(commitBt, s.length() > 0 && userNameEt.length() > 0);
            }
        });

        passwordEt.setTransformationMethod(PasswordTransformationMethod.getInstance());

        CheckBox checkBox = (CheckBox) findViewById(R.id.checkbox);
        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {//显示密码
                    passwordEt.setTransformationMethod(HideReturnsTransformationMethod.getInstance());
                } else {//隐藏密码
                    passwordEt.setTransformationMethod(PasswordTransformationMethod.getInstance());
                }
                //光标放置到最后面
                passwordEt.setSelection(passwordEt.length());
            }
        });

        commitBt = (Button) findViewById(R.id.bt_commit);
        commitBt.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                login();
            }
        });
        setViewEnable(commitBt, false);

    }

    private void initData() {
        bundle = getIntent().getBundleExtra(ParamKeywords.KEY_Bundle_bundle);

        int operateType = getIntent().getIntExtra(UacConstant.KEY_OPERATE_TYPE, UacSettingActivity.OPERATE_TYPE_ENABLE_FINGERPRINT);
        if (operateType == UacSettingActivity.OPERATE_TYPE_ENABLE_GESTURE) {
            tips.setText(getString(R.string.uac_verify_password_tips, getString(R.string.uac_gesture)));
        } else {
            tips.setText(getString(R.string.uac_verify_password_tips, getString(R.string.uac_fingerprint)));
        }
    }

    private void login() {
        String userName = userNameEt.getText().toString();
        String password = passwordEt.getText().toString();

        showLoadingDialog(R.string.uac_verify_ing);
        ThreadPoolManager.getInstance().execute(
                new VerifyUserPwdThread(uacHandler, userName, password, bundle));
    }

    @Override
    public void handleThreadMessage(Message msg) {
        super.handleThreadMessage(msg);
        if (msg.what == 0) {
            setResult(RESULT_OK);
            finish();
        } else {
            showErrorDialog(msg.what);
        }
    }
}
