package com.xdja.uniteauth.utils;

import android.app.Activity;

import java.util.Stack;

/**
 * @author kongguoguang
 * Date:2019/8/19
 * Time:13:50
 * Summary:
 */
public class UacActivityManager {

    private Stack<Activity> stack = new Stack<>();

    private static UacActivityManager instance = new UacActivityManager();

    public static UacActivityManager getInstance() {
        return instance;
    }

    public void addActivity(Activity activity) {
        stack.push(activity);
    }

    public void removeActivity(Activity activity) {
        stack.remove(activity);
        if (stack.empty()) {
            CallbackAppUtil.getInstance().callbackApp(activity);
        }
    }

    public void removeOtherActivity(Activity activity) {
        for (Activity anActivity : stack) {
            if (anActivity == activity) {
                continue;
            }
            anActivity.finish();
        }
    }

    public int activityCount() {
        return stack.size();
    }

    /**
     * 是否为最后一个Activity
     */
    public boolean isLastActivity() {
        return stack.empty();
    }

    public void finishAllActivity() {
        for (Activity activity : stack) {
            if (activity.isFinishing()) {
                continue;
            }
            activity.finish();
        }
    }
}
