package com.xdja.uniteauth.utils;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;

import com.xdja.uniteauth.R;

/**
 * Author:kongguoguang
 * Date:2019/10/12
 * Time:14:19
 * Summary:
 *
 * @author kgg
 */
public class UacColorConfig {

    private static final UacColorConfig INSTANCE = new UacColorConfig();

    public static UacColorConfig getInstance() {
        return INSTANCE;
    }

    private UacColorConfig() {
    }

    private final char COLOR_PREFIX = '#';

    /**
     * 默认颜色
     */
    private int defaultColor;

    /**
     * 标题栏颜色, 默认#00D176
     */
    private int titleBarColor = -16723594;

    /**
     * 其他颜色, 默认#00D176
     */
    private int otherColor = -16723594;

    public void init(Context context) {
        defaultColor = ContextCompat.getColor(context, R.color.uac_default_color);
        titleBarColor = defaultColor;
        otherColor = defaultColor;
    }

    public void changeTitleBarColor(String color) {
        if (TextUtils.isEmpty(color) || color.charAt(0) != COLOR_PREFIX) {
            color = COLOR_PREFIX + color;
        }
        try {
            titleBarColor = Color.parseColor(color);
        } catch (Exception e) {
            titleBarColor = defaultColor;
        }
    }

    public void changeOtherColor(String color) {
        if (TextUtils.isEmpty(color) || color.charAt(0) != COLOR_PREFIX) {
            color = COLOR_PREFIX + color;
        }
        try {
            otherColor = Color.parseColor(color);
        } catch (Exception e) {
            otherColor = defaultColor;
        }
    }

    public int getTitleBarColor() {
        return titleBarColor;
    }

    public int getOtherColor() {
        return otherColor;
    }

    public void resetColor() {
        titleBarColor = defaultColor;
        otherColor = defaultColor;
    }
}
