package com.xdja.uniteauth.utils;

import android.text.TextUtils;
import android.util.Log;

import com.xdja.uniteauth.data.local.UacPreference;
import com.xdja.uniteauth.data.net.model.LoginResponse;

/**
 * @author kongguoguang
 * Date:2019/8/13
 * Time:14:58
 * Summary:
 */
public class UserInfoUtil {

    private final String TAG = "UserInfoUtilTag";

    private static final UserInfoUtil INSTANCE = new UserInfoUtil();

    public static UserInfoUtil getInstance() {
        return INSTANCE;
    }

    private UserInfoUtil() {
    }

    /**
     * 用户名（用于登录）
     */
    private String userName;

    /**
     * 用户密码（用于登录）
     */
    private String password;

    /**
     * 用户昵称（用于展示）
     */
    private String nickname;

    private int idpId = -1;

    private String sn;

    private boolean safeCardChanged;


    public String getUserName() {
        return userName;
    }

    public String getPassword() {
        return password;
    }

    public String getNickname() {
        return nickname;
    }

    public int getIdpId() {
        return idpId;
    }

    public String getSn() {
        return sn;
    }

    public void setPassword(String password) {
        this.password = password;
        UacPreference.getInstance().setUserPwd(password);
    }

    public void setSafeCardChanged(boolean safeCardChanged) {
        this.safeCardChanged = safeCardChanged;
        if (safeCardChanged) {
            SettingInfoUtil.getInstance().resetSettingInfo();
        }
    }

    public void loadUserInfo() {
        userName = UacPreference.getInstance().getUserName();
        nickname = UacPreference.getInstance().getUserNickname();
        password = UacPreference.getInstance().getUserPwd();
        idpId = UacPreference.getInstance().getUserIdpId();
        sn = UacPreference.getInstance().getUserSN();
    }

    public void saveUserInfo(LoginResponse response) {

        //换卡登录成功后要把当前用户信息清空
        if (!TextUtils.isEmpty(response.getSn()) && safeCardChanged) {
            clearUserInfo();
        }

        idpId = response.getIdpId();
        UacPreference.getInstance().setUserId(idpId + "_" + response.getSub());

        UacPreference.getInstance().setUserIdpId(idpId);

        if (!TextUtils.isEmpty(response.getUname())) {
            nickname = response.getUname();
            UacPreference.getInstance().setUserNickname(nickname);
        }

        if (!TextUtils.isEmpty(response.getUserName())) {
            userName = response.getUserName();
            UacPreference.getInstance().setUserName(userName);
        }

        if (!TextUtils.isEmpty(response.getPassword())) {
            password = response.getPassword();
            UacPreference.getInstance().setUserPwd(password);
        }

        if (!TextUtils.isEmpty(response.getSn())) {
            sn = response.getSn();
            UacPreference.getInstance().setUserSN(sn);
        }

    }

    public void clearUserInfo() {
        Log.d(TAG, "clearUserInfo()");
        userName = null;
        password = null;
        nickname = null;
        idpId = -1;
        sn = null;
        safeCardChanged = false;
        UacPreference.getInstance().clearUserData();
        SettingInfoUtil.getInstance().resetSettingInfo();
    }
}
