package com.xdja.uniteauth.utils;

import com.xdja.crypto.XDJACrypto;
import com.xdja.xdjacrypto.SM2PublicKey;
import com.xdja.xdjacrypto.SM2Signature;
import com.xdja.xdjacrypto.XdjaCrypto;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * date:   2017/2/9 <br/>
 * 加密套件算法 2561 <br/>
 * CipherSuit_2561 = "SM2_256_SM1_ECB_SM4_CBC_SM3WITHSM2_SM3";
 */

public class VerifyTokenUtil {


    private XdjaCrypto xdjaCrypto = new XdjaCrypto();

    /**
     * 签名验证。
     *
     * @param srcData  原字符串
     * @param signData 签名后数据
     * @param pubKey   公钥
     * @return 0:验签成功。-1:表示在对原数据做SM3运算时失败。-2:表示签名和原数据不一致
     */
    public static int signVerify(byte[] srcData, byte[] signData, byte[] pubKey) {
        VerifyTokenUtil util = new VerifyTokenUtil();
        byte[] sm3Data = util.digestOnce(srcData);
        if (sm3Data == null) {
            return -1;
        }
        SM2PublicKey sm2PublicKey = new SM2PublicKey();
        System.arraycopy(pubKey, 0, sm2PublicKey.x, 0, XdjaCrypto.SM2_MAX_LEN);
        System.arraycopy(pubKey, XdjaCrypto.SM2_MAX_LEN, sm2PublicKey.y, 0, XdjaCrypto.SM2_MAX_LEN);

        SM2Signature signature = new SM2Signature();
        System.arraycopy(signData, 0, signature.r, 0, XdjaCrypto.SM2_MAX_LEN);
        System.arraycopy(signData, XdjaCrypto.SM2_MAX_LEN, signature.s, 0, XdjaCrypto.SM2_MAX_LEN);

        int ret = XDJACrypto.getInstance().SM2Verify(sm2PublicKey, sm3Data, sm3Data.length, signature);
        if (ret != 0) {
            return -2;
        } else {
            return 0;
        }

    }

    /**
     * 对数据进行SM3。
     * 如果失败，返回null
     *
     * @param data
     * @return
     */
    private byte[] digestOnce(byte[] data) {
        long[] handle = new long[1];
        int ret = xdjaCrypto.SM3Init(handle);
        if (ret != 0) {
            return null;
        }
        ret = xdjaCrypto.SM3Update(handle[0], data, data.length);
        if (ret != 0) {
            return null;
        }
        byte[] dataOut = new byte[32];
        ret = xdjaCrypto.SM3Final(handle[0], dataOut);
        if (ret == 0) {
            return dataOut;
        }
        return null;
    }
}
