package com.xdja.uniteauth.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;

import com.xdja.uniteauth.R;
import com.xdja.uniteauth.utils.UacColorConfig;

/**
 * Author:kongguoguang
 * Date:2019/9/10
 * Time:11:47
 * Summary:
 *
 * @author kgg
 */
public class UacButton extends android.support.v7.widget.AppCompatButton {
    public UacButton(Context context) {
        this(context, null);
    }

    public UacButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UacButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int color = UacColorConfig.getInstance().getOtherColor();

        //shape标签的xml文件对应的是GradientDrawable，而不是ShapeDrawable
        GradientDrawable normal = (GradientDrawable) ContextCompat.getDrawable(context, R.drawable.uac_common_button_normal);
        normal.setColor(color);

        //透明度50%
        int halfColor = Color.argb(128, Color.red(color), Color.green(color), Color.blue(color));
        GradientDrawable pressed = (GradientDrawable) ContextCompat.getDrawable(context, R.drawable.uac_common_button_pressed);
        pressed.setColor(halfColor);

        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{android.R.attr.state_pressed}, pressed);
        stateListDrawable.addState(new int[]{-android.R.attr.state_pressed}, normal);//前面的负号"-"表示未按压

        setBackground(stateListDrawable);
    }
}
