package com.xdja.uniteauth.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.StringRes;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import com.xdja.uniteauth.R;


/**
 * @author kgg
 */
public class UacCommonDialog extends Dialog {

    /**
     * 对话框样式: 单个按钮
     */
    public static final int SINGLE_BUTTON = 1;

    /**
     * 对话框样式: 两个按钮
     */
    public static final int TWO_BUTTON = 2;

    /**
     * 对话框样式: 两个按钮，带有指纹图标
     */
    public static final int TWO_BUTTON_WITH_FINGERPRINT = 3;

    // 默认宽度
    private static int default_width = 280;

    // 默认样式
    private static int default_style = R.style.UacDialog;

    private View dialogContentView;

    private TextView title, summary, cancelBtn, confirmBtn;

    private Activity activity;

    public Activity getActivity() {
        return activity;
    }

    /**
     * 对话框显示的样式
     * SINGLE_BUTTON
     * TWO_BUTTON
     */
    private int dialogType = SINGLE_BUTTON;

    /**
     * 对话框中对手机界面各种按键的监听
     */
    private UaacDialogOnKeyDownListener uaacDialogOnKeyDownListener;


    /**
     * 构造函数
     */
    public UacCommonDialog(Activity activity, int dialogType) {
        this(activity, default_width, default_style, dialogType);
        this.activity = activity;
    }

    /**
     *
     */
    private UacCommonDialog(Context context, int width, int style, int dialogType) {
        super(context, style);
        // set content
        if (dialogType == SINGLE_BUTTON) {
            dialogContentView = LayoutInflater.from(context).inflate(R.layout.uac_common_dialog_single_button, null);
        } else if (dialogType == TWO_BUTTON) {
            dialogContentView = LayoutInflater.from(context).inflate(R.layout.uac_common_dialog_two_button, null);
        } else if (dialogType == TWO_BUTTON_WITH_FINGERPRINT) {
            dialogContentView = LayoutInflater.from(context).inflate(R.layout.uac_common_dialog_with_fingerprint, null);
        } else {
            return;
        }
        setContentView(dialogContentView);
        this.dialogType = dialogType;
        if (dialogType == SINGLE_BUTTON) {
            // 点击外部区域, dialog消失
            setCanceledOnTouchOutside(true);
        } else {
            // 点击外部区域, dialog不消失
            setCanceledOnTouchOutside(false);
        }
        // set window params  after setContentView()
        Window window = getWindow();
        WindowManager.LayoutParams params = null;
        if (window != null) {
            params = window.getAttributes();
            // set width,height by density and gravity
            Resources resources = context.getResources();
            DisplayMetrics dm = resources.getDisplayMetrics();
            params.width = (int) (width * dm.density + 0.5f);
            //params.height = (int) (height * density + 0.5f);
            //params.gravity = Gravity.CENTER;
            window.setAttributes(params);
        }

        initView();
    }

    private void initView() {
        title = (TextView) dialogContentView.findViewById(R.id.uac_dialog_title);
        summary = (TextView) dialogContentView.findViewById(R.id.uac_dialog_summary);
        cancelBtn = (TextView) dialogContentView.findViewById(R.id.uac_dialog_cancel);
        confirmBtn = (TextView) dialogContentView.findViewById(R.id.uac_dialog_confirm);
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public void setTitle(@StringRes int stringRes) {
        title.setText(stringRes);
    }

    public void setSummary(String summary) {
        this.summary.setText(summary);
    }

    public void setSummary(@StringRes int stringRes) {
        summary.setText(stringRes);
    }

    public void setCancelButton(View.OnClickListener listener) {
        if (dialogType == SINGLE_BUTTON) {
            return;
        }
        cancelBtn.setOnClickListener(listener);
    }

    public void setCancelButton(String cancel, View.OnClickListener listener) {
        if (dialogType == SINGLE_BUTTON) {
            return;
        }
        cancelBtn.setText(cancel);
        cancelBtn.setOnClickListener(listener);
    }

    public void setCancelButton(@StringRes int stringRes, View.OnClickListener listener) {
        if (dialogType == SINGLE_BUTTON) {
            return;
        }
        cancelBtn.setText(stringRes);
        cancelBtn.setOnClickListener(listener);
    }

    public void setConfirmButton(View.OnClickListener listener) {
        confirmBtn.setOnClickListener(listener);
    }

    public void setConfirmButton(String confirm, View.OnClickListener listener) {
        confirmBtn.setText(confirm);
        confirmBtn.setOnClickListener(listener);
    }

    public void setConfirmButton(@StringRes int stringRes, View.OnClickListener listener) {
        confirmBtn.setText(stringRes);
        confirmBtn.setOnClickListener(listener);
    }


    public void setDialogKeyDownListener(UaacDialogOnKeyDownListener uaacDialogOnKeyDownListener) {
        this.uaacDialogOnKeyDownListener = uaacDialogOnKeyDownListener;
    }

    public interface UaacDialogOnKeyDownListener {
        void onUaacDialogKeyDown(int keyCode);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (uaacDialogOnKeyDownListener != null) {
            uaacDialogOnKeyDownListener.onUaacDialogKeyDown(keyCode);
        }
        return super.onKeyDown(keyCode, event);
    }

}
