package com.xdja.uniteauth.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.Nullable;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;

import com.xdja.uniteauth.LogoImageCache;
import com.xdja.uniteauth.R;
import com.xdja.uniteauth.data.ApiGen;
import com.xdja.uniteauth.utils.UacColorConfig;

import java.io.InputStream;
import java.lang.ref.WeakReference;

import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;

/**
 * Author:kongguoguang
 * Date:2019/9/10
 * Time:13:59
 * Summary:
 *
 * @author kgg
 */
public class UacImageView extends android.support.v7.widget.AppCompatImageView {


    public UacImageView(Context context) {
        this(context, null);
    }

    public UacImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);

        int svgResourceId;
        try {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.UacImageView);
            svgResourceId = typedArray.getResourceId(R.styleable.UacImageView_svgSrc, 0);
            typedArray.recycle();
        } catch (Exception e) {
            svgResourceId = 0;
        }

        if (svgResourceId != 0) {
            int svgColor = UacColorConfig.getInstance().getOtherColor();
            VectorDrawableCompat vectorDrawableCompat = VectorDrawableCompat.create(getResources(), svgResourceId, context.getTheme());
            if (vectorDrawableCompat != null) {
                vectorDrawableCompat.setTint(svgColor);
                setImageDrawable(vectorDrawableCompat);
            }
        }
    }

    public void setImageUrl(final String imageUrl) {
        if (TextUtils.isEmpty(imageUrl)) {
            return;
        }
        Bitmap bitmap = LogoImageCache.getInstance().getLogoImage(imageUrl);
        if (bitmap != null) {
            setImageBitmap(bitmap);
            return;
        }
        ApiGen.loadImg(imageUrl, new ImageCallback(new WeakReference<ImageView>(this), imageUrl));
    }

    private static class ImageCallback implements Callback<Response> {

        private WeakReference<ImageView> weakReference;
        private String imageUrl;

        ImageCallback(WeakReference<ImageView> weakReference, String imageUrl) {
            this.weakReference = weakReference;
            this.imageUrl = imageUrl;
        }

        @Override
        public void success(Response response, Response response2) {
            try {

                InputStream inputStream = response.getBody().in();
                Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
                LogoImageCache.getInstance().setLogoImage(imageUrl, bitmap);
                ImageView imageView = weakReference.get();
                if (imageView != null) {
                    imageView.setImageBitmap(bitmap);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void failure(RetrofitError error) {

        }
    }

}
