package com.xdja.uniteauth.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.res.Resources;
import android.support.annotation.StringRes;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.TextView;

import com.xdja.uniteauth.R;
import com.xdja.uniteauth.utils.UserInfoUtil;

/**
 * Author:kongguoguang
 * Date:2019/8/16
 * Time:8:34
 * Summary:
 * @author kgg
 */
public class UacInputDialog extends Dialog {

    public static final int INPUT_PIN = 0;

    public static final int INPUT_PASSWORD = 1;

    // 默认宽度
    private static int default_width = 260;

    // 默认样式
    private static int default_style = R.style.UacInputDialog;


    private TextView title, subtitle, cancelBtn, confirmBtn;

    private EditText summary;

    private InputCompleteCallback inputCompleteCallback;

    private int inputContentType;

    public UacInputDialog(Activity activity, int inputContentType) {
        super(activity, default_style);
        this.inputContentType = inputContentType;
        View contentView;
        if (inputContentType == INPUT_PIN) {
            contentView = LayoutInflater.from(activity).inflate(R.layout.uac_input_pin_dialog, null);
        } else {
            contentView = LayoutInflater.from(activity).inflate(R.layout.uac_input_user_pwd_dialog, null);
        }

        setContentView(contentView);
        // set window params  after setContentView()
        Window window = getWindow();
        WindowManager.LayoutParams params = null;
        if (window != null) {
            params = window.getAttributes();
            // set width,height by density and gravity
            Resources resources = activity.getResources();
            DisplayMetrics dm = resources.getDisplayMetrics();
            params.width = (int) (default_width * dm.density + 0.5f);
            //params.height = (int) (height * density + 0.5f);
            //params.gravity = Gravity.CENTER;
            window.setAttributes(params);
        }

        initView(contentView);
    }

    private void initView(View view) {
        title = (TextView) view.findViewById(R.id.uac_dialog_title);
        subtitle = (TextView) view.findViewById(R.id.uac_dialog_subtitle);
        summary = (EditText) view.findViewById(R.id.uac_dialog_summary);
        cancelBtn = (TextView) view.findViewById(R.id.uac_dialog_cancel);
        confirmBtn = (TextView) view.findViewById(R.id.uac_dialog_confirm);

        cancelBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

        confirmBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (inputCompleteCallback != null) {
                    inputCompleteCallback.onComplete(UacInputDialog.this, summary.getText());
                }
            }
        });

        if (inputContentType == INPUT_PASSWORD) {
            setSubtitle(UserInfoUtil.getInstance().getNickname());
        }
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public void setTitle(@StringRes int stringRes) {
        title.setText(stringRes);
    }

    public void setSubtitle(String title) {
        subtitle.setText(title);
    }

    public void setSubtitle(@StringRes int stringRes) {
        subtitle.setText(stringRes);
    }

    public String getInputContent() {
        return summary.getText().toString();
    }

    public void setCancelButton(View.OnClickListener listener) {
        cancelBtn.setOnClickListener(listener);
    }

    public void setCancelButton(String cancel, View.OnClickListener listener) {
        cancelBtn.setText(cancel);
        cancelBtn.setOnClickListener(listener);
    }

    public void setCancelButton(@StringRes int stringRes, View.OnClickListener listener) {
        cancelBtn.setText(stringRes);
        cancelBtn.setOnClickListener(listener);
    }

    public void setConfirmButton(View.OnClickListener listener) {
        confirmBtn.setOnClickListener(listener);
    }

    public void setConfirmButton(String confirm, View.OnClickListener listener) {
        confirmBtn.setText(confirm);
        confirmBtn.setOnClickListener(listener);
    }

    public void setConfirmButton(@StringRes int stringRes, View.OnClickListener listener) {
        confirmBtn.setText(stringRes);
        confirmBtn.setOnClickListener(listener);
    }

    @Override
    public void show() {
        super.show();
//        InputMethodManager imm = (InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
//        if (imm != null) {
//            imm.showSoftInput(summary, 0);
//        }
    }

    public void setInputCompleteCallback(InputCompleteCallback inputCompleteCallback) {
        this.inputCompleteCallback = inputCompleteCallback;
    }

    public interface InputCompleteCallback {
        void onComplete(UacInputDialog dialog, CharSequence inputContent);
    }

}
