package com.xdja.uniteauth.view;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import com.xdja.uniteauth.R;

/**
 *
 */
public class UacLoadingDialog {

    private Dialog innerDialog;
    private TextView summary;

    private int defaultHeight = 84;

    private int defaultWidth = 84;

    public UacLoadingDialog(Context context) {
        innerDialog = new InnerDialog(context, R.style.UacLoadingDialog);
        View contentView = LayoutInflater.from(context).inflate(R.layout.uac_loading_dialog, null);
        innerDialog.setContentView(contentView);

        summary = (TextView) contentView.findViewById(R.id.loading_text_content);
//        animation = AnimationUtils.loadAnimation(context, R.anim.loading);

        Window window = innerDialog.getWindow();
        WindowManager.LayoutParams layoutParams = null;
        if (window != null) {
            layoutParams = window.getAttributes();
            float density = context.getResources().getDisplayMetrics().density;
            layoutParams.height = (int) (defaultHeight * density);
            layoutParams.width = (int) (defaultWidth * density);
            //layoutParams.dimAmount = 0.8f;
            window.setAttributes(layoutParams);
        }

//        window.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);


    }

    public boolean isShowing() {
        return innerDialog.isShowing();
    }

    public void show() {
//        image.startAnimation(animation);
        innerDialog.show();
    }

    public void setCancelable(boolean flag) {
        innerDialog.setCancelable(flag);
    }

    public void setSummary(String summary) {
        this.summary.setText(summary);
    }

    public void setSummary(@StringRes int resId) {
        this.summary.setText(resId);
    }

    public void dismiss() {
//        image.clearAnimation();
        if (innerDialog != null) {
            innerDialog.dismiss();
        }
    }


    public void setOnDismissListener(
            DialogInterface.OnDismissListener dismissListener) {
        innerDialog.setOnDismissListener(dismissListener);
    }


    private class InnerDialog extends Dialog {


        private InnerDialog(Context context, int themeResId) {
            super(context, themeResId);
        }

        @Override
        public void hide() {
            super.hide();
        }

        @Override
        protected void onStop() {
            super.onStop();
        }
    }


}
