package com.xdja.uniteauth.view;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.widget.Switch;

import com.xdja.uniteauth.R;
import com.xdja.uniteauth.utils.UacColorConfig;

/**
 * Author:kongguoguang
 * Date:2019/9/12
 * Time:17:30
 * Summary:
 *
 * @author kgg
 */
public class UacSwitch extends Switch {

    public UacSwitch(Context context) {
        super(context);
    }

    public UacSwitch(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView(context);
    }

    public UacSwitch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView(context);
    }

    private void initView(Context context) {
        int trackOnColor = UacColorConfig.getInstance().getOtherColor();


        //shape标签的xml文件对应的是GradientDrawable，而不是ShapeDrawable
        GradientDrawable trackOff = (GradientDrawable) ContextCompat.getDrawable(context, R.drawable.uac_switch_track_off);

        GradientDrawable trackOn = (GradientDrawable) ContextCompat.getDrawable(context, R.drawable.uac_switch_track_on);
        trackOn.setColor(trackOnColor);

        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{android.R.attr.state_checked}, trackOn);
        stateListDrawable.addState(new int[]{-android.R.attr.state_checked}, trackOff);//前面的负号"-"表示未选中
//
        setTrackDrawable(stateListDrawable);
    }
}
