package com.xdja.uniteauth.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Typeface;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import android.widget.TextView;

import com.xdja.uniteauth.R;
import com.xdja.uniteauth.utils.SettingInfoUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Author:kongguoguang
 * Date:2019/8/17
 * Time:14:42
 * Summary:
 * @author kgg
 */
public class UacTimeIntervalDialog extends Dialog {

    // 默认宽度
    private static int default_width = 260;

    // 默认样式
    private static int default_style = R.style.UacDialog;

    private ListView listView;

    private List<TextView> intervalTextViewList = new ArrayList<>();

    private List<String> intervalStringList = new ArrayList<>();

    private TimeIntervalAdapter adapter;

    private IntervalCheckListener intervalCheckListener;

    private int currentTimeInterval = SettingInfoUtil.getInstance().getPrivacyProtectInterval();

    public void setIntervalCheckListener(IntervalCheckListener intervalCheckListener) {
        this.intervalCheckListener = intervalCheckListener;
    }

    public UacTimeIntervalDialog(Activity activity, IntervalCheckListener intervalCheckListener) {
        super(activity, default_style);
        this.intervalCheckListener = intervalCheckListener;
        View contentView = LayoutInflater.from(activity).inflate(R.layout.uac_time_interval_dialog, null);
        setContentView(contentView);

        Window window = getWindow();
        if (window != null) {
            WindowManager.LayoutParams params = window.getAttributes();
            Resources resources = activity.getResources();
            DisplayMetrics dm = resources.getDisplayMetrics();
            params.width = (int) (default_width * dm.density + 0.5f);
            window.setAttributes(params);
        }

        initView(contentView);
        initData();
    }

    public UacTimeIntervalDialog(Activity activity) {
        this(activity, null);
    }

    private void initView(View contentView) {
        listView = (ListView) contentView.findViewById(R.id.list_view);
        listView.setAdapter(adapter = new TimeIntervalAdapter());
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                uncheckAllItem();
                checkItem(position);
                dismiss();
            }
        });


        TextView cancel = (TextView) contentView.findViewById(R.id.tv_cancel);
        cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
    }

    private void initData() {
        intervalStringList.add("每次");
        intervalStringList.add("5分钟");
        intervalStringList.add("10分钟");
        intervalStringList.add("15分钟");
        intervalStringList.add("30分钟");
        intervalStringList.add("60分钟");
        adapter.notifyDataSetChanged();
    }

    private void uncheckAllItem() {
        for (TextView view : intervalTextViewList) {
            uncheckTextView(view);
        }
    }

    /**
     * 取消选中（不加粗，字体颜色变浅）
     */
    private void uncheckTextView(TextView view) {
        view.setTextColor(Color.parseColor("#5f5f5f"));
        view.setTypeface(Typeface.defaultFromStyle(Typeface.NORMAL));
    }

    private void checkItem(int position) {
        TextView textView = intervalTextViewList.get(position);
        checkTextView(textView);
        currentTimeInterval = positionToValue(position);
        SettingInfoUtil.getInstance().setPrivacyProtectInterval(currentTimeInterval);
        if (intervalCheckListener != null) {

            intervalCheckListener.onChecked(currentTimeInterval);
        }
    }

    private void checkTextView(TextView view) {
        view.setTextColor(ContextCompat.getColor(getContext(), R.color.uac_text_color_333));
        view.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
    }

    public interface IntervalCheckListener {
        void onChecked(int interval);
    }


    private class TimeIntervalAdapter extends BaseAdapter {
        @Override
        public int getCount() {
            return intervalStringList.size();
        }

        @Override
        public Object getItem(int position) {
            return null;
        }

        @Override
        public long getItemId(int position) {
            return 0;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                convertView = LayoutInflater.from(parent.getContext()).inflate(R.layout.uac_item_time_interval, parent, false);
                viewHolder = new ViewHolder();
                convertView.setTag(viewHolder);
            } else {
                viewHolder = (ViewHolder) convertView.getTag();
            }

            viewHolder.timeInterval = (TextView) convertView.findViewById(R.id.tv_time_interval);
            viewHolder.timeInterval.setText(intervalStringList.get(position));
            intervalTextViewList.add(viewHolder.timeInterval);

            if (valueToPosition(currentTimeInterval) == position) {
                checkTextView(viewHolder.timeInterval);
            } else {
                uncheckTextView(viewHolder.timeInterval);
            }

            return convertView;
        }
    }

    static class ViewHolder {
        TextView timeInterval;
    }

    private int positionToValue(int position) {
        switch (position) {
            case 1:
                return 5;
            case 2:
                return 10;
            case 3:
                return 15;
            case 4:
                return 30;
            case 5:
                return 60;
            default:
                return 0;
        }
    }

    private int valueToPosition(int value) {
        switch (value) {
            case 5:
                return 1;
            case 10:
                return 2;
            case 15:
                return 3;
            case 30:
                return 4;
            case 60:
                return 5;
            default:
                return 0;
        }
    }

}
