package com.xdja.uniteauth.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.uniteauth.R;
import com.xdja.uniteauth.utils.UacColorConfig;

/**
 * Author:kongguoguang
 * Date:2019/9/10
 * Time:10:49
 * Summary:
 *
 * @author kgg
 */
public class UacTitleBar extends LinearLayout {

    private TextView subtitleTv, titleTv;

    private ImageView backIv, settingIv;

    private CharSequence title, subtitle;

    public UacTitleBar(Context context) {
        this(context, null);
    }

    public UacTitleBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UacTitleBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.UacTitleBar);


        title = typedArray.getText(R.styleable.UacTitleBar_barTitle);
        subtitle = typedArray.getText(R.styleable.UacTitleBar_barSubtitle);

        typedArray.recycle();


        initView(context);
    }

    private void initView(Context context) {

        RelativeLayout relativeLayout = (RelativeLayout) LayoutInflater.from(context).inflate(R.layout.uac_base_title_bar, null);
        addView(relativeLayout);

        int color = UacColorConfig.getInstance().getTitleBarColor();
        relativeLayout.setBackgroundColor(color);

        LayoutParams params = (LayoutParams) relativeLayout.getLayoutParams();
        Resources resources = context.getResources();
        DisplayMetrics dm = resources.getDisplayMetrics();
        params.height = (int) (48 * dm.density + 0.5f);
        params.width = LayoutParams.MATCH_PARENT;
        relativeLayout.setLayoutParams(params);

        subtitleTv = (TextView) relativeLayout.findViewById(R.id.main_toolbar_subtitle);
        subtitleTv.setText(subtitle);

        titleTv = (TextView) relativeLayout.findViewById(R.id.main_toolbar_title);
        titleTv.setText(title);

        backIv = (ImageView) relativeLayout.findViewById(R.id.main_toolbar_back);
        settingIv = (ImageView) relativeLayout.findViewById(R.id.main_toolbar_setting);

        if (!TextUtils.isEmpty(subtitle)) {
            backIv.setVisibility(VISIBLE);
        }
    }

    public void setSubtitle(String subtitle) {
        subtitleTv.setText(subtitle);
    }

    public void setSubtitle(@StringRes int subtitle) {
        subtitleTv.setText(subtitle);
    }

    public void setTitle(String subtitle) {
        titleTv.setText(subtitle);
    }

    public void setTitle(@StringRes int subtitle) {
        titleTv.setText(subtitle);
    }

    public void setSettingListener(View.OnClickListener listener) {
        settingIv.setVisibility(VISIBLE);
        settingIv.setOnClickListener(listener);
    }

    public void setBackListener(View.OnClickListener listener) {
        backIv.setVisibility(VISIBLE);
        backIv.setOnClickListener(listener);
    }

}
