/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.datapersistence;

import android.content.Context;
import android.util.Log;

public class DataPersistence {
    private static DataPersistence mInstance;
    private byte[] appPackagePath = null;
    private byte[] appPackageName = null;
    private byte[] dataFilePath = null;
    private static final String fileName = "datapersistence.data";
    public static final int RET_OK = 0;
    public static final int ERROR = -1;
    public static final int ERROR_PARAM_NULL = -10;
    private static final String TAG = "DataPersistence";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataPersistence getInstance(Context context) {
        if (context == null) {
            return null;
        }
        if (mInstance != null) return mInstance;
        Class<DataPersistence> clazz = DataPersistence.class;
        synchronized (DataPersistence.class) {
            if (mInstance != null) return mInstance;
            mInstance = new DataPersistence(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addData(String dataTag, byte[] data) {
        Class<DataPersistence> clazz = DataPersistence.class;
        synchronized (DataPersistence.class) {
            int ret = 0;
            if (dataTag == null || data == null) {
                ret = -10;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return ret;
            }
            if (dataTag.equals("") || data.length > 65535) {
                ret = -10;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return ret;
            }
            this.deleteDataNative(dataTag.getBytes());
            ret = this.addDataNative(dataTag.getBytes(), data);
            if (ret != 0) {
                Log.d((String)TAG, (String)("addDataNative ret: " + ret));
                ret = -1;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String dataTag) {
        Class<DataPersistence> clazz = DataPersistence.class;
        synchronized (DataPersistence.class) {
            if (dataTag == null || dataTag.equals("")) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            byte[] data = new byte[65536];
            int[] outLen = new int[1];
            byte[] tempData = null;
            int ret = -1;
            ret = this.getDataNative(dataTag.getBytes(), data, outLen);
            Log.d((String)TAG, (String)("getDataNative ret: " + ret));
            if (ret == 0) {
                tempData = new byte[outLen[0]];
                System.arraycopy(data, 0, tempData, 0, outLen[0]);
            }
            data = null;
            outLen = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tempData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteData(String dataTag) {
        Class<DataPersistence> clazz = DataPersistence.class;
        synchronized (DataPersistence.class) {
            int ret = 0;
            if (dataTag == null || dataTag.equals("")) {
                ret = -10;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ret;
            }
            ret = this.deleteDataNative(dataTag.getBytes());
            if (ret != 0) {
                Log.d((String)TAG, (String)("deleteDataNative ret: " + ret));
                ret = -1;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    public int verifyPkg(String pkgPath) {
        int ret = 0;
        if (pkgPath == null || pkgPath.equals("")) {
            ret = -10;
            return ret;
        }
        ret = this.verifyPkgNative(pkgPath.getBytes(), pkgPath.length());
        return ret;
    }

    private DataPersistence(Context context) {
        this.appPackagePath = context.getApplicationInfo().sourceDir.getBytes();
        this.appPackageName = context.getPackageName().getBytes();
        String path = context.getFilesDir().getAbsolutePath();
        path = path + "/" + fileName;
        this.dataFilePath = path.getBytes();
    }

    private native int addDataNative(byte[] var1, byte[] var2);

    private native int getDataNative(byte[] var1, byte[] var2, int[] var3);

    private native int deleteDataNative(byte[] var1);

    private native int verifyPkgNative(byte[] var1, int var2);

    static {
        System.loadLibrary("datapersistence");
        mInstance = null;
    }
}

