package com.xdja.safekeyservice.jsservercards;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;

import com.google.gson.Gson;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.safekeyservice.jsservercards.bean.DataOut;
import com.xdja.safekeyservice.jsservercards.bean.RSAKeys;
import com.xdja.safekeyservice.jsservercards.bean.request.CardIdRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.ChangePinRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.CreateFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.DelFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.GenRandomRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.GenRsaKeyPairRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.GenSM2KeyPairRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.GetActiveRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.GetFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.GetPinTryCountRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.RSAPriKeyCalcRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.RSAPubKeyCalcRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.RSASignRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.RSASignVerifyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.ReadCertRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.ReadFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.ReadRsapubKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.ReadSm2PubKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.ReloadPinRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.SM1Request;
import com.xdja.safekeyservice.jsservercards.bean.request.SM3Request;
import com.xdja.safekeyservice.jsservercards.bean.request.SMKEYRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.SelectFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.Sm2DecryptRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.Sm2EncryptRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.Sm2SignRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.Sm2SignVerifyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.VerifyPinRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteCertRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteRsapriKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteRsapubKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteSm2PriKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteSm2PubKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.response.BaseResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.DataOutAndIvResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.GenRandomRes;
import com.xdja.safekeyservice.jsservercards.bean.response.GenSM2KeyPairResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.GetAllResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.GetDevInfoResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.GetFileResData;
import com.xdja.safekeyservice.jsservercards.bean.response.ReadCertResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.ReadFileResData;
import com.xdja.safekeyservice.jsservercards.bean.response.ReadSm2PubkeyResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.RetCodeResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.Sm2DecryptResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.Sm2EncryptReponse;
import com.xdja.safekeyservice.jsservercards.bean.response.Sm2SignResponse;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/10/30 <br/>
 */
public class CardsOperate {
    public static final String TAG = "CardsOperateTag";
    private static CardsOperate instance;
    private Context context;
    private HashMap<String, JarJniApiProxy> proxyMap = new HashMap<>();


    private CardsOperate(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    public static CardsOperate getInstance(Context context) {
        if (instance == null) {
            synchronized (CardsOperate.class) {
                if (instance == null) {
                    if (context == null) {
                        throw new NullPointerException("Context is null.");
                    }
                    instance = new CardsOperate(context);
                }
            }
        }
        return instance;
    }

    //-----------------------------------------------------zhangxiaolong↓

    /**
     * 得到所有
     *
     * @return
     */
    public String getAll(String args) {
        Pair<Integer, List<JniApiParam>> pair = JarMultiJniApiManager.getInstance().getAll(context);
        GetAllResponse response = new GetAllResponse();
        response.setRetCode(pair.first);
        if (pair.first == 0) {
            for (JniApiParam param : pair.second) {
                if (TextUtils.isEmpty(param.other)) {
                    param.other = " ";
                }
            }
            response.setContent(pair.second);
        }
        Gson gson = new Gson();
        return gson.toJson(response);
    }

    /**
     * 获取设备信息
     *
     * @return
     */
    public String getDevInfo(String args) {
        Gson gson = new Gson();
        CardIdRequest bean = gson.fromJson(args, CardIdRequest.class);
        JarJniApiProxy proxy = getProxy(bean.cardId);
        GetDevInfoResponse response;
        if (proxy == null) {
            response = new GetDevInfoResponse();
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            XDJA_DEVINFO devInfo = new XDJA_DEVINFO();
            int ret = proxy.GetDevInfo(devInfo);
            response = new GetDevInfoResponse(ret, devInfo);
        }
        return gson.toJson(response);
    }

    /**
     * 修改PIN码
     *
     * @param args
     * @return
     */
    public String changePin(String args) {
        Gson gson = new Gson();
        ChangePinRequest bean = gson.fromJson(args, ChangePinRequest.class);
        JarJniApiProxy proxy = getProxy(bean.cardId);
        RetCodeResponse response = new RetCodeResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            byte[] oldPin = bean.oldPin.getBytes();
            byte[] newPin = bean.newPin.getBytes();

            //add 2018年11月14日10:47:52 weizg
            //判断新PIN码位数
            int newPINLen = newPin.length;
            if(newPINLen < 6 || newPINLen > 16){
                response.ret_code = JNIAPI.XKR_INVALID_PARA;
            }else {
                int ret = proxy.ChangePIN(bean.pinRole, oldPin, oldPin.length, newPin, newPINLen);
                response.ret_code = ret;
            }

        }
        return gson.toJson(response);
    }

    /**
     * 验证PIN码
     *
     * @param args
     * @return
     */
    public String verifyPin(String args) {
        Gson gson = new Gson();
        VerifyPinRequest bean = gson.fromJson(args, VerifyPinRequest.class);
        JarJniApiProxy proxy = getProxy(bean.cardId);
        RetCodeResponse response = new RetCodeResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            byte[] pin = bean.pin.getBytes();
            int ret = proxy.VerifyPIN(bean.pinRole, pin, pin.length);
            response.ret_code = ret;
        }
        return gson.toJson(response);
    }

    /**
     * 获取PIN码重试次数
     *
     * @param args
     * @return
     */
    public String getPinTryCount(String args) {
        Gson gson = new Gson();
        GetPinTryCountRequest bean = gson.fromJson(args, GetPinTryCountRequest.class);
        JarJniApiProxy proxy = getProxy(bean.cardId);
        RetCodeResponse response = new RetCodeResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            int ret = proxy.GetPinTryCount(bean.pinRole);
            response.ret_code = ret;
        }
        return gson.toJson(response);
    }

    /**
     * 获取PIN码重试次数
     *
     * @param args
     * @return
     */
    public String reloadPin(String args) {
        Gson gson = new Gson();
        ReloadPinRequest bean = gson.fromJson(args, ReloadPinRequest.class);
        JarJniApiProxy proxy = getProxy(bean.cardId);
        RetCodeResponse response = new RetCodeResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            byte[] key = bean.key.getBytes();
            byte[] newPin = bean.newPin.getBytes();
            int ret = proxy.ReloadPIN(bean.pinRole, key, key.length, newPin, newPin.length);
            response.ret_code = ret;
        }
        return gson.toJson(response);
    }

    /**
     * sm1
     *
     * @param args
     * @return
     */
    public String sm1(String args) {
        Gson gson = new Gson();
        SM1Request bean = gson.fromJson(args, SM1Request.class);
        JarJniApiProxy proxy = getProxy(bean.cardId);
        DataOutAndIvResponse response = new DataOutAndIvResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            if (bean.dataIn == null) {
                response.ret_code = JNIAPI.XKR_INVALID_PARA;
            } else if (checkFlagAndIv(bean.flag, bean.iv) != 0) {
                response.ret_code = JNIAPI.XKR_INVALID_PARA;
            } else {
                if (bean.flag == JNIAPI.ECB_DECRYPT || bean.flag == JNIAPI.ECB_ENCRYPT) {
                    bean.iv = null;
                }
                byte[] dataOut = new byte[bean.dataIn.length];
                int ret = proxy.SM1(bean.dataIn, bean.dataIn.length, bean.flag, dataOut, bean.kid, bean.iv);
                response.ret_code = ret;
                if (ret == 0) {
                    response.setResult(dataOut, bean.iv);
                }
            }
        }
        return gson.toJson(response);
    }

    private static final String ALG_SM1KEY = "SM1KEY";
    private static final String ALG_SM4KEY = "SM4KEY";

    /**
     * sm1
     *
     * @param args
     * @return
     */
    public String sm1Key(String args) {
        return smKeyPri(args, ALG_SM1KEY);
    }

    /**
     * sm4
     *
     * @param args
     * @return
     */
    public String sm4Key(String args) {
        return smKeyPri(args, ALG_SM4KEY);
    }

    public String sm3(String args) {
        Gson gson = new Gson();
        SM3Request bean = gson.fromJson(args, SM3Request.class);
        JarJniApiProxy proxy = getProxy(bean.cardId);
        DataOutAndIvResponse response = new DataOutAndIvResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            if (bean.dataIn == null) {
                response.ret_code = JNIAPI.XKR_INVALID_PARA;
            } else {
                byte[] dataOut = new byte[32];
                int ret = proxy.SM3(bean.dataIn, bean.dataIn.length, dataOut);
                response.ret_code = ret;
                if (ret == 0) {
                    response.setResult(dataOut, null);
                }
            }
        }
        return gson.toJson(response);
    }

    private String smKeyPri(String args, String alg) {
        Gson gson = new Gson();
        SMKEYRequest bean = gson.fromJson(args, SMKEYRequest.class);
        JarJniApiProxy proxy = getProxy(bean.cardId);
        DataOutAndIvResponse response = new DataOutAndIvResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            if (bean.dataIn == null || bean.tmpKey == null) {
                response.ret_code = JNIAPI.XKR_INVALID_PARA;
            } else if (checkFlagAndIv(bean.flag, bean.iv) != 0) {
                response.ret_code = JNIAPI.XKR_INVALID_PARA;
            } else {
                if (bean.flag == JNIAPI.ECB_DECRYPT || bean.flag == JNIAPI.ECB_ENCRYPT) {
                    bean.iv = null;
                }
                byte[] dataOut = new byte[bean.dataIn.length];
                int ret = JNIAPI.XKR_INVALID_PARA;
                if (alg.equals(ALG_SM1KEY)) {
                    ret = proxy.SM1KEY(bean.tmpKey, bean.dataIn, bean.dataIn.length, bean.flag, dataOut, bean.iv);
                } else if (alg.equals(ALG_SM4KEY)) {
                    ret = proxy.SM4KEY(bean.tmpKey, bean.dataIn, bean.dataIn.length, bean.flag, dataOut, bean.iv);
                } else {
                    Log.e(TAG, "smKeyPri alg error! [" + alg + "]");
                }
                response.ret_code = ret;
                if (ret == 0) {
                    response.setResult(dataOut, bean.iv);
                }
            }
        }
        return gson.toJson(response);
    }


    /**
     * 检查IV和flag是否合法
     *
     * @param flag
     * @param iv
     * @return
     */
    private int checkFlagAndIv(int flag, byte[] iv) {
        if (flag == JNIAPI.CBC_DECRYPT || flag == JNIAPI.CBC_ENCRYPT) {
            if (iv == null) {
                return -1;
            }
        }
        return 0;
    }
    //-----------------------------------------------------zhangxiaolong↑

    //-----------------------------------------------------wzg↓

    /**
     * 获取芯片激活状态
     *
     * @param args 接口参数的json字符串
     * @return
     */
    public String getActivateState(String args) {
        Gson gson = new Gson();
        GetActiveRequestData getActiveRequestData =
                gson.fromJson(args, GetActiveRequestData.class);
        Pair<Integer, JarJniApiProxy> make =
                JarMultiJniApiManager.getInstance().make(context, getActiveRequestData.getCardId());

        BaseResponse baseResponse = new BaseResponse();

        JarJniApiProxy jniApiProxy = make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            baseResponse.ret_code = jniApiProxy.GetActivateState();
        }

        return gson.toJson(baseResponse);
    }

    public String genRandom(String args) {
        Gson gson = new Gson();
        GenRandomRequestData genRandomRequestData =
                gson.fromJson(args, GenRandomRequestData.class);
        Pair<Integer, JarJniApiProxy> make =
                JarMultiJniApiManager.getInstance().make(context, genRandomRequestData.getCardId());

        BaseResponse baseResponse = new BaseResponse();

        JarJniApiProxy jniApiProxy = make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            byte[] randomTmp = new byte[genRandomRequestData.getLen()];
            int ret_code = jniApiProxy.GenRandom(genRandomRequestData.getLen(), randomTmp);
            if (ret_code == 0) {
                GenRandomRes genRandomRes = new GenRandomRes();
                genRandomRes.setRandom(randomTmp);

                baseResponse.result = genRandomRes;
            }

            baseResponse.ret_code = jniApiProxy.GetActivateState();

        }

        return gson.toJson(baseResponse);
    }

    public String selectFile(String args) {
        Log.v("CardsOperate", "selectFile args: " + args);

        Gson gson = new Gson();
        SelectFileRequestData selectFileRequestData =
                gson.fromJson(args, SelectFileRequestData.class);
        Pair<Integer, JarJniApiProxy> make =
                JarMultiJniApiManager.getInstance().make(context, selectFileRequestData.getCardId());

        BaseResponse baseResponse = new BaseResponse();

        JarJniApiProxy jniApiProxy = make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            baseResponse.ret_code = jniApiProxy.SelectFile(selectFileRequestData.getFid());
        }

        return gson.toJson(baseResponse);
    }

    public String deleteFile(String args) {
        Log.v("CardsOperate", "deleteFile args: " + args);

        Gson gson = new Gson();
        DelFileRequestData delFileRequestData =
                gson.fromJson(args, DelFileRequestData.class);
        Pair<Integer, JarJniApiProxy> make =
                JarMultiJniApiManager.getInstance().make(context, delFileRequestData.getCardId());

        BaseResponse baseResponse = new BaseResponse();

        JarJniApiProxy jniApiProxy = make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            baseResponse.ret_code = jniApiProxy.DeleteFile(delFileRequestData.getFid());
        }

        return gson.toJson(baseResponse);
    }

    public String createFile(String args) {
        Log.v("CardsOperate", "createFile args: " + args);

        Gson gson = new Gson();
        CreateFileRequestData createFileRequestData =
                gson.fromJson(args, CreateFileRequestData.class);
        Pair<Integer, JarJniApiProxy> make =
                JarMultiJniApiManager.getInstance().make(context, createFileRequestData.getCardId());

        BaseResponse baseResponse = new BaseResponse();

        JarJniApiProxy jniApiProxy = make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = JNIAPI.XKR_NO_KEY;
        } else {

            baseResponse.ret_code = jniApiProxy.CreateFile(createFileRequestData.getXdjaFile());
        }

        return gson.toJson(baseResponse);
    }

    public String getFileInfo(String args) {
        Log.v("CardsOperate", "getFileInfo args: " + args);

        Gson gson = new Gson();
        GetFileRequestData getFileRequestData =
                gson.fromJson(args, GetFileRequestData.class);
        Pair<Integer, JarJniApiProxy> make =
                JarMultiJniApiManager.getInstance().make(context, getFileRequestData.getCardId());

        BaseResponse baseResponse = new BaseResponse();

        JarJniApiProxy jniApiProxy = make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            XDJA_FILE xdja_file = new XDJA_FILE();

            baseResponse.ret_code = jniApiProxy.GetFileInfo(getFileRequestData.getFid(), xdja_file);
            if (baseResponse.ret_code == 0) {
                GetFileResData getFileResData = new GetFileResData();
                getFileResData.setFile(xdja_file);

                baseResponse.result = getFileResData;
            }
        }

        return gson.toJson(baseResponse);
    }

    public String readFile(String args) {
        Log.v("CardsOperate", "readFile  args: " + args);

        Gson gson = new Gson();
        ReadFileRequestData readFileRequestData =
                gson.fromJson(args, ReadFileRequestData.class);
        Pair<Integer, JarJniApiProxy> make =
                JarMultiJniApiManager.getInstance().make(context, readFileRequestData.getCardId());

        BaseResponse baseResponse = new BaseResponse();

        JarJniApiProxy jniApiProxy = make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            byte[] dataOut = new byte[readFileRequestData.getReadLen()];

            baseResponse.ret_code =
                    jniApiProxy.ReadFile(
                            readFileRequestData.getFid(),
                            readFileRequestData.getReadPos(),
                            readFileRequestData.getReadLen(),
                            dataOut);
            if (baseResponse.ret_code == 0) {
                ReadFileResData readFileResData = new ReadFileResData();
                readFileResData.setData(dataOut);

                baseResponse.result = readFileResData;
            }
        }

        return gson.toJson(baseResponse);
    }

    public String writeFile(String args) {
        Log.v("CardsOperate", "writeFile  args: " + args);

        Gson gson = new Gson();
        WriteFileRequestData writeFileRequestData =
                gson.fromJson(args, WriteFileRequestData.class);
        Pair<Integer, JarJniApiProxy> make =
                JarMultiJniApiManager.getInstance().make(context, writeFileRequestData.getCardId());

        BaseResponse baseResponse = new BaseResponse();

        JarJniApiProxy jniApiProxy = make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = JNIAPI.XKR_NO_KEY;
        } else {

            baseResponse.ret_code =
                    jniApiProxy.WriteFile(
                            writeFileRequestData.getFid(),
                            writeFileRequestData.getWritePos(),
                            writeFileRequestData.getWriteLen(),
                            writeFileRequestData.getDataIn());
        }

        Log.v("CardsOperate", "writeFile  ret: " + baseResponse.ret_code);

        return gson.toJson(baseResponse);
    }

    public String readCert(String args) {
        Log.v("CardsOperate", "readCert  args: " + args);

        Gson gson = new Gson();
        ReadCertRequestData readCertRequestData =
                gson.fromJson(args, ReadCertRequestData.class);
        Pair<Integer, JarJniApiProxy> make =
                JarMultiJniApiManager.getInstance().make(context, readCertRequestData.getCardId());

        BaseResponse baseResponse = new BaseResponse();

        JarJniApiProxy jniApiProxy = make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = JNIAPI.XKR_NO_KEY;
        } else {

            byte[] certBufTmp = new byte[2048];
            int[] certLen = new int[2];

            baseResponse.ret_code =
                    jniApiProxy.ReadCert(
                            readCertRequestData.getFid(),
                            certBufTmp,
                            certLen);

            if (baseResponse.ret_code == 0) {
                //如果证书读取成功
                byte[] certBuf = new byte[certLen[0]];

                System.arraycopy(certBufTmp, 0, certBuf, 0, certLen[0]);

                ReadCertResponse readCertResponse = new ReadCertResponse();
                readCertResponse.setCertBuf(certBuf);

                baseResponse.result = readCertResponse;
            }

        }

        Log.v("CardsOperate", "readCert  ret: " + baseResponse.ret_code);

        return gson.toJson(baseResponse);
    }


    public String writeCert(String args) {
        Log.v("CardsOperate", "writeCert  args: " + args);

        Gson gson = new Gson();
        WriteCertRequestData writeCertRequestData =
                gson.fromJson(args, WriteCertRequestData.class);
        Pair<Integer, JarJniApiProxy> make =
                JarMultiJniApiManager.getInstance().make(context, writeCertRequestData.getCardId());

        BaseResponse baseResponse = new BaseResponse();

        JarJniApiProxy jniApiProxy = make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = JNIAPI.XKR_NO_KEY;
        } else {

            baseResponse.ret_code =
                    jniApiProxy.WriteCert(
                            writeCertRequestData.getFid(),
                            writeCertRequestData.getCertBuf(),
                            writeCertRequestData.getCertBuf().length);
        }

        Log.v("CardsOperate", "writeFile  ret: " + baseResponse.ret_code);

        return gson.toJson(baseResponse);
    }

    //-----------------------------------------------------wzg↑

    //-----------------------------------------------------yangpeng↓

    /**
     * 读sm2公钥
     *
     * @param args
     * @return
     */
    public String readSm2PubKey(String args) {
        Gson gson = new Gson();
        ReadSm2PubKeyRequest request = gson.fromJson(args, ReadSm2PubKeyRequest.class);
        Pair<Integer, JarJniApiProxy> proxy = JarMultiJniApiManager.getInstance().make(context, request.getCardId());
        BaseResponse response = null;
        if (proxy.first == JNIAPI.XKR_OK) {
            response = new ReadSm2PubkeyResponse();
            JarJniApiProxy jarJniApiProxy = proxy.second;
            XDJA_SM2_PUBKEY xdja_sm2_pubkey = new XDJA_SM2_PUBKEY();
            int resCode = jarJniApiProxy.ReadSm2PubKey(request.getPubFid(), xdja_sm2_pubkey);
            if (resCode == JNIAPI.XKR_OK) {
                response.ret_code = JNIAPI.XKR_OK;
                response.result = xdja_sm2_pubkey;
            } else {
                response.ret_code = resCode;
                response.result = null;
            }
        } else {
            response.ret_code = proxy.first;
            response.result = null;
        }
        return gson.toJson(response);
    }

    /**
     * 写sm2公钥
     *
     * @param args
     * @return
     */
    public String writeSm2PubKey(String args) {
        Gson gson = new Gson();
        WriteSm2PubKeyRequest request = gson.fromJson(args, WriteSm2PubKeyRequest.class);
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, request.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxyPair.first == JNIAPI.XKR_OK) {
            byte[] pubFid = request.getPubFid();
            XDJA_SM2_PUBKEY pubkey = request.getPubKey();
            JarJniApiProxy jarJniApiProxy = proxyPair.second;
            int resCode = jarJniApiProxy.WriteSm2PubKey(pubFid, pubkey);
            response.ret_code = resCode;
        } else {
            response.ret_code = proxyPair.first;
        }
        response.result = null;

        return gson.toJson(response);
    }

    /**
     * 写sm2私钥
     *
     * @param args
     * @return
     */
    public String writeSm2PriKey(String args) {
        Gson gson = new Gson();
        WriteSm2PriKeyRequest request = gson.fromJson(args, WriteSm2PriKeyRequest.class);
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, request.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        if (proxyPair.first == JNIAPI.XKR_OK) {
            JarJniApiProxy jarJniApiProxy = proxyPair.second;
            byte[] priFid = request.getPriFid();
            XDJA_SM2_PRIKEY priKey = request.getPriKey();
            int resCode = jarJniApiProxy.WriteSm2PriKey(priFid, priKey);
            baseResponse.ret_code = resCode;

        } else {
            baseResponse.ret_code = proxyPair.first;
        }
        baseResponse.result = null;
        return gson.toJson(baseResponse);
    }

    /**
     * 生成SM2密钥对
     *
     * @param args
     * @return
     */
    public String genSM2KeyPair(String args) {
        Gson gson = new Gson();
        GenSM2KeyPairRequest request = gson.fromJson(args, GenSM2KeyPairRequest.class);
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, request.getCardId());
        GenSM2KeyPairResponse genSM2KeyPairResponse = null;
        if (proxyPair.first == JNIAPI.XKR_OK) {
            JarJniApiProxy jarJniApiProxy = proxyPair.second;
            byte[] pubFid = request.getPubFid();
            byte[] priFid = request.getPriFid();
            XDJA_SM2_PUBKEY pubkey = new XDJA_SM2_PUBKEY();
            XDJA_SM2_PRIKEY prikey = new XDJA_SM2_PRIKEY();
            int resCode = jarJniApiProxy.GenSM2KeyPair(pubFid, priFid, pubkey, prikey);
            byte[] pubFid0 = {0x00, 0x00};
            byte[] priFid0 = {0x00, 0x00};

            if (resCode == JNIAPI.XKR_OK) {
                if (!Arrays.equals(pubFid, pubFid0)) {
                    pubkey = null;
                }
                if (!Arrays.equals(pubFid, pubFid0) || !Arrays.equals(priFid, priFid0)) {
                    prikey = null;
                }

                genSM2KeyPairResponse = new GenSM2KeyPairResponse(resCode, pubkey, prikey);
            } else {
                genSM2KeyPairResponse = new GenSM2KeyPairResponse();
                genSM2KeyPairResponse.ret_code = resCode;
                genSM2KeyPairResponse.result = null;
            }
        } else {
            genSM2KeyPairResponse = new GenSM2KeyPairResponse();
            genSM2KeyPairResponse.ret_code = proxyPair.first;
            genSM2KeyPairResponse.result = null;
        }


        return gson.toJson(genSM2KeyPairResponse);
    }

    /**
     * SM2公钥加密（国密标准）
     *
     * @param args
     * @return
     */
    public String sm2Encrypt(String args) {
        Gson gson = new Gson();
        Sm2EncryptRequest request = gson.fromJson(args, Sm2EncryptRequest.class);
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, request.getCardId());
        Sm2EncryptReponse sm2EncryptReponse = null;
        if (proxyPair.first == JNIAPI.XKR_OK) {
            JarJniApiProxy jarJniApiProxy = proxyPair.second;
            byte[] pubFid = request.getPubFid();
            XDJA_SM2_PUBKEY pubkey = request.getPubKey();
            byte[] dataIn = request.getDataIn();
            byte[] dataOut = new byte[256];
            int[] outLen = new int[1];
            int resCode = jarJniApiProxy.SM2Encrypt(pubFid, pubkey, dataIn, dataIn.length, dataOut, outLen);
            if (resCode == JNIAPI.XKR_OK) {
                dataOut = Arrays.copyOfRange(dataOut, 0, outLen[0]);
                sm2EncryptReponse = new Sm2EncryptReponse(resCode, dataOut);
            } else {
                sm2EncryptReponse = new Sm2EncryptReponse(resCode, null);
            }
        } else {
            sm2EncryptReponse = new Sm2EncryptReponse(proxyPair.first, null);
        }
        return gson.toJson(sm2EncryptReponse);
    }

    /**
     * SM2私钥解密
     *
     * @param args
     * @return
     */
    public String sm2Decrypt(String args) {
        Gson gson = new Gson();
        Sm2DecryptRequest request = gson.fromJson(args, Sm2DecryptRequest.class);
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, request.getCardId());
        Sm2DecryptResponse sm2DecryptResponse = null;
        if (proxyPair.first == JNIAPI.XKR_OK) {
            JarJniApiProxy jarJniApiProxy = proxyPair.second;
            byte[] dataIn = request.getDataIn();
            byte[] priFid = request.getPriFid();
            //解密后的明文数据,缓冲区至少为dlen-97
            byte[] dataOut = new byte[256];
            int[] outLen = new int[2];
            int resCode = jarJniApiProxy.SM2Decrypt(priFid, dataIn, dataIn.length, dataOut, outLen);

            if(resCode == JNIAPI.XKR_OK){
                dataOut = Arrays.copyOfRange(dataOut, 0, outLen[0]);
                sm2DecryptResponse = new Sm2DecryptResponse(resCode, dataOut);
            } else {
                sm2DecryptResponse = new Sm2DecryptResponse(resCode, null);
            }
        } else {
            sm2DecryptResponse = new Sm2DecryptResponse(proxyPair.first, null);
        }
        return gson.toJson(sm2DecryptResponse);
    }

    /**
     * SM2数据签名
     *
     * @param args
     * @return
     */
    public String sm2Sign(String args) {
        Gson gson = new Gson();
        Sm2SignRequest request = gson.fromJson(args, Sm2SignRequest.class);
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, request.getCardId());
        Sm2SignResponse sm2SignResponse = null;
        if (proxyPair.first == JNIAPI.XKR_OK) {
            JarJniApiProxy jarJniApiProxy = proxyPair.second;
            byte[] pubFid = request.getPubFid();
            byte[] priFid = request.getPriFid();
            int dataType = request.getDataType();
            byte[] dataIn = request.getDataIn();
            byte[] dataOut = new byte[256];
            int[] outLen = new int[2];
            int resCode = jarJniApiProxy.SM2Sign(pubFid, priFid, dataType, dataIn, dataIn.length, dataOut, outLen);
            if (resCode == JNIAPI.XKR_OK) {
                dataOut = Arrays.copyOfRange(dataOut, 0, outLen[0]);
                sm2SignResponse = new Sm2SignResponse(resCode, dataOut);
            } else {
                sm2SignResponse = new Sm2SignResponse(resCode, null);
            }

        } else {
            sm2SignResponse = new Sm2SignResponse(proxyPair.first, null);
        }
        return gson.toJson(sm2SignResponse);
    }

    /**
     * SM2数据签名验证
     *
     * @param args
     * @return
     */
    public String sm2SignVerify(String args) {
        Gson gson = new Gson();
        Sm2SignVerifyRequest request = gson.fromJson(args, Sm2SignVerifyRequest.class);
        Pair<Integer, JarJniApiProxy> proxyPair = JarMultiJniApiManager.getInstance().make(context, request.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        if (proxyPair.first == JNIAPI.XKR_OK) {
            JarJniApiProxy jarJniApiProxy = proxyPair.second;
            byte[] pubFid = request.getPubFid();
            int dataType = request.getDataType();
            XDJA_SM2_PUBKEY pubKey = request.getPubKey();
            byte[] dataIn = request.getDataIn();
            byte[] signatureData = request.getSignatureData();
            int resCode = jarJniApiProxy.SM2SignVerify(pubFid, dataType, pubKey, dataIn, dataIn.length, signatureData);
            baseResponse.ret_code = resCode;
        } else {
            baseResponse.ret_code = proxyPair.first;
        }
        return gson.toJson(baseResponse);
    }


    //-----------------------------------------------------yangpeng↑


    //-----------------------------------------------------gyx↓

    /**
     * 卡内产生RSA密钥对
     *
     * @param args
     * @return
     */
    public String genRsaKeyPair(String args) {
        Gson gson = new Gson();
        GenRsaKeyPairRequest genRsaKeyPairRequest =
                gson.fromJson(args, GenRsaKeyPairRequest.class);
        JarJniApiProxy proxy = getProxy(genRsaKeyPairRequest.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            int bits = genRsaKeyPairRequest.getBits();
            byte[] pubFid = genRsaKeyPairRequest.getPubFid();
            byte[] priFid = genRsaKeyPairRequest.getPriFid();

            XDJA_RSA_PUBKEY xdja_rsa_pubkey = new XDJA_RSA_PUBKEY();
            XDJA_RSA_PRIKEY xdja_rsa_prikey = new XDJA_RSA_PRIKEY();
            response.ret_code = proxy.GenRSAKeyPair(bits, pubFid, priFid, xdja_rsa_pubkey, xdja_rsa_prikey);
            if (response.ret_code == JNIAPI.XKR_OK) {

                boolean isPubKeyOut = false;
                byte[] cmpBytes = {0x00, 0x00};
                if (Arrays.equals(pubFid, cmpBytes)) {
                    isPubKeyOut = true;
                }
                boolean isPriKeyOut = false;
                if (Arrays.equals(priFid, cmpBytes)){
                    isPriKeyOut = true;
                }
                if (isPubKeyOut){
                    RSAKeys rsaKeys = new RSAKeys();
                    rsaKeys.setPubKey(xdja_rsa_pubkey);
                    if (isPriKeyOut){
                        rsaKeys.setPriKey(xdja_rsa_prikey);
                    }
                    response.result = rsaKeys;
                }
            }
        }
        return gson.toJson(response);
    }

    /**
     * 读RSA公钥
     *
     * @param args
     * @return
     */
    public String readRsapubKey(String args) {
        Gson gson = new Gson();
        ReadRsapubKeyRequest readRsapubKeyRequest =
                gson.fromJson(args, ReadRsapubKeyRequest.class);
        JarJniApiProxy proxy = getProxy(readRsapubKeyRequest.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            XDJA_RSA_PUBKEY xdja_rsa_pubkey = new XDJA_RSA_PUBKEY();
            response.ret_code = proxy.ReadRsaPubKey(readRsapubKeyRequest.getPubFid(), xdja_rsa_pubkey);
            if (response.ret_code == JNIAPI.XKR_OK) {
                HashMap<String, XDJA_RSA_PUBKEY> hashMap = new HashMap<>();
                hashMap.put("pubKey", xdja_rsa_pubkey);
                response.result = hashMap;
            }
        }
        return gson.toJson(response);
    }

    /**
     * 写RSA公钥
     *
     * @param args
     * @return
     */
    public String writeRsapubKey(String args) {
        Gson gson = new Gson();
        WriteRsapubKeyRequest writeRsapubKeyRequest =
                gson.fromJson(args, WriteRsapubKeyRequest.class);
        JarJniApiProxy proxy = getProxy(writeRsapubKeyRequest.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            response.ret_code = proxy.WriteRsaPubKey(writeRsapubKeyRequest.getPubFid(), writeRsapubKeyRequest.getPubKey());
        }
        return gson.toJson(response);
    }

    /**
     * 写RSA私钥
     *
     * @param args
     * @return
     */
    public String writeRsapriKey(String args) {
        Gson gson = new Gson();
        WriteRsapriKeyRequest writeRsapriKeyRequest =
                gson.fromJson(args, WriteRsapriKeyRequest.class);
        JarJniApiProxy proxy = getProxy(writeRsapriKeyRequest.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            response.ret_code = proxy.WriteRsaPriKey(writeRsapriKeyRequest.getPriFid(), writeRsapriKeyRequest.getPriKey());
        }
        return gson.toJson(response);
    }

    /**
     * RSA私钥运算
     *
     * @param args
     * @return
     */
    public String rsaPriKeyCalc(String args) {
        Gson gson = new Gson();
        RSAPriKeyCalcRequestData rsaPriKeyCalcRequestData =
                gson.fromJson(args, RSAPriKeyCalcRequestData.class);
        JarJniApiProxy proxy = getProxy(rsaPriKeyCalcRequestData.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            byte[] prifid = rsaPriKeyCalcRequestData.getPriFid();
            byte[] dataIn = rsaPriKeyCalcRequestData.getDataIn();

            byte[] tempDataOut = new byte[256];
            int[] tempOutLen = {0, 0};
            response.ret_code = proxy.RSAPriKeyCalc(prifid, dataIn, dataIn.length, tempDataOut, tempOutLen);
            if (response.ret_code == JNIAPI.XKR_OK) {
                DataOut dataOut = new DataOut();
                dataOut.dataOut = Arrays.copyOfRange(tempDataOut, 0, tempOutLen[0]);
                response.result = dataOut;
            }
        }

        return gson.toJson(response);
    }

    /**
     * RSA公钥运算
     *
     * @param args
     * @return
     */
    public String rsaPubKeyCalc(String args) {
        Gson gson = new Gson();
        RSAPubKeyCalcRequestData rsaPubKeyCalcRequestData =
                gson.fromJson(args, RSAPubKeyCalcRequestData.class);
        JarJniApiProxy proxy = getProxy(rsaPubKeyCalcRequestData.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {

            byte[] dataIn = rsaPubKeyCalcRequestData.getDataIn();
            byte[] pubfid = rsaPubKeyCalcRequestData.getPubFid();
            XDJA_RSA_PUBKEY rsa_pubkey = rsaPubKeyCalcRequestData.getPubKey();

            byte[] dataout = new byte[256];
            int[] outlen = {0, 0};
            int ret = proxy.RSAPubKeyCalc(pubfid, rsa_pubkey, dataIn, dataIn.length, dataout, outlen);
            response.ret_code = ret;
            if (ret == JNIAPI.XKR_OK) {
                DataOut dataOut = new DataOut();
                dataOut.dataOut = Arrays.copyOfRange(dataout, 0, outlen[0]);
                response.result = dataOut;
            }
        }

        return gson.toJson(response);
    }


    /**
     * RSA数据签名
     *
     * @param args
     * @return
     */
    public String rsaSign(String args) {
        Gson gson = new Gson();
        RSASignRequest rsaSignRequest =
                gson.fromJson(args, RSASignRequest.class);
        JarJniApiProxy proxy = getProxy(rsaSignRequest.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            byte[] dataout = new byte[256];
            int[] outlen = {0, 0};
            response.ret_code = proxy.RSASign(rsaSignRequest.getBits(), rsaSignRequest.getPriFid(),
                    rsaSignRequest.getDataType(), rsaSignRequest.getDataIn(),
                    rsaSignRequest.getDataIn().length, dataout, outlen);
            if (response.ret_code == JNIAPI.XKR_OK) {
                DataOut dataOut = new DataOut();
                dataOut.dataOut = Arrays.copyOfRange(dataout, 0, outlen[0]);
                response.result = dataOut;
            }
        }

        return gson.toJson(response);
    }


    /**
     * RSA数据签名验证
     *
     * @param args
     * @return
     */
    public String rsaSignVerify(String args) {
        Gson gson = new Gson();
        RSASignVerifyRequest rsaSignVerifyRequest =
                gson.fromJson(args, RSASignVerifyRequest.class);
        JarJniApiProxy proxy = getProxy(rsaSignVerifyRequest.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = JNIAPI.XKR_NO_KEY;
        } else {
            response.ret_code = proxy.RSASignVerify(rsaSignVerifyRequest.getBits(), rsaSignVerifyRequest.getPubFid(),
                    rsaSignVerifyRequest.getPubKey(), rsaSignVerifyRequest.getDataType(),
                    rsaSignVerifyRequest.getDataIn(), rsaSignVerifyRequest.getDataIn().length,
                    rsaSignVerifyRequest.getSignatureData());
        }
        return gson.toJson(response);
    }


    //-----------------------------------------------------gyx↑

    /**
     * 根据cardId获取卡代理对象
     *
     * @param cardId
     * @return
     */
    private synchronized JarJniApiProxy getProxy(String cardId) {
        if (proxyMap.containsKey(cardId)) {
            return proxyMap.get(cardId);
        }

        Pair<Integer, JarJniApiProxy> makePair = JarMultiJniApiManager.getInstance().make(context, cardId);
        if (makePair.first == 0) {
            proxyMap.put(cardId, makePair.second);
            return makePair.second;
        }
        return null;
    }

}
