package com.xdja.safekeyservice.jsservercards;

import android.content.Context;
import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.server.AsyncHttpServer;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.xdja.multichip.jniapi.JarMultiJniApiErrorCode;
import com.xdja.safekeyservice.jsservercards.bean.RequestBean;

import java.lang.reflect.Method;
import java.util.ArrayList;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/10/9 <br/>
 */
public class CardsWebSocketServer {

    public static final String KEY_id = "id";
    public static final String KEY_method = "method";
    public static final String KEY_ret_code = "ret_code";
    public static final String KEY_content = "content";

    public static final String WEBSOCKET_METHOD = "/callMultiChip";

    private static final String TAG = CardsWebSocketServer.class.getSimpleName() + "Tag";
    private static CardsWebSocketServer instance;
    private Gson gson = new Gson();

    private int portStart = 9988;
    private int portEnd = 9999;
    private Context context;

    private CardsWebSocketServer(Context context) {
        this.context = context;
    }

    public static CardsWebSocketServer getInstance(Context context) {
        if (instance == null) {
            synchronized (CardsWebSocketServer.class) {
                if (instance == null) {
                    instance = new CardsWebSocketServer(context);
                }
            }
        }
        return instance;
    }


    private AsyncHttpServer server = new AsyncHttpServer();

    class ErrorCallback implements CompletedCallback {
        private int port;

        public ErrorCallback(int port) {
            this.port = port;
        }

        @Override
        public void onCompleted(Exception ex) {
            errorList.add(port);
        }
    }

    ArrayList<Integer> errorList = new ArrayList<>();
    private int flag = 0;

    public int start() {
        if (flag == 1) {
            return 0;
        }
        int port;
        for (port = portStart; port <= portEnd; port++) {
            server.setErrorCallback(new ErrorCallback(port));
            server.listen(port);
            if (errorList.contains(port)) {
                continue;
            }
            break;
        }
        if (port > portEnd) {
            return -1;
        }
        server.websocket(WEBSOCKET_METHOD, new AsyncHttpServer.WebSocketRequestCallback() {
            @Override
            public void onConnected(final WebSocket webSocket, AsyncHttpServerRequest request) {
                webSocket.setClosedCallback(new CompletedCallback() {
                    @Override
                    public void onCompleted(Exception e) {
                        if (e != null) {
                            Log.e("testPort", e.toString());
                        }
                    }
                });

                webSocket.setStringCallback(new WebSocket.StringCallback() {
                    @Override
                    public void onStringAvailable(String s) {
                        RequestBean requestBean = gson.fromJson(s, RequestBean.class);
                        if (requestBean != null) {
                            handleRequest(webSocket, requestBean);
                        }
                    }
                });
            }
        });
        if (errorList.contains(port)) {
            return -1;
        }
        flag = 1;
        return 0;
    }

    /**
     * 处理请求
     *
     * @param webSocket
     * @param requestBean
     */
    private void handleRequest(WebSocket webSocket, RequestBean requestBean) {
        String methodStr = requestBean.getMethod();
        String result;
        Gson gson = new Gson();
        try {
            Method method = CardsOperate.class.getDeclaredMethod(methodStr, String.class);
            result = (String) method.invoke(CardsOperate.getInstance(context), gson.toJson(requestBean.getArgs()));
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
            JsonObject errorJs = new JsonObject();
            errorJs.addProperty(KEY_ret_code, JarMultiJniApiErrorCode.NO_SUCH_METHOD);
            result = errorJs.toString();
        } catch (Exception e) {
            e.printStackTrace();
            JsonObject errorJs = new JsonObject();
            errorJs.addProperty(KEY_ret_code, JarMultiJniApiErrorCode.RET_EXCEPTION);
            result = errorJs.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"");
        sb.append(KEY_id);
        sb.append("\":");
        sb.append("\"");
        sb.append(requestBean.getId());
        sb.append("\"");
        sb.append(",");

        sb.append("\"");
        sb.append(KEY_method);
        sb.append("\":");
        sb.append("\"");
        sb.append(methodStr);
        sb.append("\"");
        sb.append(",");

        sb.append("\"");
        sb.append(KEY_content);
        sb.append("\":");
        sb.append(result);
        sb.append("}");
        webSocket.send(sb.toString());
    }

    /**
     * 获取启动标志位
     *
     * @return 0:未启动；1：已启动
     */
    public int getStartFlag() {
        return flag;
    }
}
