/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safekeyservice.jsservercards;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.google.gson.Gson;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.safekeyservice.jsservercards.bean.DataOut;
import com.xdja.safekeyservice.jsservercards.bean.RSAKeys;
import com.xdja.safekeyservice.jsservercards.bean.request.CardIdRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.ChangePinRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.CreateFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.DelFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.GenRandomRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.GenRsaKeyPairRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.GenSM2KeyPairRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.GetActiveRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.GetFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.GetPinTryCountRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.RSAPriKeyCalcRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.RSAPubKeyCalcRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.RSASignRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.RSASignVerifyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.ReadCertRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.ReadFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.ReadRsapubKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.ReadSm2PubKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.ReloadPinRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.SM1Request;
import com.xdja.safekeyservice.jsservercards.bean.request.SM3Request;
import com.xdja.safekeyservice.jsservercards.bean.request.SMKEYRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.SelectFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.Sm2DecryptRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.Sm2EncryptRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.Sm2SignRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.Sm2SignVerifyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.VerifyPinRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteCertRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteFileRequestData;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteRsapriKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteRsapubKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteSm2PriKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.request.WriteSm2PubKeyRequest;
import com.xdja.safekeyservice.jsservercards.bean.response.BaseResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.DataOutAndIvResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.GenRandomRes;
import com.xdja.safekeyservice.jsservercards.bean.response.GenSM2KeyPairResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.GetAllResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.GetDevInfoResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.GetFileResData;
import com.xdja.safekeyservice.jsservercards.bean.response.ReadCertResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.ReadFileResData;
import com.xdja.safekeyservice.jsservercards.bean.response.ReadSm2PubkeyResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.RetCodeResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.Sm2DecryptResponse;
import com.xdja.safekeyservice.jsservercards.bean.response.Sm2EncryptReponse;
import com.xdja.safekeyservice.jsservercards.bean.response.Sm2SignResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class CardsOperate {
    public static final String TAG = "CardsOperateTag";
    private static CardsOperate instance;
    private Context context;
    private HashMap<String, JarJniApiProxy> proxyMap = new HashMap();
    private static final String ALG_SM1KEY = "SM1KEY";
    private static final String ALG_SM4KEY = "SM4KEY";

    private CardsOperate(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CardsOperate getInstance(Context context) {
        if (instance != null) return instance;
        Class<CardsOperate> clazz = CardsOperate.class;
        synchronized (CardsOperate.class) {
            if (instance != null) return instance;
            if (context == null) {
                throw new NullPointerException("Context is null.");
            }
            instance = new CardsOperate(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public String getAll(String args) {
        Pair pair = JarMultiJniApiManager.getInstance().getAll(this.context);
        GetAllResponse response = new GetAllResponse();
        response.setRetCode((Integer)pair.first);
        if ((Integer)pair.first == 0) {
            for (JniApiParam param : (List)pair.second) {
                if (!TextUtils.isEmpty((CharSequence)param.other)) continue;
                param.other = " ";
            }
            response.setContent((List)pair.second);
        }
        Gson gson = new Gson();
        return gson.toJson((Object)response);
    }

    public String getDevInfo(String args) {
        GetDevInfoResponse response;
        Gson gson = new Gson();
        CardIdRequest bean = (CardIdRequest)gson.fromJson(args, CardIdRequest.class);
        JarJniApiProxy proxy = this.getProxy(bean.cardId);
        if (proxy == null) {
            response = new GetDevInfoResponse();
            response.ret_code = -97;
        } else {
            XDJA_DEVINFO devInfo = new XDJA_DEVINFO();
            int ret = proxy.GetDevInfo(devInfo);
            response = new GetDevInfoResponse(ret, devInfo);
        }
        return gson.toJson((Object)response);
    }

    public String changePin(String args) {
        Gson gson = new Gson();
        ChangePinRequest bean = (ChangePinRequest)gson.fromJson(args, ChangePinRequest.class);
        JarJniApiProxy proxy = this.getProxy(bean.cardId);
        RetCodeResponse response = new RetCodeResponse();
        if (proxy == null) {
            response.ret_code = -97;
        } else {
            int ret;
            byte[] oldPin = bean.oldPin.getBytes();
            byte[] newPin = bean.newPin.getBytes();
            int newPINLen = newPin.length;
            response.ret_code = newPINLen < 6 || newPINLen > 16 ? -9 : (ret = proxy.ChangePIN(bean.pinRole, oldPin, oldPin.length, newPin, newPINLen));
        }
        return gson.toJson((Object)response);
    }

    public String verifyPin(String args) {
        Gson gson = new Gson();
        VerifyPinRequest bean = (VerifyPinRequest)gson.fromJson(args, VerifyPinRequest.class);
        JarJniApiProxy proxy = this.getProxy(bean.cardId);
        RetCodeResponse response = new RetCodeResponse();
        if (proxy == null) {
            response.ret_code = -97;
        } else {
            int ret;
            byte[] pin = bean.pin.getBytes();
            response.ret_code = ret = proxy.VerifyPIN(bean.pinRole, pin, pin.length);
        }
        return gson.toJson((Object)response);
    }

    public String getPinTryCount(String args) {
        int ret;
        Gson gson = new Gson();
        GetPinTryCountRequest bean = (GetPinTryCountRequest)gson.fromJson(args, GetPinTryCountRequest.class);
        JarJniApiProxy proxy = this.getProxy(bean.cardId);
        RetCodeResponse response = new RetCodeResponse();
        response.ret_code = proxy == null ? -97 : (ret = proxy.GetPinTryCount(bean.pinRole));
        return gson.toJson((Object)response);
    }

    public String reloadPin(String args) {
        Gson gson = new Gson();
        ReloadPinRequest bean = (ReloadPinRequest)gson.fromJson(args, ReloadPinRequest.class);
        JarJniApiProxy proxy = this.getProxy(bean.cardId);
        RetCodeResponse response = new RetCodeResponse();
        if (proxy == null) {
            response.ret_code = -97;
        } else {
            int ret;
            byte[] key = bean.key.getBytes();
            byte[] newPin = bean.newPin.getBytes();
            response.ret_code = ret = proxy.ReloadPIN(bean.pinRole, key, key.length, newPin, newPin.length);
        }
        return gson.toJson((Object)response);
    }

    public String sm1(String args) {
        Gson gson = new Gson();
        SM1Request bean = (SM1Request)gson.fromJson(args, SM1Request.class);
        JarJniApiProxy proxy = this.getProxy(bean.cardId);
        DataOutAndIvResponse response = new DataOutAndIvResponse();
        if (proxy == null) {
            response.ret_code = -97;
        } else if (bean.dataIn == null) {
            response.ret_code = -9;
        } else if (this.checkFlagAndIv(bean.flag, bean.iv) != 0) {
            response.ret_code = -9;
        } else {
            int ret;
            if (bean.flag == 0 || bean.flag == 1) {
                bean.iv = null;
            }
            byte[] dataOut = new byte[bean.dataIn.length];
            response.ret_code = ret = proxy.SM1(bean.dataIn, bean.dataIn.length, bean.flag, dataOut, bean.kid, bean.iv);
            if (ret == 0) {
                response.setResult(dataOut, bean.iv);
            }
        }
        return gson.toJson((Object)response);
    }

    public String sm1Key(String args) {
        return this.smKeyPri(args, ALG_SM1KEY);
    }

    public String sm4Key(String args) {
        return this.smKeyPri(args, ALG_SM4KEY);
    }

    public String sm3(String args) {
        Gson gson = new Gson();
        SM3Request bean = (SM3Request)gson.fromJson(args, SM3Request.class);
        JarJniApiProxy proxy = this.getProxy(bean.cardId);
        DataOutAndIvResponse response = new DataOutAndIvResponse();
        if (proxy == null) {
            response.ret_code = -97;
        } else if (bean.dataIn == null) {
            response.ret_code = -9;
        } else {
            int ret;
            byte[] dataOut = new byte[32];
            response.ret_code = ret = proxy.SM3(bean.dataIn, bean.dataIn.length, dataOut);
            if (ret == 0) {
                response.setResult(dataOut, null);
            }
        }
        return gson.toJson((Object)response);
    }

    private String smKeyPri(String args, String alg) {
        Gson gson = new Gson();
        SMKEYRequest bean = (SMKEYRequest)gson.fromJson(args, SMKEYRequest.class);
        JarJniApiProxy proxy = this.getProxy(bean.cardId);
        DataOutAndIvResponse response = new DataOutAndIvResponse();
        if (proxy == null) {
            response.ret_code = -97;
        } else if (bean.dataIn == null || bean.tmpKey == null) {
            response.ret_code = -9;
        } else if (this.checkFlagAndIv(bean.flag, bean.iv) != 0) {
            response.ret_code = -9;
        } else {
            if (bean.flag == 0 || bean.flag == 1) {
                bean.iv = null;
            }
            byte[] dataOut = new byte[bean.dataIn.length];
            int ret = -9;
            if (alg.equals(ALG_SM1KEY)) {
                ret = proxy.SM1KEY(bean.tmpKey, bean.dataIn, bean.dataIn.length, bean.flag, dataOut, bean.iv);
            } else if (alg.equals(ALG_SM4KEY)) {
                ret = proxy.SM4KEY(bean.tmpKey, bean.dataIn, bean.dataIn.length, bean.flag, dataOut, bean.iv);
            } else {
                Log.e((String)TAG, (String)("smKeyPri alg error! [" + alg + "]"));
            }
            response.ret_code = ret;
            if (ret == 0) {
                response.setResult(dataOut, bean.iv);
            }
        }
        return gson.toJson((Object)response);
    }

    private int checkFlagAndIv(int flag, byte[] iv) {
        if ((flag == 16 || flag == 17) && iv == null) {
            return -1;
        }
        return 0;
    }

    public String getActivateState(String args) {
        Gson gson = new Gson();
        GetActiveRequestData getActiveRequestData = (GetActiveRequestData)gson.fromJson(args, GetActiveRequestData.class);
        Pair make = JarMultiJniApiManager.getInstance().make(this.context, getActiveRequestData.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        JarJniApiProxy jniApiProxy = (JarJniApiProxy)make.second;
        baseResponse.ret_code = jniApiProxy == null ? -97 : jniApiProxy.GetActivateState();
        return gson.toJson((Object)baseResponse);
    }

    public String genRandom(String args) {
        Gson gson = new Gson();
        GenRandomRequestData genRandomRequestData = (GenRandomRequestData)gson.fromJson(args, GenRandomRequestData.class);
        Pair make = JarMultiJniApiManager.getInstance().make(this.context, genRandomRequestData.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        JarJniApiProxy jniApiProxy = (JarJniApiProxy)make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = -97;
        } else {
            byte[] randomTmp = new byte[genRandomRequestData.getLen()];
            int ret_code = jniApiProxy.GenRandom(genRandomRequestData.getLen(), randomTmp);
            if (ret_code == 0) {
                GenRandomRes genRandomRes = new GenRandomRes();
                genRandomRes.setRandom(randomTmp);
                baseResponse.result = genRandomRes;
            }
            baseResponse.ret_code = jniApiProxy.GetActivateState();
        }
        return gson.toJson((Object)baseResponse);
    }

    public String selectFile(String args) {
        Log.v((String)"CardsOperate", (String)("selectFile args: " + args));
        Gson gson = new Gson();
        SelectFileRequestData selectFileRequestData = (SelectFileRequestData)gson.fromJson(args, SelectFileRequestData.class);
        Pair make = JarMultiJniApiManager.getInstance().make(this.context, selectFileRequestData.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        JarJniApiProxy jniApiProxy = (JarJniApiProxy)make.second;
        baseResponse.ret_code = jniApiProxy == null ? -97 : jniApiProxy.SelectFile(selectFileRequestData.getFid());
        return gson.toJson((Object)baseResponse);
    }

    public String deleteFile(String args) {
        Log.v((String)"CardsOperate", (String)("deleteFile args: " + args));
        Gson gson = new Gson();
        DelFileRequestData delFileRequestData = (DelFileRequestData)gson.fromJson(args, DelFileRequestData.class);
        Pair make = JarMultiJniApiManager.getInstance().make(this.context, delFileRequestData.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        JarJniApiProxy jniApiProxy = (JarJniApiProxy)make.second;
        baseResponse.ret_code = jniApiProxy == null ? -97 : jniApiProxy.DeleteFile(delFileRequestData.getFid());
        return gson.toJson((Object)baseResponse);
    }

    public String createFile(String args) {
        Log.v((String)"CardsOperate", (String)("createFile args: " + args));
        Gson gson = new Gson();
        CreateFileRequestData createFileRequestData = (CreateFileRequestData)gson.fromJson(args, CreateFileRequestData.class);
        Pair make = JarMultiJniApiManager.getInstance().make(this.context, createFileRequestData.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        JarJniApiProxy jniApiProxy = (JarJniApiProxy)make.second;
        baseResponse.ret_code = jniApiProxy == null ? -97 : jniApiProxy.CreateFile(createFileRequestData.getXdjaFile());
        return gson.toJson((Object)baseResponse);
    }

    public String getFileInfo(String args) {
        Log.v((String)"CardsOperate", (String)("getFileInfo args: " + args));
        Gson gson = new Gson();
        GetFileRequestData getFileRequestData = (GetFileRequestData)gson.fromJson(args, GetFileRequestData.class);
        Pair make = JarMultiJniApiManager.getInstance().make(this.context, getFileRequestData.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        JarJniApiProxy jniApiProxy = (JarJniApiProxy)make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = -97;
        } else {
            XDJA_FILE xdja_file = new XDJA_FILE();
            baseResponse.ret_code = jniApiProxy.GetFileInfo(getFileRequestData.getFid(), xdja_file);
            if (baseResponse.ret_code == 0) {
                GetFileResData getFileResData = new GetFileResData();
                getFileResData.setFile(xdja_file);
                baseResponse.result = getFileResData;
            }
        }
        return gson.toJson((Object)baseResponse);
    }

    public String readFile(String args) {
        Log.v((String)"CardsOperate", (String)("readFile  args: " + args));
        Gson gson = new Gson();
        ReadFileRequestData readFileRequestData = (ReadFileRequestData)gson.fromJson(args, ReadFileRequestData.class);
        Pair make = JarMultiJniApiManager.getInstance().make(this.context, readFileRequestData.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        JarJniApiProxy jniApiProxy = (JarJniApiProxy)make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = -97;
        } else {
            byte[] dataOut = new byte[readFileRequestData.getReadLen()];
            baseResponse.ret_code = jniApiProxy.ReadFile(readFileRequestData.getFid(), readFileRequestData.getReadPos(), readFileRequestData.getReadLen(), dataOut);
            if (baseResponse.ret_code == 0) {
                ReadFileResData readFileResData = new ReadFileResData();
                readFileResData.setData(dataOut);
                baseResponse.result = readFileResData;
            }
        }
        return gson.toJson((Object)baseResponse);
    }

    public String writeFile(String args) {
        Log.v((String)"CardsOperate", (String)("writeFile  args: " + args));
        Gson gson = new Gson();
        WriteFileRequestData writeFileRequestData = (WriteFileRequestData)gson.fromJson(args, WriteFileRequestData.class);
        Pair make = JarMultiJniApiManager.getInstance().make(this.context, writeFileRequestData.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        JarJniApiProxy jniApiProxy = (JarJniApiProxy)make.second;
        baseResponse.ret_code = jniApiProxy == null ? -97 : jniApiProxy.WriteFile(writeFileRequestData.getFid(), writeFileRequestData.getWritePos(), writeFileRequestData.getWriteLen(), writeFileRequestData.getDataIn());
        Log.v((String)"CardsOperate", (String)("writeFile  ret: " + baseResponse.ret_code));
        return gson.toJson((Object)baseResponse);
    }

    public String readCert(String args) {
        Log.v((String)"CardsOperate", (String)("readCert  args: " + args));
        Gson gson = new Gson();
        ReadCertRequestData readCertRequestData = (ReadCertRequestData)gson.fromJson(args, ReadCertRequestData.class);
        Pair make = JarMultiJniApiManager.getInstance().make(this.context, readCertRequestData.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        JarJniApiProxy jniApiProxy = (JarJniApiProxy)make.second;
        if (jniApiProxy == null) {
            baseResponse.ret_code = -97;
        } else {
            byte[] certBufTmp = new byte[2048];
            int[] certLen = new int[2];
            baseResponse.ret_code = jniApiProxy.ReadCert(readCertRequestData.getFid(), certBufTmp, certLen);
            if (baseResponse.ret_code == 0) {
                byte[] certBuf = new byte[certLen[0]];
                System.arraycopy(certBufTmp, 0, certBuf, 0, certLen[0]);
                ReadCertResponse readCertResponse = new ReadCertResponse();
                readCertResponse.setCertBuf(certBuf);
                baseResponse.result = readCertResponse;
            }
        }
        Log.v((String)"CardsOperate", (String)("readCert  ret: " + baseResponse.ret_code));
        return gson.toJson((Object)baseResponse);
    }

    public String writeCert(String args) {
        Log.v((String)"CardsOperate", (String)("writeCert  args: " + args));
        Gson gson = new Gson();
        WriteCertRequestData writeCertRequestData = (WriteCertRequestData)gson.fromJson(args, WriteCertRequestData.class);
        Pair make = JarMultiJniApiManager.getInstance().make(this.context, writeCertRequestData.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        JarJniApiProxy jniApiProxy = (JarJniApiProxy)make.second;
        baseResponse.ret_code = jniApiProxy == null ? -97 : jniApiProxy.WriteCert(writeCertRequestData.getFid(), writeCertRequestData.getCertBuf(), writeCertRequestData.getCertBuf().length);
        Log.v((String)"CardsOperate", (String)("writeFile  ret: " + baseResponse.ret_code));
        return gson.toJson((Object)baseResponse);
    }

    public String readSm2PubKey(String args) {
        Gson gson = new Gson();
        ReadSm2PubKeyRequest request = (ReadSm2PubKeyRequest)gson.fromJson(args, ReadSm2PubKeyRequest.class);
        Pair proxy = JarMultiJniApiManager.getInstance().make(this.context, request.getCardId());
        BaseResponse response = null;
        if ((Integer)proxy.first == 0) {
            response = new BaseResponse();
            JarJniApiProxy jarJniApiProxy = (JarJniApiProxy)proxy.second;
            XDJA_SM2_PUBKEY xdja_sm2_pubkey = new XDJA_SM2_PUBKEY();
            int resCode = jarJniApiProxy.ReadSm2PubKey(request.getPubFid(), xdja_sm2_pubkey);
            if (resCode == 0) {
                ReadSm2PubkeyResponse readSm2PubkeyResponse = new ReadSm2PubkeyResponse();
                readSm2PubkeyResponse.setPubKey(xdja_sm2_pubkey);
                response.ret_code = 0;
                response.result = readSm2PubkeyResponse;
            } else {
                response.ret_code = resCode;
                response.result = null;
            }
        } else {
            response.ret_code = (Integer)proxy.first;
            response.result = null;
        }
        return gson.toJson((Object)response);
    }

    public String writeSm2PubKey(String args) {
        Gson gson = new Gson();
        WriteSm2PubKeyRequest request = (WriteSm2PubKeyRequest)gson.fromJson(args, WriteSm2PubKeyRequest.class);
        Pair proxyPair = JarMultiJniApiManager.getInstance().make(this.context, request.getCardId());
        BaseResponse response = new BaseResponse();
        if ((Integer)proxyPair.first == 0) {
            int resCode;
            byte[] pubFid = request.getPubFid();
            XDJA_SM2_PUBKEY pubkey = request.getPubKey();
            JarJniApiProxy jarJniApiProxy = (JarJniApiProxy)proxyPair.second;
            response.ret_code = resCode = jarJniApiProxy.WriteSm2PubKey(pubFid, pubkey);
        } else {
            response.ret_code = (Integer)proxyPair.first;
        }
        response.result = null;
        return gson.toJson((Object)response);
    }

    public String writeSm2PriKey(String args) {
        Gson gson = new Gson();
        WriteSm2PriKeyRequest request = (WriteSm2PriKeyRequest)gson.fromJson(args, WriteSm2PriKeyRequest.class);
        Pair proxyPair = JarMultiJniApiManager.getInstance().make(this.context, request.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        if ((Integer)proxyPair.first == 0) {
            int resCode;
            JarJniApiProxy jarJniApiProxy = (JarJniApiProxy)proxyPair.second;
            byte[] priFid = request.getPriFid();
            XDJA_SM2_PRIKEY priKey = request.getPriKey();
            baseResponse.ret_code = resCode = jarJniApiProxy.WriteSm2PriKey(priFid, priKey);
        } else {
            baseResponse.ret_code = (Integer)proxyPair.first;
        }
        baseResponse.result = null;
        return gson.toJson((Object)baseResponse);
    }

    public String genSM2KeyPair(String args) {
        Gson gson = new Gson();
        GenSM2KeyPairRequest request = (GenSM2KeyPairRequest)gson.fromJson(args, GenSM2KeyPairRequest.class);
        Pair proxyPair = JarMultiJniApiManager.getInstance().make(this.context, request.getCardId());
        GenSM2KeyPairResponse genSM2KeyPairResponse = null;
        if ((Integer)proxyPair.first == 0) {
            JarJniApiProxy jarJniApiProxy = (JarJniApiProxy)proxyPair.second;
            byte[] pubFid = request.getPubFid();
            byte[] priFid = request.getPriFid();
            XDJA_SM2_PUBKEY pubkey = new XDJA_SM2_PUBKEY();
            XDJA_SM2_PRIKEY prikey = new XDJA_SM2_PRIKEY();
            int resCode = jarJniApiProxy.GenSM2KeyPair(pubFid, priFid, pubkey, prikey);
            byte[] pubFid0 = new byte[]{0, 0};
            byte[] priFid0 = new byte[]{0, 0};
            if (resCode == 0) {
                if (!Arrays.equals(pubFid, pubFid0)) {
                    pubkey = null;
                }
                if (!Arrays.equals(pubFid, pubFid0) || !Arrays.equals(priFid, priFid0)) {
                    prikey = null;
                }
                genSM2KeyPairResponse = new GenSM2KeyPairResponse(resCode, pubkey, prikey);
            } else {
                genSM2KeyPairResponse = new GenSM2KeyPairResponse();
                genSM2KeyPairResponse.ret_code = resCode;
                genSM2KeyPairResponse.result = null;
            }
        } else {
            genSM2KeyPairResponse = new GenSM2KeyPairResponse();
            genSM2KeyPairResponse.ret_code = (Integer)proxyPair.first;
            genSM2KeyPairResponse.result = null;
        }
        return gson.toJson((Object)genSM2KeyPairResponse);
    }

    public String sm2Encrypt(String args) {
        Gson gson = new Gson();
        Sm2EncryptRequest request = (Sm2EncryptRequest)gson.fromJson(args, Sm2EncryptRequest.class);
        Pair proxyPair = JarMultiJniApiManager.getInstance().make(this.context, request.getCardId());
        Sm2EncryptReponse sm2EncryptReponse = null;
        if ((Integer)proxyPair.first == 0) {
            int[] outLen;
            byte[] dataOut;
            byte[] dataIn;
            XDJA_SM2_PUBKEY pubkey;
            JarJniApiProxy jarJniApiProxy = (JarJniApiProxy)proxyPair.second;
            byte[] pubFid = request.getPubFid();
            int resCode = jarJniApiProxy.SM2Encrypt(pubFid, pubkey = request.getPubKey(), dataIn = request.getDataIn(), dataIn.length, dataOut = new byte[256], outLen = new int[1]);
            if (resCode == 0) {
                dataOut = Arrays.copyOfRange(dataOut, 0, outLen[0]);
                sm2EncryptReponse = new Sm2EncryptReponse(resCode, dataOut);
            } else {
                sm2EncryptReponse = new Sm2EncryptReponse(resCode, null);
            }
        } else {
            sm2EncryptReponse = new Sm2EncryptReponse((Integer)proxyPair.first, null);
        }
        return gson.toJson((Object)sm2EncryptReponse);
    }

    public String sm2Decrypt(String args) {
        Gson gson = new Gson();
        Sm2DecryptRequest request = (Sm2DecryptRequest)gson.fromJson(args, Sm2DecryptRequest.class);
        Pair proxyPair = JarMultiJniApiManager.getInstance().make(this.context, request.getCardId());
        Sm2DecryptResponse sm2DecryptResponse = null;
        if ((Integer)proxyPair.first == 0) {
            int[] outLen;
            byte[] dataOut;
            JarJniApiProxy jarJniApiProxy = (JarJniApiProxy)proxyPair.second;
            byte[] dataIn = request.getDataIn();
            byte[] priFid = request.getPriFid();
            int resCode = jarJniApiProxy.SM2Decrypt(priFid, dataIn, dataIn.length, dataOut = new byte[256], outLen = new int[2]);
            if (resCode == 0) {
                dataOut = Arrays.copyOfRange(dataOut, 0, outLen[0]);
                sm2DecryptResponse = new Sm2DecryptResponse(resCode, dataOut);
            } else {
                sm2DecryptResponse = new Sm2DecryptResponse(resCode, null);
            }
        } else {
            sm2DecryptResponse = new Sm2DecryptResponse((Integer)proxyPair.first, null);
        }
        return gson.toJson((Object)sm2DecryptResponse);
    }

    public String sm2Sign(String args) {
        Gson gson = new Gson();
        Sm2SignRequest request = (Sm2SignRequest)gson.fromJson(args, Sm2SignRequest.class);
        Pair proxyPair = JarMultiJniApiManager.getInstance().make(this.context, request.getCardId());
        Sm2SignResponse sm2SignResponse = null;
        if ((Integer)proxyPair.first == 0) {
            int[] outLen;
            byte[] dataOut;
            byte[] dataIn;
            int dataType;
            byte[] priFid;
            JarJniApiProxy jarJniApiProxy = (JarJniApiProxy)proxyPair.second;
            byte[] pubFid = request.getPubFid();
            int resCode = jarJniApiProxy.SM2Sign(pubFid, priFid = request.getPriFid(), dataType = request.getDataType(), dataIn = request.getDataIn(), dataIn.length, dataOut = new byte[256], outLen = new int[2]);
            if (resCode == 0) {
                dataOut = Arrays.copyOfRange(dataOut, 0, outLen[0]);
                sm2SignResponse = new Sm2SignResponse(resCode, dataOut);
            } else {
                sm2SignResponse = new Sm2SignResponse(resCode, null);
            }
        } else {
            sm2SignResponse = new Sm2SignResponse((Integer)proxyPair.first, null);
        }
        return gson.toJson((Object)sm2SignResponse);
    }

    public String sm2SignVerify(String args) {
        Gson gson = new Gson();
        Sm2SignVerifyRequest request = (Sm2SignVerifyRequest)gson.fromJson(args, Sm2SignVerifyRequest.class);
        Pair proxyPair = JarMultiJniApiManager.getInstance().make(this.context, request.getCardId());
        BaseResponse baseResponse = new BaseResponse();
        if ((Integer)proxyPair.first == 0) {
            int resCode;
            JarJniApiProxy jarJniApiProxy = (JarJniApiProxy)proxyPair.second;
            byte[] pubFid = request.getPubFid();
            int dataType = request.getDataType();
            XDJA_SM2_PUBKEY pubKey = request.getPubKey();
            byte[] dataIn = request.getDataIn();
            byte[] signatureData = request.getSignatureData();
            baseResponse.ret_code = resCode = jarJniApiProxy.SM2SignVerify(pubFid, dataType, pubKey, dataIn, dataIn.length, signatureData);
        } else {
            baseResponse.ret_code = (Integer)proxyPair.first;
        }
        return gson.toJson((Object)baseResponse);
    }

    public String genRsaKeyPair(String args) {
        Gson gson = new Gson();
        GenRsaKeyPairRequest genRsaKeyPairRequest = (GenRsaKeyPairRequest)gson.fromJson(args, GenRsaKeyPairRequest.class);
        JarJniApiProxy proxy = this.getProxy(genRsaKeyPairRequest.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = -97;
        } else {
            int bits = genRsaKeyPairRequest.getBits();
            byte[] pubFid = genRsaKeyPairRequest.getPubFid();
            byte[] priFid = genRsaKeyPairRequest.getPriFid();
            XDJA_RSA_PUBKEY xdja_rsa_pubkey = new XDJA_RSA_PUBKEY();
            XDJA_RSA_PRIKEY xdja_rsa_prikey = new XDJA_RSA_PRIKEY();
            response.ret_code = proxy.GenRSAKeyPair(bits, pubFid, priFid, xdja_rsa_pubkey, xdja_rsa_prikey);
            if (response.ret_code == 0) {
                boolean isPubKeyOut = false;
                byte[] cmpBytes = new byte[]{0, 0};
                if (Arrays.equals(pubFid, cmpBytes)) {
                    isPubKeyOut = true;
                }
                boolean isPriKeyOut = false;
                if (Arrays.equals(priFid, cmpBytes)) {
                    isPriKeyOut = true;
                }
                if (isPubKeyOut) {
                    RSAKeys rsaKeys = new RSAKeys();
                    rsaKeys.setPubKey(xdja_rsa_pubkey);
                    if (isPriKeyOut) {
                        rsaKeys.setPriKey(xdja_rsa_prikey);
                    }
                    response.result = rsaKeys;
                }
            }
        }
        return gson.toJson((Object)response);
    }

    public String readRsapubKey(String args) {
        Gson gson = new Gson();
        ReadRsapubKeyRequest readRsapubKeyRequest = (ReadRsapubKeyRequest)gson.fromJson(args, ReadRsapubKeyRequest.class);
        JarJniApiProxy proxy = this.getProxy(readRsapubKeyRequest.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = -97;
        } else {
            XDJA_RSA_PUBKEY xdja_rsa_pubkey = new XDJA_RSA_PUBKEY();
            response.ret_code = proxy.ReadRsaPubKey(readRsapubKeyRequest.getPubFid(), xdja_rsa_pubkey);
            if (response.ret_code == 0) {
                HashMap<String, XDJA_RSA_PUBKEY> hashMap = new HashMap<String, XDJA_RSA_PUBKEY>();
                hashMap.put("pubKey", xdja_rsa_pubkey);
                response.result = hashMap;
            }
        }
        return gson.toJson((Object)response);
    }

    public String writeRsapubKey(String args) {
        Gson gson = new Gson();
        WriteRsapubKeyRequest writeRsapubKeyRequest = (WriteRsapubKeyRequest)gson.fromJson(args, WriteRsapubKeyRequest.class);
        JarJniApiProxy proxy = this.getProxy(writeRsapubKeyRequest.getCardId());
        BaseResponse response = new BaseResponse();
        response.ret_code = proxy == null ? -97 : proxy.WriteRsaPubKey(writeRsapubKeyRequest.getPubFid(), writeRsapubKeyRequest.getPubKey());
        return gson.toJson((Object)response);
    }

    public String writeRsapriKey(String args) {
        Gson gson = new Gson();
        WriteRsapriKeyRequest writeRsapriKeyRequest = (WriteRsapriKeyRequest)gson.fromJson(args, WriteRsapriKeyRequest.class);
        JarJniApiProxy proxy = this.getProxy(writeRsapriKeyRequest.getCardId());
        BaseResponse response = new BaseResponse();
        response.ret_code = proxy == null ? -97 : proxy.WriteRsaPriKey(writeRsapriKeyRequest.getPriFid(), writeRsapriKeyRequest.getPriKey());
        return gson.toJson((Object)response);
    }

    public String rsaPriKeyCalc(String args) {
        Gson gson = new Gson();
        RSAPriKeyCalcRequestData rsaPriKeyCalcRequestData = (RSAPriKeyCalcRequestData)gson.fromJson(args, RSAPriKeyCalcRequestData.class);
        JarJniApiProxy proxy = this.getProxy(rsaPriKeyCalcRequestData.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = -97;
        } else {
            byte[] prifid = rsaPriKeyCalcRequestData.getPriFid();
            byte[] dataIn = rsaPriKeyCalcRequestData.getDataIn();
            byte[] tempDataOut = new byte[256];
            int[] tempOutLen = new int[]{0, 0};
            response.ret_code = proxy.RSAPriKeyCalc(prifid, dataIn, dataIn.length, tempDataOut, tempOutLen);
            if (response.ret_code == 0) {
                DataOut dataOut = new DataOut();
                dataOut.dataOut = Arrays.copyOfRange(tempDataOut, 0, tempOutLen[0]);
                response.result = dataOut;
            }
        }
        return gson.toJson((Object)response);
    }

    public String rsaPubKeyCalc(String args) {
        Gson gson = new Gson();
        RSAPubKeyCalcRequestData rsaPubKeyCalcRequestData = (RSAPubKeyCalcRequestData)gson.fromJson(args, RSAPubKeyCalcRequestData.class);
        JarJniApiProxy proxy = this.getProxy(rsaPubKeyCalcRequestData.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = -97;
        } else {
            int ret;
            byte[] dataIn = rsaPubKeyCalcRequestData.getDataIn();
            byte[] pubfid = rsaPubKeyCalcRequestData.getPubFid();
            XDJA_RSA_PUBKEY rsa_pubkey = rsaPubKeyCalcRequestData.getPubKey();
            byte[] dataout = new byte[256];
            int[] outlen = new int[]{0, 0};
            response.ret_code = ret = proxy.RSAPubKeyCalc(pubfid, rsa_pubkey, dataIn, dataIn.length, dataout, outlen);
            if (ret == 0) {
                DataOut dataOut = new DataOut();
                dataOut.dataOut = Arrays.copyOfRange(dataout, 0, outlen[0]);
                response.result = dataOut;
            }
        }
        return gson.toJson((Object)response);
    }

    public String rsaSign(String args) {
        Gson gson = new Gson();
        RSASignRequest rsaSignRequest = (RSASignRequest)gson.fromJson(args, RSASignRequest.class);
        JarJniApiProxy proxy = this.getProxy(rsaSignRequest.getCardId());
        BaseResponse response = new BaseResponse();
        if (proxy == null) {
            response.ret_code = -97;
        } else {
            byte[] dataout = new byte[256];
            int[] outlen = new int[]{0, 0};
            response.ret_code = proxy.RSASign(rsaSignRequest.getBits(), rsaSignRequest.getPriFid(), rsaSignRequest.getDataType(), rsaSignRequest.getDataIn(), rsaSignRequest.getDataIn().length, dataout, outlen);
            if (response.ret_code == 0) {
                DataOut dataOut = new DataOut();
                dataOut.dataOut = Arrays.copyOfRange(dataout, 0, outlen[0]);
                response.result = dataOut;
            }
        }
        return gson.toJson((Object)response);
    }

    public String rsaSignVerify(String args) {
        Gson gson = new Gson();
        RSASignVerifyRequest rsaSignVerifyRequest = (RSASignVerifyRequest)gson.fromJson(args, RSASignVerifyRequest.class);
        JarJniApiProxy proxy = this.getProxy(rsaSignVerifyRequest.getCardId());
        BaseResponse response = new BaseResponse();
        response.ret_code = proxy == null ? -97 : proxy.RSASignVerify(rsaSignVerifyRequest.getBits(), rsaSignVerifyRequest.getPubFid(), rsaSignVerifyRequest.getPubKey(), rsaSignVerifyRequest.getDataType(), rsaSignVerifyRequest.getDataIn(), rsaSignVerifyRequest.getDataIn().length, rsaSignVerifyRequest.getSignatureData());
        return gson.toJson((Object)response);
    }

    private synchronized JarJniApiProxy getProxy(String cardId) {
        if (this.proxyMap.containsKey(cardId)) {
            return this.proxyMap.get(cardId);
        }
        Pair makePair = JarMultiJniApiManager.getInstance().make(this.context, cardId);
        if ((Integer)makePair.first == 0) {
            this.proxyMap.put(cardId, (JarJniApiProxy)makePair.second);
            return (JarJniApiProxy)makePair.second;
        }
        return null;
    }
}

