/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.jar.forcallprovider;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import java.util.ArrayList;

public class ForCallProvider {
    private static final String PKG_SAFE_KEY_SERVICE = "com.xdja.safekeyservice";
    private static final String PKG_SAFE_CLIENT = "com.xdja.safeclient";

    public static String getCallPkg(Context context) {
        if (context == null) {
            return PKG_SAFE_KEY_SERVICE;
        }
        PackageManager pm = context.getPackageManager();
        try {
            String pkgName = PKG_SAFE_KEY_SERVICE;
            pm.getPackageInfo(pkgName, 0);
            return pkgName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            try {
                String pkgName = PKG_SAFE_CLIENT;
                pm.getPackageInfo(pkgName, 0);
                return pkgName;
            }
            catch (PackageManager.NameNotFoundException e2) {
                e2.printStackTrace();
                String pkgName = PKG_SAFE_KEY_SERVICE;
                return pkgName;
            }
        }
    }

    public static ArrayList<String> getCallMultiChipProviderPrefix(Context context) {
        String pkgName;
        ArrayList<String> list = new ArrayList<String>();
        list.add(PKG_SAFE_KEY_SERVICE);
        list.add(PKG_SAFE_CLIENT);
        if (context != null && !TextUtils.isEmpty((CharSequence)(pkgName = context.getPackageName())) && !list.contains(pkgName)) {
            list.add(pkgName);
        }
        return list;
    }

    public static Uri getGetProxyProviderUri(Context context) {
        Uri uri;
        if (context == null) {
            throw new NullPointerException("Context is null!");
        }
        String pkgName = ForCallProvider.getCallPkg(context);
        String suffix = ".provider.GetProxyProvider";
        ContentResolver contentResolver = context.getContentResolver();
        ContentProviderClient client = contentResolver.acquireContentProviderClient(uri = Uri.parse((String)("content://" + pkgName + suffix)));
        if (client != null) {
            client.release();
            return uri;
        }
        return null;
    }
}

