package com.xdja.SafeKey;

public class JNIAPI
{

	static {
	    Loadlib.loadLib();
	}

	//卡内常见返回值
	public static final int XKR_BASE                         =0;

	/**
	 * 0:成功
	 */
	public static final int XKR_OK                           =0x00000000;
	/**
	 * -1:指定的句柄不存在
	 */
	public static final int XKR_NO_HANDLE                    =XKR_BASE-1;
	/**
	 * -2:通过卡接口收发数据失败
	 */
	public static final int XKR_IO_FAILED                    =XKR_BASE-2;
	/**
	 * -3:返回数据之长度错误
	 */
	public static final int XKR_BACK_LENGTH                  =XKR_BASE-3;
	/**
	 * -4:返回数据错误
	 */
	public static final int XKR_BACK_DATA                    =XKR_BASE-4;
	/**
	 * -5:卡重置失败
	 */
	public static final int XKR_RESET_FAILED                 =XKR_BASE-5;
	/**
	 * -6:指定的角色不存在
	 */
	public static final int XKR_NO_ROLE                      =XKR_BASE-6;
	/**
	 * -7:输入数据的长度不合适
	 */
	public static final int XKR_DATAIN_SIZE                  =XKR_BASE-7;
	/**
	 * -8:指定的数据接收缓冲区大小不合适
	 */
	public static final int XKR_OUTBUF_SIZE                  =XKR_BASE-8;
	/**
	 * -9:接口参数错误
	 */
	public static final int XKR_INVALID_PARA                 =XKR_BASE-9;
	/**
	 * -10:口令错误,剩余重试次数为0
	 */
	public static final int XKR_PASSWORD                     =XKR_BASE-10;
	/**
	 * -11:EEPROM写入错误
	 */
	public static final int XKR_EEPROM_WRITE                 =XKR_BASE-11;
	/**
	 * -12:COS指令参数错误
	 */
	public static final int XKR_PARAMETER                    =XKR_BASE-12;
	/**
	 *-13: 命令与线路保护不适应
	 */
	public static final int XKR_CMD_NOTMATCH_LINE            =XKR_BASE-13;
	/**
	 * -14:命令与文件结构不相容
	 */
	public static final int XKR_CMD_NOTMATCH_FAT             =XKR_BASE-14;
	/**
	 * -15:权限不够
	 */
	public static final int XKR_NO_POWER                     =XKR_BASE-15;
	/**
	 * -16:密钥被锁死
	 */
	public static final int XKR_KEY_LOCKED                   =XKR_BASE-16;
	/**
	 * -18:数据域参数错误
	 */
	public static final int XKR_DATA_PARAMETER               =XKR_BASE-18;
	/**
	 * -19:应用锁定
	 */
	public static final int XKR_APP_LOCKED                   =XKR_BASE-19;
	/**
	 * -20:文件不存在
	 */
	public static final int XKR_FILE_NOT_EXIST               =XKR_BASE-20;
	/**
	 * -21:文件无足够空间
	 */
	public static final int XKR_NO_FILE_SPACE                =XKR_BASE-21;
	/**
	 * -22:未取随机数
	 */
	public static final int XKR_NOT_GET_RANDOM               =XKR_BASE-22;
	/**
	 * -23:文件已存在
	 */
	public static final int XKR_FILE_EXIST                   =XKR_BASE-23;
	/**
	 * -24:文件内容错误
	 */
	public static final int XKR_FILE_CONTENT                 =XKR_BASE-24;
	/**
	 * -25:错误的状态
	 */
	public static final int XKR_WRONG_STATE                  =XKR_BASE-25;
	/**
	 * -26:卡锁定
	 */
	public static final int XKR_CARD_LOCKED                  =XKR_BASE-26;
	/**
	 * -27:Le错误
	 */
	public static final int XKR_WRONG_LE                     =XKR_BASE-27;
	/**
	 * -28:命令不存在
	 */
	public static final int XKR_NO_THIS_CMD                  =XKR_BASE-28;
	/**
	 * -29:数据无效
	 */
	public static final int XKR_INVALID_DATA                 =XKR_BASE-29;
	/**
	 * -30:MAC错误
	 */
	public static final int XKR_WRONG_MAC                    =XKR_BASE-30;
	/**
	 * -31:密钥文件不存在
	 */
	public static final int XKR_KEYFILE_NOT_EXIST            =XKR_BASE-31;
	/**
	 * -32:密钥不存在
	 */
	public static final int XKR_KEY_NOT_EXIST                =XKR_BASE-32;
	/**
	 * -33:密钥类型不对
	 */
	public static final int XKR_WRONG_KEY_TYPE               =XKR_BASE-33;
	/**
	 * -34:返回公钥内容格式不对
	 */
	public static final int XKR_BAD_PUBKEY                   =XKR_BASE-34;
	/**
	 * -35:HASH运算失败
	 */
	public static final int XKR_HASH_FAILED                  =XKR_BASE-35;
	/**
	 * -36:RSA公钥运算失败
	 */
	public static final int XKR_RSAPUBLIC_FAILED             =XKR_BASE-36;
	/**
	 * -37:返回私钥内容格式不对
	 */
	public static final int XKR_BAD_PRIKEY                   =XKR_BASE-37;
	/**
	 * -38:等待用户签名确认
	 */
	public static final int XKR_SIGN_CONFIRM                 =XKR_BASE-38;
	/**
	 * -39:用户签名确认取消
	 */
	public static final int XKR_SIGN_CANCEL                  =XKR_BASE-39;
	/**
	 * -40:使用条件不满足
	 */
	public static final int XKR_CONDITION                    =XKR_BASE-40;
	/**
	 * -41:解密失败
	 */
	public static final int XKR_DECRYPT_FAIL                 =XKR_BASE-41;
	/**
	 * -42:文件偏移地址超出，即未找到数据
	 */
	public static final int XKR_NOT_FIND_DATA                =XKR_BASE-42;
	/**
	 * -43:DGI不支持
	 */
	public static final int XKR_DGI_NOT_SUPPORT              =XKR_BASE-43;
	/**
	 * -44:安全报文数据对象不正确
	 */
	public static final int XKR_DATA_NOCORRENT               =XKR_BASE-44;
	/**
	 * -45:外部认证失败
	 */
	public static final int XKR_EXAUTH_FAIL                  =XKR_BASE-45;
	/**
	 * -46:RSA密钥未找到
	 */
	public static final int XKR_RSA_NOT_FIND                 =XKR_BASE-46;
	/**
	 * -47:创建事务锁失败
	 */
	public static final int XKR_TLOCK_FAILD	                 =XKR_BASE-47;
	/**
	 * -48:事务锁超时
	 */
	public static final int XKR_TLOCK_TIMEOUT                =XKR_BASE-48;
	/**
	 * -49:证书内容错误
	 */
	public static final int XKR_BAD_CERT                     =XKR_BASE-49;
	/**
	 * -50:签名验证失败
	 */
	public static final int XKR_SIGN_VERIFY                  =XKR_BASE-50;
	/**
	 * -51:获取盘符/挂载路径失败
	 */
	public static final int XKR_GETMOUNTPATH_FAILD           =XKR_BASE-51;
	/**
	 * -95:内存申请失败
	 */
	public static final int XKR_MALLOC_FALID                 =XKR_BASE-95;
	/**
	 * -97:未插入安全卡
	 */
	public static final int XKR_NO_KEY                       =XKR_BASE-97;
	/**
	 * -98:暂不支持
	 */
	public static final int XKR_NOT_SUPPORT                  =XKR_BASE-98;
	/**
	 * -99:卡未激活,需先激活才能正常使用
	 */
	public static final int XKR_NOT_ACTIVATED                =XKR_BASE-99;
	/**
	 * -100:未知错误
	 */
	public static final int XKR_UNKNOWN                      =XKR_BASE-100;

	//↓ -----------------------------------------------------------------------------------------↓
	//↓                          VHSM新增的错误码
	//↓ -----------------------------------------------------------------------------------------↓
	/**
	 * -101:设备打开失败
	 */
	public static final int XKR_DEVFILE_OPENERR				= XKR_BASE-101;
	/**
	 * -102:取文件头信息失败
	 */
	public static final int XKR_READ_FILE_INFO				= XKR_BASE-102;
	/**
	 * -103:设备Tag错误
	 */
	public static final int XKR_DEV_TYPE					= XKR_BASE-103;
	/**
	 * -104:HMAC校验失败
	 */
	public static final int XKR_DEV_VERIFY					= XKR_BASE-104;
	/**
	 * -105:写设备序列号失败
	 */
	public static final int XKR_WRITE_DEV_SN				= XKR_BASE-105;
	/**
	 * -106:关闭设备失败
	 */
	public static final int XKR_CLOSE_DEV_FAIL				= XKR_BASE-106;
	/**
	 * -107:设备错误
	 */
	public static final int XKR_DEV_ERR						= XKR_BASE-107;
	/**
	 * -108:产生RSA密钥对失败
	 */
	public static final int XKR_RSA_GEN_FAIL				= XKR_BASE-108;
	/**
	 * -109:产生SM2密钥对失败
	 */
	public static final int XKR_SM2_GEN_FAIL				= XKR_BASE-109;
	/**
	 * -110:文件类型错误
	 */
	public static final int XKR_FILE_TYPE					= XKR_BASE-110;
	/**
	 * -111:RSA私钥运算失败
	 */
	public static final int XKR_RSAPRIVATE_FAILED			= XKR_BASE-111;
	/**
	 * -112:设置SM2参数(ID/PARAM)失败
	 */
	public static final int XKR_SM2_SET_PARAM				= XKR_BASE-112;
	/**
	 * -113:读取SM2参数(ID/PARAM)失败
	 */
	public static final int XKR_SM2_GET_PARAM				= XKR_BASE-113;
	/**
	 * -114:SM2签名失败
	 */
	public static final int XKR_SIGN_FAIL					= XKR_BASE-114;
	/**
	 * -115:SM2公钥运算失败
	 */
	public static final int XKR_SM2PUBLIC_FAILED			= XKR_BASE-115;
	/**
	 * -116:SM2私钥运算失败
	 */
	public static final int XKR_SM2PRIVATE_FAILED			= XKR_BASE-116;
	/**
	 * -117:发起方密钥计算失败
	 */
	public static final int XKR_SM2_GEN_COMPUTE				= XKR_BASE-117;
	/**
	 * -118:协商确认失败
	 */
	public static final int XKR_SM2_GEN_VERIFY				= XKR_BASE-118;
	/**
	 * -119:生成数字信封失败
	 */
	public static final int XKR_PACK_ENVELOPE				= XKR_BASE-119;
	/**
	 * -120:拆数字信封失败
	 */
	public static final int XKR_UNPACK_ENVELOPE				= XKR_BASE-120;
	/**
	 * -121:连接失败
	 */
	public static final int XKR_CONNECT_REQUEST				= XKR_BASE-121;
	/**
	 * -122:创建文件失败
	 */
	public static final int XKR_CREATE_FILE					= XKR_BASE-122;
	/**
	 * -123:打开文件失败
	 */
	public static final int XKR_OPEN_FILE					= XKR_BASE-123;
	/**
	 * -124:写文件错误
	 */
	public static final int XKR_WRITE_FILE					= XKR_BASE-124;
	/**
	 * -125:读文件失败
	 */
	public static final int XKR_READ_FILE					= XKR_BASE-125;
	/**
	 * -126:写密钥失败
	 */
	public static final int XKR_WRITE_KEY					= XKR_BASE-126;
	/**
	 * -127:创建二进制文件失败
	 */
	public static final int XKR_CREATE_BIN					= XKR_BASE-127;
	/**
	 * -128:写二进制文件失败
	 */
	public static final int XKR_WRITE_BIN					= XKR_BASE-128;
	/**
	 * -129:读二进制文件失败
	 */
	public static final int XKR_READ_BIN					= XKR_BASE-129;
	/*以下是协同相关错误码*/
	/**
	 * -130:服务端返回错误
	 */
	public static final int XKR_SERVER_ERROR				= XKR_BASE-130;
	/**
	 * -131:SOCKET读数据失败
	 */
	public static final int XKR_SOCKET_READ					= XKR_BASE-131;
	/**
	 * -132:SOCKET写数据失败
	 */
	public static final int XKR_SOCKET_WRITE				= XKR_BASE-132;
	//↑ -------------------------------------------------------------------------------------↑
	//↑                        VHSM的错误码
	//↑ -------------------------------------------------------------------------------------↑


	//支持的设备类型定义
	/**
	 * 0x0000:所有设备
	 */
	public static final int CT_ALL            = 0x0000;
	/**
	 * 0x0100:USBKEY
	 */
	public static final int CT_USBKEY         = 0x0100;
	/**
	 * 0x0110:带驱动USB设备
	 */
	public static final int CT_USBDEV         = 0x0110;
	/**
	 * 0x0120:NET设备,用于ActiveX访问USBKEY。暂不启用。
	 */
	public static final int CT_NET            = 0x0120;
	/**
	 * 0x0140:国芯芯片无存储USBKEY
	 */
	public static final int CT_USB_CCORE      = 0x0140;
	/**
	 * 0x0160:国芯芯片无存储USBKEY CDROM
	 */
	public static final int CT_USBCD          = 0x0160;
	/**
	 * 0x0170:华芯芯片带存储USBKEY
	 */
	public static final int CT_USBKEY30       = 0x0170;
	/**
	 * 0x0200:TF
	 */
	public static final int CT_TF             = 0x0200;
	/**
	 * 0x0210:XDJA TF卡
	 */
	public static final int CT_TF_XDJA        = 0x0210;
	/**
	 * 0x0210:XDJA多文件
	 */
	public static final int CT_TF_XDJA_V1     = 0x0211;
	/**
	 * 0x0212:XDJA单文件
	 */
	public static final int CT_TF_XDJA_V2     = 0x0212;
	/**
	 * 0x0213:XDJA芯片
	 */
	public static final int CT_TF_XDJA_CHIP   = 0x0213;
	/**
	 * 0x0214:XDJA自定义文件
	 */
	public static final int CT_TF_XDJA_CUSTOM = 0x0214;
	/**
	 * 0x0215:Win32   ACE手机
	 */
	public static final int CT_ACE			  = 0x0215;
	/**
	 * 0x0217:Android SPI接口芯片
	 */
	public static final int CT_XDJA_SPI		  = 0x0217;
	/**
	 * 0x0220:INCOMM卡
	 */
	public static final int CT_TF_INCOMM      = 0x0220;
	/**
	 * 0x0221:INCOMM低速卡1.0
	 */
	public static final int CT_TF_ZTEIC_OLD   = 0x0221;
	/**
	 * 0x0222:INCOMM低速卡2.0
	 */
	public static final int CT_TF_ZTEIC_NEW   = 0x0222;
	/**
	 * 0x0223:INCOMM多文件，高功耗
	 */
	public static final int CT_TF_INCOMM_V1   = 0x0223;
	/**
	 * 0x0224:INCOMM多文件，低功耗
	 */
	public static final int CT_TF_INCOMM_V2   = 0x0224;
	/**
	 * 0x0225:INCOMM单文件卡
	 */
	public static final int CT_TF_INCOMM_EX   = 0x0225;
	/**
	 * 0x0230:REDFOX卡
	 */
	public static final int CT_TF_RDFOX       = 0x0230;
	/**
	 * 0x0231:REDFOX低速卡
	 */
	public static final int CT_TF_REDFOX_LOW  = 0x0231;
	/**
	 * 0x0232:REDFOX高速卡
	 */
	public static final int CT_TF_REDFOX_HIGH = 0x0232;
	/**
	 * 0x0300:双界面IC卡
	 */
	public static final int CT_TIC            = 0x0300;
	public static final int CT_IOS            = 0x0500;

	/**
	 * 贴膜卡
	 */
	public static final int CT_TMC			   = 0x0600;
	/**
	 * 蓝牙KEY
	 */
	public static final int CT_BLE			   = 0x0700;

	/**
	 * 第三方库
	 */
	public static final int CT_TPARTY         =0x0900;

	/**
	 * 恒达TEE arm平台模块
	 */
	public static final int CT_TEESPI         =0x0A00;


	//目录类型
	/**
	 * 1:根目录
	 */
	public static final int ROOT_DIR          = 1;
	/**
	 * 2:应用目录
	 */
	public static final int APP_DIR           = 2;
	//文件类型
	/**
	 * 1:二进制文件
	 */
	public static final int FILE_BINARY       = 1;
	/**
	 * 2:私钥文件
	 */
	public static final int FILE_PUBLIC       = 2;
	/**
	 * 3:公钥文件
	 */
	public static final int FILE_PRIVATE      = 3;
	//密钥类型
	/**
	 * 0x01:SM1加密密钥
	 */
	public static final int KEY_SM1_ENCRYPT   = 0x01;
	/**
	 * 0x02:SM1解密密钥
	 */
	public static final int KEY_SM1_DECRYPT	  = 0x02;
	/**
	 * 0x03:解锁口令密钥
	 */
	public static final int KEY_PIN_UNLOCK    = 0x03;
	/**
	 * 0x04:角色口令密钥
	 */
	public static final int KEY_PIN_ROLE      = 0x04;
	/**
	 * 0x05:SM1口令重装密钥
	 */
	public static final int KEY_SM1_RELOAD    = 0x05;
	/**
	 * 0x06:DES口令重装密钥
	 */
	public static final int KEY_DES_RELOAD    = 0x06;
	//对称算法操作类型 加密 解密
	/**
	 * 0x00:对称算法操作类型  解密
	 */
	public static final int OP_DECRYPT        = 0x00;
	/**
	 * 0x01:对称算法操作类型  加密
	 */
	public static final int OP_ENCRYPT        = 0x01;
	//对称算法操作模式  ECB  CBC
	/**
	 * 0x00:对称算法操作模式  ECB
	 */
	public static final int ECB_MODE          = 0x00;
	/**
	 * 0x10:对称算法操作模式  CBC
	 */
	public static final int CBC_MODE          = 0x10;
	///对称算法模式类型标识
	/**
	 * 0x00:对称算法模式类型标识 ECB 解密
	 */
	public static final int ECB_DECRYPT       = 0x00;
	/**
	 * 0x01:对称算法模式类型标识 ECB 加密
	 */
	public static final int ECB_ENCRYPT       = 0x01;
	/**
	 * 0x10:对称算法模式类型标识 CBC 解密
	 */
	public static final int CBC_DECRYPT       = 0x10;
	/**
	 * 0x11:对称算法模式类型标识CBC 加密
	 */
	public static final int CBC_ENCRYPT       = 0x11;
	//卡中RSA运算的长度
	public static final int CARD_RSA_LEN         = 128;
	public static final int CARD_PRIME_LEN       = 64;
	public static final int MAX_RSA_MODULUS_BITS = 2048;
	public static final int MAX_CARD_RSA_LEN     = 256;
	public static final int MIN_CARD_PRIME_LEN   = 128;
	//卡中SM2运算
	public static final int KEY_LEN_SM2                = 32;
	/**
	 * 0:SM2协商密钥发起方
	 */
	public static final int SM2_KEY_GENERATE_DICT_SEND = 0;
	/**
	 * 1:SM2协商密钥响应方
	 */
	public static final int SM2_KEY_GENERATE_DICT_RECV = 1;
	/**
	 * 64:签名时用户ID的最大长度
	 */
	public static final int SM2_UID_MAX                = 64;
	/**
	 * 158:SM2加密时明文的最大长度
	 */
	public static final int SM2_BLOCK_MAX              = 158;

	//权限角色设置
	public static final int ROLE_A            = 1;
	public static final int ROLE_B            = 2;
	public static final int ROLE_C            = 3;
	public static final int ROLE_D            = 4;
	public static final int ROLE_E            = 5;
	public static final int ROLE_Q            = 0x11;

	//签名数据类型
	/**
	 * 0:数据已做国密规定预处理--<b>强调下该预处理不只是SM3运算</b>
	 * 	 * <br/>
	 * <pre>
	 *     预处理步骤：
	 *     sm2预处理（算Z值）
	 *     第一部分：（0x00 0x80 ） 是首先要ID值的bit长度，固定两个字节，代表ID值的比特长度，如1234567812345678 即16字节128比特，值为00 80
	       第二部分：（1234567812345678）//ID值，默认"1234567812345678"，16个字节正好是128bit
	       第三部分：曲线参数a 32字节
	       第四部分：曲线参数b 32字节
	       第五部分：G点x坐标  32字节
	       第六部分：G点y坐标  32字节
	       第七部分：公钥的x   32字节
	       第八部分：公钥的y   32字节

	 对上述8部分联合值算SM3摘要值，得到32字节的z值。
	 ID值长度、用户ID、曲线参数a、b、G点(x、y)这部分都是固定值。
	 Z值+要签名原文计算SM3摘要值，得到最终值（e值）传给cos做签名。
	 *
	 * </pre>
	 */
	public static final int SIGN_HASH   = 0;
	/**
	 * 1:数据未做国密规定预处理--<b>强调下该预处理不只是SM3运算</b>
	 *
	 * <br/>
	 * <pre>
	 *     预处理步骤：
	 *     sm2预处理（算Z值）
	 *     第一部分：（0x00 0x80 ） 是首先要ID值的bit长度，固定两个字节，代表ID值的比特长度，如1234567812345678 即16字节128比特，值为00 80
	       第二部分：（1234567812345678）//ID值，默认"1234567812345678"，16个字节正好是128bit
	       第三部分：曲线参数a 32字节
	       第四部分：曲线参数b 32字节
	       第五部分：G点x坐标  32字节
	       第六部分：G点y坐标  32字节
	       第七部分：公钥的x   32字节
	       第八部分：公钥的y   32字节

	 对上述8部分联合值算SM3摘要值，得到32字节的z值。
	 ID值长度、用户ID、曲线参数a、b、G点(x、y)这部分都是固定值。
	 Z值+要签名原文计算SM3摘要值，得到最终值（e值）传给cos做签名。
	 *
	 * </pre>
	 */
	public static final int SIGN_NOHASH = 1;

	///USB分区
	public static final int USB_NORMAL_ZONE   = 0;//普通区
	public static final int USB_SECU_ZONE     = 1;//加密区
	public static final int USB_HEDD_ZONE     = 2;//隐藏区
	public static final int USB_INNOSTOR_ZONE = 3;//高速盘分区
	///USB FLASH读写模式
	public static final int USB_READ_TEMP       = 0;
	public static final int USB_WRITE_TEMP      = 1;
	public static final int USB_READ_FOREVER    = 2;
	public static final int USB_WRITE_FORERVER  = 3;
	public static final int INNOSTOR_WRITE_TEMP = 4;
	//其他密码信息设置
	/**
	 * 16:PIN口令最大支持长度
	 */
	public static final int PIN_MAX_LEN       = 16;
	/**
	 * 3:PIN口令最小允许长度
	 */
	public static final int PIN_MIN_LEN       = 3;
	/**
	 * 2:文件ID长度
	 */
	public static final int FILE_ID_LEN       = 2;
	/**
	 * 32:对称算法最大密钥长度
	 */
	public static final int KEY_LEN_MAX       = 32;
	/**
	 * 8:目录名字最大字符数
	 */
	public static final int DIR_NAME_LEN      = 8;

	public native int SetThirdPartySoName(byte[] paramArrayOfByte);
	public native int SetThirdPartyParam(byte[] param);

	//卡库版本接口
	public native int GetVersion(byte[] verion, int[] ver_len);
	public native int GetDateTime(byte[] datatime, int[] len);	
		
	//设备管理类接口
	public native int EnumDev(int devType, int[] devNum);
	public native int OpenDev(int index, long[] hHandle);
	public native int OpenDevByName(byte[] devName, long[] hHandle);
	public native int OpenDevBySN(byte[] sn, long[] hHandle);
	public native int OpenDevByNameEx(byte[] packagePath, long[] hHandle);
	public native int CloseDev(long handle);
	public native int LockDev(long handle);
	public native int UnlockDev(long handle);
	public native int Transmit(long handle, byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen);
	public native int TransmitEx(long handle, byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen);
	public native int GetDevInfo(long handle, XDJA_DEVINFO devInfo);
	public native int GetDevInfoEx(long handle, XDJA_DEVINFOEX devInfoEx);	
	public native int SetLogPath(byte[] logPath);
	public native int EnableSocket();	
	public native int ActivateCard(long handle, byte[] param, int paramLen);
	public native int GetActivateState(long handle);

	//访问控制类接口
	public native int ChangePIN(long handle, int pinRole, byte[] oldPin, int oldLen, byte[] newPin, int newLen);
	public native int GetPinTryCount(long handle, int pinRole);
	public native int VerifyPIN(long handle, int pinRole, byte[] pin, int pinLen);
	public native int UnlockPIN(long handle, int id, byte[] key, int keyLen, byte[] newPin, int newLen);
	public native int ReloadPIN(long handle, int pinRole, byte[] key, int keyLen, byte[] newPin, int newLen);
	public native int CardReset(long handle);
	public native int ExternAuth(long handle, byte exterAuthID, byte[] encRandom);
	public native int InterAuth(long handle, byte[] dataIn, int inLen, int flag, byte kID, byte[] tmpKey, byte[] dataOut, byte[] IV);

	//文件管理类接口
	public native int CreateDir(long handle, XDJA_DIR dir);
	public native int GetDirSize(long handle, int[] size);	
	public native int GetCurDirID(long handle, byte[] fid);
	public native int GetFFCB(long handle, XDJA_FFCB ffcb);	
	public native int SelectFile(long handle, byte[] fid);
	public native int SelectApp(long handle, byte[] name);	
	public native int DeleteFile(long handle, byte[] fid);
	public native int CreateFile(long handle, XDJA_FILE file);
	public native int GetFileInfo(long handle, byte[] fid, XDJA_FILE file);
	public native int ReadFile(long handle, byte[] fid, int readPos, int readLen, byte[] dataOut);
	public native int WriteFile(long handle, byte[] fid, int writePos, int writeLen, byte[] dataIn);
	public native int ReadRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey);
	public native int WriteRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey);
	public native int WriteRsaPriKey(long handle, byte[] prifid, XDJA_RSA_PRIKEY priKey);
	public native int ReadSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey);
	public native int WriteSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey);
	public native int WriteSm2PriKey(long handle, byte[] prifid, XDJA_SM2_PRIKEY priKey);
	public native int ReadCert(long handle, byte[] fid, byte[] certBuf, int[] certLen);
	public native int WriteCert(long handle, byte[] fid, byte[] certBuf, int certLen);

	//密码服务类接口
	public native int GenRandom(long handle, int len, byte[] random);
	//对称算法
	public native int DESKEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV);
	public native int DES3KEY(long handle, byte[] tmpKey, int tmpkeyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV);
	public native int AESKEY(long handle, byte[] tmpKey, int keyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV);
	public native int CreateKey(long handle, XDJA_KEY_ATTR keyAttr);
	public native int ImportKey(long handle, int type, byte[] dataIn, byte kID);
	public native int SM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut , byte kID, byte[] IV);
	public native int ImportTmpKey(long handle, byte[] tmpKey);
	public native int TmpSM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV);
	public native int ImportCipherKey(long handle, byte[] tmpKey, int alg);
	public native int TmpCipher(long handle, byte[] dataIn, int inLen, int alg, int flag, byte[] dataOut, byte[] IV);
	public native int CipherKey(long handle, byte[] tmpKey, byte[] dataIn, int inLen,int alg, int flag, byte[] dataOut, byte[] IV);		
	public native int SM1KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV);
	public native int SSF33(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV);
	public native int SM4KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV);
	public native int SM4KEYEx(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV);
	public native int SM6KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV);
	//RSA
	public native int GenRSAKeyPair(long handle, int bits, byte[] pubfid, byte[] prifid, XDJA_RSA_PUBKEY pubkey, XDJA_RSA_PRIKEY prikey);
	public native int RSAPubKeyCalc(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen);
	public native int RSAPriKeyCalc(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen);
	public native int RSAPriKeyCalcEx(long handle, byte[] pin, int pinLen, int pinRole, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen);
	public native int RSASign(long handle, int bits, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen);
	public native int RSASignVerify(long handle, int bits, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int dataType, byte[] dataIn, int inLen, byte[] signatureData);
	//SM2
	public native int SetSM2Id(long handle, byte[] sm2Id, int inLen);
	public native int GetSM2Id(long handle, byte[] sm2Id, int[] outLen);
	public native int SetSM2Param(long handle, XDJA_SM2_PARAM param);
	public native int GetSM2Param(long handle, XDJA_SM2_PARAM param);
	public native int GenSM2KeyPair(long handle, byte[] pubfid, byte[] prifid, XDJA_SM2_PUBKEY pubkey, XDJA_SM2_PRIKEY prikey);
	public native int SM2Encrypt(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen);
	public native int SM2EncryptGM(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen);
	public native int SM2Decrypt(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen);
	public native int SM2DecryptGM(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen);
	public native int SM2Sign(long handle, byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen);

	/**
	 * 备注：这个接口如果返回-10，表示验签失败。
	 */
	public native int SM2SignVerify(long handle, byte[] pubfid, int dataType, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData);
	public native int SM2SignEx(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] signatureData, int[] signatureDataLen);
	public native int SM2SignVerifyEx(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData);
	//Hash
	public native int SHA1(long handle, byte[] dataIn, int inLen, byte[] dataOut);
	public native int SHA1Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut);
	public native int SM3(long handle, byte[] dataIn, int inLen, byte[] dataOut);
	public native int SM3Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut);
	//Application
	public native int PackEnvelope(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int alg, byte[] dataOut, int[] outLen);
	public native int UnpackEnvelope(long handle, byte[] prifid,int alg, byte[] dataIn, int inLen);
	public native int KeyDisperse(long handle, int kId, byte[] keyParam, int keyParamLen);
	public native int SM2KeyGenInit(long handle, byte[] pubfid, byte[] dataOut, int[] outLen);
	public native int SM2KeyGenCompute(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, byte dictFlag, byte keyFlag);
	public native int SM2KeyGenVerify(long handle, byte[] dataIn, int inLen);


	//加密U盘专用接口
	public native int GetUsbMountPath(long handle, int type, byte[] path);
	public native int SetUsbRWMode(long handle, int mode);
	public native int ReadUsbNormalSecs(long handle, int addr, short secs, byte[] data);
	public native int WriteUsbNormalSecs(long handle,int addr, short secs, byte[] data);
	public native int OpenUsbSecuZone(long handle, byte[] pass, int passLen);
	public native int CloseUsbSecuZone(long handle);
	public native int ChgUsbSecuZonePin(long handle, byte[] oldPass, int oldLen, byte[] newPass, int newLen, int type);
	public native int UnlockUsbSecuZone(long handle, byte[] key, int keyLen, byte[] pin, int pinLen);
	public native int InitUsbHiddZone(long handle);
	public native int GetUsbHiddZoneSize(long handle, int[] size);
	public native int ReadUsbHiddZone(long handle, int addr, byte[] dataOut, int readLen);
	public native int WriteUsbHiddZone(long handle, int addr, byte[] dataIn, int writeLen);
	public native int ExecUsbScsiCmd(long handle, byte[] CDBbuff, int cdbLength, byte[] sendDataBuf, int sendDataLen, byte[] recvDataBuf,  int[] recvDataLen);

	//二代U盾专用接口
	public native int If2gKey(long handle);
	public native int gKeySign(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, int dataType);
	public native int GetRemainPower(long handle, int[] power);

	//TF卡专用接口
	public native int GetTFMountPath(long handle, byte[] mountPath,int[] pathLen);
	public native int GetTFZoneSize(long handle, int[] size);
	public native int ReadTFZone(long handle,int sectorStart, byte[] dataBuf, int buffSize);
	public native int WriteTFZone(long handle,int sectorStart, byte[] dataBuf, int buffSize);

	public native int SpiConfig( int int0, int int1, int por, int power, int qwk, int speed);
}