package com.xdja.SafeKey;

import android.os.Build;
import android.os.Process;
import android.util.Log;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/25 <br/>
 */

/**
 * 加载so库；
 * 1. 如果是com.xdja.safekeyservice:onboardchip进程，
 * 则要判断系统中是否有统一卡服务，
 * 如果有则加载libunitservicekey.so；否则加载libsafekey.so;
 * 2. 如果不是com.xdja.safekeyservice:onboardchip进程，
 * 则直接加载libsafekey.so
 */
class Loadlib {
    static void loadLib() {
        String processName = getSelfProcessName();
        if (processName.equals("com.xdja.safekeyservice:onboardchip")
                || processName.equals("com.xdja.safekeyservice")) {
            try {
                Class ServiceManagerClass = Loadlib.class.getClass().getClassLoader().loadClass("android.os.ServiceManager");
                Method method = ServiceManagerClass.getDeclaredMethod("getService", String.class);
                Object o = method.invoke(null, "com.xdja.unitesafekeysrv");
                if (o != null && !Build.DISPLAY.startsWith("ACE")) {
                    try {
                        System.loadLibrary("unitservicekey");
                    } catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                } else {
                    try {
                        System.loadLibrary("safekey");
                    } catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                System.loadLibrary("safekey");
            } catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

    }

    /**
     * 得到当前进程名
     *
     * @return
     */
    static String getSelfProcessName() {
        int myPid = Process.myPid();
        File file = new File("/proc/" + myPid + "/cmdline");
        String processName = "";
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[256];
            fis.read(buffer);
            fis.close();
            int len = buffer.length;
            int i = 0;
            for (; i < len; i++) {
                if (buffer[i] == 0) {
                    break;
                }
            }
            processName = new String(buffer, 0, i);
            Log.e("Loadlib", "pro_name: " + processName);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return processName;
    }

}
