/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import com.xdja.skfapi.EccPublicKeyBlob;
import com.xdja.skfapi.RsaPublicKeyBlob;

public class PublicKeyUtils {
    public static EccPublicKeyBlob byteToEccPublicKeyBlob(byte[] blob) {
        if (blob == null || blob.length != 132) {
            return null;
        }
        byte[] bitLenB = new byte[4];
        System.arraycopy(blob, 0, bitLenB, 0, 4);
        EccPublicKeyBlob eccPublicKeyBlob = new EccPublicKeyBlob();
        eccPublicKeyBlob.bitLen = PublicKeyUtils.hexByteToInteger(bitLenB);
        System.arraycopy(blob, 4, eccPublicKeyBlob.xCoordinate, 0, 64);
        System.arraycopy(blob, 68, eccPublicKeyBlob.yCoordinate, 0, 64);
        return eccPublicKeyBlob;
    }

    public static RsaPublicKeyBlob byteToRsaPublicKeyBlob(byte[] blob) {
        if (blob == null || blob.length != 268) {
            return null;
        }
        byte[] algIDB = new byte[4];
        System.arraycopy(blob, 0, algIDB, 0, 4);
        byte[] bitLenB = new byte[4];
        System.arraycopy(blob, 4, bitLenB, 0, 4);
        RsaPublicKeyBlob rsaPublicKeyBlob = new RsaPublicKeyBlob();
        rsaPublicKeyBlob.algID = PublicKeyUtils.hexByteToInteger(algIDB);
        rsaPublicKeyBlob.bitLen = PublicKeyUtils.hexByteToInteger(bitLenB);
        System.arraycopy(blob, 8, rsaPublicKeyBlob.modulus, 0, 256);
        System.arraycopy(blob, 264, rsaPublicKeyBlob.publicExponent, 0, 4);
        return rsaPublicKeyBlob;
    }

    private static int hexByteToInteger(byte[] a) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            b.append(a[i]);
        }
        return Integer.parseInt(b.toString(), 16);
    }
}

