/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import android.content.Context;
import android.util.Pair;
import com.xdja.multichip.jar.MultiChipJar;
import com.xdja.multichip.param.ChipParam;
import com.xdja.multichip.param.ResultBean;
import com.xdja.multichip.param.SuperChip;
import java.util.List;

public class XDJAMultiChipUtils {
    public static Pair<Integer, SuperChip> getChipBinderByCardId(Context context, String cardId) {
        Pair<Integer, List<ChipParam>> listPair = MultiChipJar.getAllChip(context);
        if ((Integer)listPair.first != 0) {
            return Pair.create((Object)-1, null);
        }
        List paramList = (List)listPair.second;
        for (ChipParam c : paramList) {
            if (!c.uniqueID.equals(cardId)) continue;
            return MultiChipJar.getSuperChip(context, c);
        }
        return Pair.create((Object)-1, null);
    }

    public static ChipParam getChipParamByCardId(Context context, String cardId) {
        Pair<Integer, List<ChipParam>> listPair = MultiChipJar.getAllChip(context);
        if ((Integer)listPair.first != 0) {
            return null;
        }
        List paramList = (List)listPair.second;
        for (ChipParam c : paramList) {
            if (!c.uniqueID.equals(cardId)) continue;
            return c;
        }
        return null;
    }

    public static Pair<Integer, Boolean> judgePinEnable(Context context, String cardId, int role) {
        Pair<Integer, SuperChip> pair = XDJAMultiChipUtils.getChipBinderByCardId(context, cardId);
        if ((Integer)pair.first != 0) {
            return Pair.create((Object)pair.first, null);
        }
        Pair<Integer, Long> longPair = XDJAMultiChipUtils.getFirstApplicationHandle(context, cardId);
        if ((Integer)longPair.first != 0) {
            return Pair.create((Object)longPair.first, null);
        }
        ChipParam chipParam = XDJAMultiChipUtils.getChipParamByCardId(context, cardId);
        if (chipParam == null) {
            return Pair.create((Object)-1, null);
        }
        long happlicationHandle = (Long)longPair.second;
        Pair<Integer, ResultBean<Integer[]>> beanPair = ((SuperChip)pair.second).GetPINInfo(happlicationHandle, role);
        if ((Integer)beanPair.first != 0) {
            return Pair.create((Object)beanPair.first, null);
        }
        boolean isEnable = false;
        String manufacturer = "xdja";
        if (chipParam.manufacturer.equals(manufacturer)) {
            int pinTryCount = ((Integer[])((ResultBean)beanPair.second).result)[1];
            if (pinTryCount == 10) {
                isEnable = true;
            } else if (pinTryCount == 5 && role == 1) {
                isEnable = true;
            }
        } else {
            isEnable = ((Integer[])((ResultBean)beanPair.second).result)[1] == ((Integer[])((ResultBean)beanPair.second).result)[0];
        }
        return Pair.create((Object)0, (Object)isEnable);
    }

    private static Pair<Integer, Long> getFirstApplicationHandle(Context context, String cardId) {
        Pair<Integer, SuperChip> pair = XDJAMultiChipUtils.getChipBinderByCardId(context, cardId);
        if ((Integer)pair.first != 0) {
            return Pair.create((Object)-1, null);
        }
        Pair<Integer, byte[]> bytePair = ((SuperChip)pair.second).EnumApplication();
        if ((Integer)bytePair.first != 0) {
            return Pair.create((Object)bytePair.first, null);
        }
        Pair<Integer, Long> longPair = ((SuperChip)pair.second).OpenApplication((byte[])bytePair.second);
        if ((Integer)longPair.first != 0) {
            return Pair.create((Object)longPair.first, null);
        }
        return Pair.create((Object)0, (Object)longPair.second);
    }
}

