/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.jar;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Pair;
import com.xdja.multichip.IMultiChip;
import com.xdja.multichip.ISkfChip;
import com.xdja.multichip.jar.KeyBroadcastReceiver;
import com.xdja.multichip.jar.MultiChipListener;
import com.xdja.multichip.param.ChipParam;
import com.xdja.multichip.param.SuperChip;
import java.util.ArrayList;
import java.util.List;

public class MultiChipJar {
    private static final String KEY_STRING_BINDER = "Binder";
    private static final String KEY_PARCELABLE_CHIPPARAM = "ChipParam";
    private static final int OK = 0;
    public static final int PARAM_ERROR = -60001;
    private static final int MULTI_BINDER_ERROR = -60002;
    public static final int SKF_PARAM_ERROR = -60003;
    public static final int BINDER_NULL_ERROR = -60004;
    private static IMultiChip multiChip = null;
    private static ArrayList<String> findList = new ArrayList();

    public static Pair<Integer, List<ChipParam>> getAllChip(Context context) {
        if (context == null) {
            return Pair.create((Object)-60001, null);
        }
        Pair<Integer, List<Bundle>> bundles = MultiChipJar.getChipInfoBundle(context);
        ArrayList<ChipParam> chipParamList = new ArrayList<ChipParam>();
        if ((Integer)bundles.first != 0) {
            return Pair.create((Object)bundles.first, null);
        }
        for (Bundle bundle : (List)bundles.second) {
            bundle.setClassLoader(ChipParam.class.getClassLoader());
            ChipParam chipParam = (ChipParam)bundle.getParcelable(KEY_PARCELABLE_CHIPPARAM);
            chipParamList.add(chipParam);
        }
        return Pair.create((Object)0, chipParamList);
    }

    public static Pair<Integer, List<ChipParam>> getChip(Context context, int chipType) {
        if (context == null || chipType != 1 && chipType != 2 && chipType != 4) {
            return Pair.create((Object)-60001, null);
        }
        Pair<Integer, List<ChipParam>> pair = MultiChipJar.getAllChip(context);
        if ((Integer)pair.first != 0) {
            return pair;
        }
        List chipParamList = (List)pair.second;
        ArrayList<ChipParam> chipParamListInType = new ArrayList<ChipParam>();
        for (ChipParam chipParam : chipParamList) {
            if (chipType != chipParam.chipType) continue;
            chipParamListInType.add(chipParam);
        }
        return Pair.create((Object)0, chipParamListInType);
    }

    private static Pair<Integer, ISkfChip> getSfkChipBinder(Context context, ChipParam chipParam) {
        if (context == null || chipParam == null) {
            return Pair.create((Object)-60001, null);
        }
        Pair<Integer, List<Bundle>> bundles = MultiChipJar.getChipInfoBundle(context);
        if ((Integer)bundles.first != 0) {
            return Pair.create((Object)bundles.first, null);
        }
        for (Bundle bundle : (List)bundles.second) {
            bundle.setClassLoader(ChipParam.class.getClassLoader());
            ChipParam chipParamTmp = (ChipParam)bundle.getParcelable(KEY_PARCELABLE_CHIPPARAM);
            if (chipParamTmp == null || !chipParamTmp.uniqueID.equals(chipParam.uniqueID) || !chipParamTmp.manufacturer.equals(chipParam.manufacturer)) continue;
            IBinder binder = bundle.getBinder(KEY_STRING_BINDER);
            ISkfChip skfChip = null;
            if (binder == null) continue;
            skfChip = ISkfChip.Stub.asInterface(binder);
            return Pair.create((Object)0, (Object)skfChip);
        }
        return Pair.create((Object)-60004, null);
    }

    public static Pair<Integer, SuperChip> getSuperChip(Context context, ChipParam chipParam) {
        if (context == null || chipParam == null) {
            return Pair.create((Object)-60001, null);
        }
        Pair<Integer, ISkfChip> skfBinderPair = MultiChipJar.getSfkChipBinder(context, chipParam);
        ISkfChip skfChipBinder = (ISkfChip)skfBinderPair.second;
        return Pair.create((Object)skfBinderPair.first, (Object)new SuperChip.Builder().build(skfChipBinder));
    }

    private static Pair<Integer, List<Bundle>> getChipInfoBundle(Context context) {
        IMultiChip multiChip = null;
        List<Bundle> bundles = null;
        try {
            multiChip = MultiChipJar.getBinder(context);
            if (multiChip == null) {
                return Pair.create((Object)-60002, null);
            }
            bundles = multiChip.getChipInfo();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return Pair.create((Object)0, bundles);
    }

    public static int registerKeyReceiver(Context context, MultiChipListener.KeyChangeListener changeListener) {
        if (context == null || changeListener == null) {
            return -60001;
        }
        KeyBroadcastReceiver broadcastReceiver = KeyBroadcastReceiver.getInstance(context);
        broadcastReceiver.registerKeyReceiver(context, changeListener);
        return 0;
    }

    public static int unregisterKeyReceiver(Context context, MultiChipListener.KeyChangeListener changeListener) {
        if (context == null || changeListener == null) {
            return -60001;
        }
        KeyBroadcastReceiver broadcastReceiver = KeyBroadcastReceiver.getInstance(context);
        broadcastReceiver.unregisterKeyReceiver(context, changeListener);
        return 0;
    }

    private MultiChipJar() {
    }

    private static IMultiChip getBinder(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        Uri uri = MultiChipJar.getUri(context);
        if (uri == null) {
            return null;
        }
        Bundle bundle = contentResolver.call(uri, "GetBinder", "MultiChipProxyBinder", null);
        if (bundle == null) {
            return null;
        }
        IBinder binder = bundle.getBinder(KEY_STRING_BINDER);
        if (binder != null) {
            multiChip = IMultiChip.Stub.asInterface(binder);
            try {
                multiChip.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                    public void binderDied() {
                        multiChip = null;
                    }
                }, 1);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return multiChip;
    }

    private static Uri getUri(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        for (String s : findList) {
            Uri uri = Uri.parse((String)("content://" + s));
            ContentProviderClient client = contentResolver.acquireContentProviderClient(s);
            if (client == null) continue;
            client.release();
            return uri;
        }
        return null;
    }

    static {
        findList.add("com.xdja.safekeyservice.provider.GetProxyProvider");
        findList.add("com.xdja.safeclient.provider.GetProxyProvider");
    }
}

