/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.param;

import android.os.IBinder;
import android.util.Log;
import android.util.Pair;
import com.xdja.multichip.ISkfChip;
import com.xdja.multichip.param.ResultBean;
import com.xdja.skfapi.BlockCipherParam;
import com.xdja.skfapi.DevInfo;
import com.xdja.skfapi.EccCipherBlob;
import com.xdja.skfapi.EccPrivateKeyBlob;
import com.xdja.skfapi.EccPublicKeyBlob;
import com.xdja.skfapi.EccSignatureBlob;
import com.xdja.skfapi.EnvelopedKeyBlob;
import com.xdja.skfapi.FileAttribute;
import com.xdja.skfapi.RsaPrivateKeyBlob;
import com.xdja.skfapi.RsaPublicKeyBlob;

public class SuperChip {
    private ISkfChip skfChipBinder = null;

    public int SetLabel(byte[] szLabel) {
        int ret;
        if (this.isEmpty(new Object[]{szLabel})) {
            return -60003;
        }
        long hDev = 0L;
        try {
            ret = this.skfChipBinder.SetLabel(hDev, szLabel);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, DevInfo> GetDevInfo() {
        int ret;
        long hDev = 0L;
        DevInfo pDevInfo = new DevInfo();
        try {
            ret = this.skfChipBinder.GetDevInfo(hDev, pDevInfo);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pDevInfo);
    }

    public int LockDev(int ulTimeOut) {
        int ret;
        long hDev = 0L;
        try {
            ret = this.skfChipBinder.LockDev(hDev, ulTimeOut);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public int UnlockDev() {
        int ret;
        long hDev = 0L;
        try {
            ret = this.skfChipBinder.UnlockDev(hDev);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public int Transmit(byte[] pbCommand, int ulCommandLen, byte[] pbData) {
        int ret;
        if (this.isEmpty(pbCommand, pbData)) {
            return -60003;
        }
        long hDev = 0L;
        int[] pulDataLen = new int[]{pbData.length};
        try {
            ret = this.skfChipBinder.Transmit(hDev, pbCommand, ulCommandLen, pbData, pulDataLen);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public int ChangeDevAuthKey(byte[] pbKeyValue) {
        int ret;
        if (this.isEmpty(new Object[]{pbKeyValue})) {
            return -60003;
        }
        long hDev = 0L;
        int ulKeyLen = pbKeyValue.length;
        try {
            ret = this.skfChipBinder.ChangeDevAuthKey(hDev, pbKeyValue, ulKeyLen);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public int DevAuth(byte[] pbAuthData) {
        int ret;
        if (this.isEmpty(new Object[]{pbAuthData})) {
            return -60003;
        }
        long hDev = 0L;
        int ulLen = pbAuthData.length;
        try {
            ret = this.skfChipBinder.DevAuth(hDev, pbAuthData, ulLen);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, Integer> ChangePIN(long hApplication, int ulPINType, byte[] szOldPin, byte[] szNewPin) {
        int ret;
        if (this.isEmpty(szOldPin, szNewPin)) {
            return Pair.create((Object)-60003, null);
        }
        int[] pulRetryCount = new int[1];
        try {
            ret = this.skfChipBinder.ChangePIN(hApplication, ulPINType, szOldPin, szNewPin, pulRetryCount);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pulRetryCount[0]);
    }

    public Pair<Integer, ResultBean<Integer[]>> GetPINInfo(long hApplication, int ulPINType) {
        int ret;
        int[] pulMaxRetryCount = new int[1];
        int[] pulRemainRetryCount = new int[1];
        int[] pbDefaultPin = new int[1];
        ResultBean resultBean = new ResultBean();
        try {
            ret = this.skfChipBinder.GetPINInfo(hApplication, ulPINType, pulMaxRetryCount, pulRemainRetryCount, pbDefaultPin);
            resultBean.result = new Integer[3];
            ((Integer[])resultBean.result)[0] = pulMaxRetryCount[0];
            ((Integer[])resultBean.result)[1] = pulRemainRetryCount[0];
            ((Integer[])resultBean.result)[2] = pbDefaultPin[0];
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, resultBean);
    }

    public Pair<Integer, Integer> VerifyPIN(long hApplication, int ulPINType, byte[] szPIN) {
        int ret;
        if (this.isEmpty(new Object[]{szPIN})) {
            return Pair.create((Object)-60003, null);
        }
        int[] pulRetryCount = new int[1];
        try {
            ret = this.skfChipBinder.VerifyPIN(hApplication, ulPINType, szPIN, pulRetryCount);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pulRetryCount[0]);
    }

    public Pair<Integer, Integer> UnblockPIN(long hApplication, byte[] szAdminPIN, byte[] szNewUserPIN) {
        int ret;
        if (this.isEmpty(szAdminPIN, szNewUserPIN)) {
            return Pair.create((Object)-60003, null);
        }
        int[] pulRetryCount = new int[1];
        try {
            ret = this.skfChipBinder.UnblockPIN(hApplication, szAdminPIN, szNewUserPIN, pulRetryCount);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pulRetryCount[0]);
    }

    public int ClearSecureState(long hApplication) {
        int ret;
        try {
            ret = this.skfChipBinder.ClearSecureState(hApplication);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, Long> CreateApplication(byte[] szAppName, byte[] szAdminPin, int dwAdminPinRetryCount, byte[] szUserPin, int dwUserPinRetryCount, int dwCreateFileRights) {
        int ret;
        long hDev = 0L;
        if (this.isEmpty(szAppName, szAdminPin, szUserPin)) {
            return Pair.create((Object)-60003, null);
        }
        long[] phApplication = new long[1];
        try {
            ret = this.skfChipBinder.CreateApplication(hDev, szAppName, szAdminPin, dwAdminPinRetryCount, szUserPin, dwUserPinRetryCount, dwCreateFileRights, phApplication);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)phApplication[0]);
    }

    public Pair<Integer, byte[]> EnumApplication() {
        int ret;
        long hDev = 0L;
        byte[] szAppName = null;
        int[] pulSize = new int[1];
        try {
            ret = this.skfChipBinder.EnumApplication(hDev, new byte[0], pulSize);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            szAppName = new byte[pulSize[0]];
            ret = this.skfChipBinder.EnumApplication(hDev, szAppName, pulSize);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, szAppName);
    }

    public int DeleteApplication(byte[] szAppName) {
        int ret;
        if (this.isEmpty(new Object[]{szAppName})) {
            return -60003;
        }
        long hDev = 0L;
        try {
            ret = this.skfChipBinder.DeleteApplication(hDev, szAppName);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, Long> OpenApplication(byte[] szAppName) {
        int ret;
        if (this.isEmpty(new Object[]{szAppName})) {
            return Pair.create((Object)-60003, null);
        }
        long hDev = 0L;
        long[] phApplication = new long[1];
        try {
            ret = this.skfChipBinder.OpenApplication(hDev, szAppName, phApplication);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)phApplication[0]);
    }

    public int CloseApplication(long hApplication) {
        int ret;
        try {
            ret = this.skfChipBinder.CloseApplication(hApplication);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public int CreateFile(long hApplication, byte[] szFileName, int ulFileSize, int ulReadRights, int ulWriteRights) {
        int ret;
        if (this.isEmpty(new Object[]{szFileName})) {
            return -60003;
        }
        try {
            ret = this.skfChipBinder.CreateFile(hApplication, szFileName, ulFileSize, ulReadRights, ulWriteRights);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public int DeleteFile(long hApplication, byte[] szFileName) {
        int ret;
        if (this.isEmpty(new Object[]{szFileName})) {
            return -60003;
        }
        try {
            ret = this.skfChipBinder.DeleteFile(hApplication, szFileName);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, byte[]> EnumFiles(long hApplication) {
        int ret;
        byte[] szFileList = null;
        int[] pulSize = new int[1];
        try {
            ret = this.skfChipBinder.EnumFiles(hApplication, new byte[0], pulSize);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            szFileList = new byte[pulSize[0]];
            ret = this.skfChipBinder.EnumFiles(hApplication, szFileList, pulSize);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, szFileList);
    }

    public Pair<Integer, FileAttribute> GetFileInfo(long hApplication, byte[] szFileName) {
        int ret;
        if (this.isEmpty(new Object[]{szFileName})) {
            return Pair.create((Object)-60003, null);
        }
        FileAttribute pFileInfo = new FileAttribute();
        try {
            ret = this.skfChipBinder.GetFileInfo(hApplication, szFileName, pFileInfo);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pFileInfo);
    }

    public Pair<Integer, byte[]> ReadFile(long hApplication, byte[] szFileName, int ulOfffset, int ulSize) {
        int ret;
        if (this.isEmpty(new Object[]{szFileName})) {
            return Pair.create((Object)-60003, null);
        }
        byte[] pbOutData = new byte[ulSize];
        int[] pulOutLen = new int[1];
        try {
            ret = this.skfChipBinder.ReadFile(hApplication, szFileName, ulOfffset, ulSize, pbOutData, pulOutLen);
            if (pulOutLen[0] < ulSize) {
                byte[] pbOutDataTmp = new byte[pulOutLen[0]];
                System.arraycopy(pbOutData, 0, pbOutDataTmp, 0, pulOutLen[0]);
                pbOutData = pbOutDataTmp;
            }
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pbOutData);
    }

    public int WriteFile(long hApplication, byte[] szFileName, int ulOfffset, byte[] pbData, int ulSize) {
        int ret;
        if (this.isEmpty(szFileName, pbData)) {
            return -60003;
        }
        try {
            ret = this.skfChipBinder.WriteFile(hApplication, szFileName, ulOfffset, pbData, ulSize);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, Long> CreateContainer(long hApplication, byte[] szContainerName) {
        int ret;
        if (this.isEmpty(new Object[]{szContainerName})) {
            return Pair.create((Object)-60003, null);
        }
        long[] pbContainer = new long[1];
        try {
            ret = this.skfChipBinder.CreateContainer(hApplication, szContainerName, pbContainer);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pbContainer[0]);
    }

    public int DeleteContainer(long hApplication, byte[] szContainerName) {
        int ret;
        if (this.isEmpty(new Object[]{szContainerName})) {
            return -60003;
        }
        try {
            ret = this.skfChipBinder.DeleteContainer(hApplication, szContainerName);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, byte[]> EnumContainer(long hApplication) {
        int ret;
        byte[] szContainerName = null;
        int[] pulSize = new int[1];
        try {
            ret = this.skfChipBinder.EnumContainer(hApplication, new byte[0], pulSize);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            szContainerName = new byte[pulSize[0]];
            ret = this.skfChipBinder.EnumContainer(hApplication, szContainerName, pulSize);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, szContainerName);
    }

    public Pair<Integer, Long> OpenContainer(long hApplication, byte[] szContainerName) {
        int ret;
        if (this.isEmpty(new Object[]{szContainerName})) {
            return Pair.create((Object)-60003, null);
        }
        long[] pbContainer = new long[1];
        try {
            ret = this.skfChipBinder.OpenContainer(hApplication, szContainerName, pbContainer);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pbContainer[0]);
    }

    public int CloseContainer(long hContainer) {
        int ret;
        try {
            ret = this.skfChipBinder.CloseContainer(hContainer);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, Integer> GetContainerType(long hContainer) {
        int ret;
        int[] pulContainerType = new int[1];
        try {
            ret = this.skfChipBinder.GetContainerType(hContainer, pulContainerType);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pulContainerType[0]);
    }

    public int ImportCertificate(long hContainer, int bSignFlag, byte[] pbCert) {
        int ret;
        if (this.isEmpty(new Object[]{pbCert})) {
            return -60003;
        }
        int ulCertLen = pbCert.length;
        try {
            ret = this.skfChipBinder.ImportCertificate(hContainer, bSignFlag, pbCert, ulCertLen);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, byte[]> ExportCertificate(long hContainer, int bSignFlag) {
        int ret;
        byte[] pbCert = null;
        int[] pulCertLen = new int[1];
        try {
            ret = this.skfChipBinder.ExportCertificate(hContainer, bSignFlag, new byte[0], pulCertLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            Log.i((String)"SuperChip", (String)("ExportCertificate len: " + pulCertLen[0]));
            pbCert = new byte[pulCertLen[0]];
            ret = this.skfChipBinder.ExportCertificate(hContainer, bSignFlag, pbCert, pulCertLen);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbCert);
    }

    public Pair<Integer, byte[]> GenRandom(int ulRandomLen) {
        int ret;
        long hDev = 0L;
        byte[] pbRandom = new byte[ulRandomLen];
        try {
            ret = this.skfChipBinder.GenRandom(hDev, pbRandom, ulRandomLen);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pbRandom);
    }

    public Pair<Integer, RsaPrivateKeyBlob> GenExtRSAKey(int ulBitsLen) {
        int ret;
        long hDev = 0L;
        RsaPrivateKeyBlob pBlob = new RsaPrivateKeyBlob();
        try {
            ret = this.skfChipBinder.GenExtRSAKey(hDev, ulBitsLen, pBlob);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pBlob);
    }

    public Pair<Integer, RsaPublicKeyBlob> GenRSAKeyPair(long hContainer, int ulBitsLen) {
        int ret;
        RsaPublicKeyBlob pBlob = new RsaPublicKeyBlob();
        try {
            ret = this.skfChipBinder.GenRSAKeyPair(hContainer, ulBitsLen, pBlob);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pBlob);
    }

    public int ImportRSAKeyPair(long hContainer, int ulSymAlgId, byte[] pbWrappedKey, byte[] pbEncryptedData) {
        int ret;
        if (this.isEmpty(pbWrappedKey, pbEncryptedData)) {
            return -60003;
        }
        int ulWrappedKeyLen = pbWrappedKey.length;
        int ulEncryptedDataLen = pbEncryptedData.length;
        try {
            ret = this.skfChipBinder.ImportRSAKeyPair(hContainer, ulSymAlgId, pbWrappedKey, ulWrappedKeyLen, pbEncryptedData, ulEncryptedDataLen);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, byte[]> RSASignData(long hContainer, byte[] pbData) {
        int ret;
        if (this.isEmpty(new Object[]{pbData})) {
            return Pair.create((Object)-60003, null);
        }
        int ulDataLen = pbData.length;
        byte[] pbSignatureTmp = new byte[245];
        int[] pulSignLen = new int[1];
        byte[] pbSignature = null;
        try {
            ret = this.skfChipBinder.RSASignData(hContainer, pbData, ulDataLen, pbSignatureTmp, pulSignLen);
            pbSignature = new byte[pulSignLen[0]];
            System.arraycopy(pbSignatureTmp, 0, pbSignature, 0, pulSignLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbSignature);
    }

    public int RSAVerify(RsaPublicKeyBlob pRSAPubKeyBlob, byte[] pbData, byte[] pbSignature) {
        int ret;
        if (this.isEmpty(pRSAPubKeyBlob, pbData, pbSignature)) {
            return -60003;
        }
        long hDev = 0L;
        int ulDataLen = pbData.length;
        int ulSignLen = pbSignature.length;
        try {
            ret = this.skfChipBinder.RSAVerify(hDev, pRSAPubKeyBlob, pbData, ulDataLen, pbSignature, ulSignLen);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, ResultBean<byte[]>> RSAExportSessionKey(long hContainer, int ulAlgId, RsaPublicKeyBlob pPubKey) {
        int ret;
        if (this.isEmpty(pPubKey)) {
            return Pair.create((Object)-60003, null);
        }
        byte[] pbData = new byte[pPubKey.bitLen / 8];
        int[] pulDataLen = new int[1];
        long[] phSessionKey = new long[1];
        ResultBean resultBean = new ResultBean();
        try {
            ret = this.skfChipBinder.RSAExportSessionKey(hContainer, ulAlgId, pPubKey, pbData, pulDataLen, phSessionKey);
            resultBean.result = pbData;
            resultBean.retHandle = phSessionKey[0];
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, resultBean);
    }

    public Pair<Integer, byte[]> ExtRSAPubKeyOperation(RsaPublicKeyBlob pRSAPubKeyBlob, byte[] pbInput) {
        int ret;
        if (this.isEmpty(pRSAPubKeyBlob, pbInput)) {
            return Pair.create((Object)-60003, null);
        }
        long hDev = 0L;
        byte[] pbOutput = new byte[pRSAPubKeyBlob.bitLen / 8];
        int[] pulOutputLen = new int[1];
        try {
            ret = this.skfChipBinder.ExtRSAPubKeyOperation(hDev, pRSAPubKeyBlob, pbInput, pbInput.length, pbOutput, pulOutputLen);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pbOutput);
    }

    public Pair<Integer, byte[]> ExtRSAPriKeyOperation(RsaPrivateKeyBlob pRSAPriKeyBlob, byte[] pbInput) {
        int ret;
        if (this.isEmpty(pRSAPriKeyBlob, pbInput)) {
            return Pair.create((Object)-60003, null);
        }
        long hDev = 0L;
        int ulInputLen = pbInput.length;
        byte[] pbOutputTmp = new byte[pRSAPriKeyBlob.bitLen];
        int[] pulOutputLen = new int[1];
        byte[] pbOutput = null;
        try {
            ret = this.skfChipBinder.ExtRSAPriKeyOperation(hDev, pRSAPriKeyBlob, pbInput, ulInputLen, pbOutputTmp, pulOutputLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pbOutput = new byte[pulOutputLen[0]];
            System.arraycopy(pbOutputTmp, 0, pbOutput, 0, pulOutputLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbOutput);
    }

    public Pair<Integer, EccPublicKeyBlob> GenECCKeyPair(long hContainer, int ulAlgId) {
        int ret;
        EccPublicKeyBlob pBlob = new EccPublicKeyBlob();
        try {
            ret = this.skfChipBinder.GenECCKeyPair(hContainer, ulAlgId, pBlob);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pBlob);
    }

    public int ImportECCKeyPair(long hContainer, EnvelopedKeyBlob pEenvlopedKeyBlob) {
        int ret;
        if (this.isEmpty(pEenvlopedKeyBlob)) {
            return -60003;
        }
        try {
            ret = this.skfChipBinder.ImportECCKeyPair(hContainer, pEenvlopedKeyBlob);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, EccSignatureBlob> ECCSignData(long hContainer, byte[] pbData) {
        int ret;
        if (this.isEmpty(new Object[]{pbData})) {
            return Pair.create((Object)-60003, null);
        }
        int ulDataLen = pbData.length;
        EccSignatureBlob pSignature = new EccSignatureBlob();
        try {
            ret = this.skfChipBinder.ECCSignData(hContainer, pbData, ulDataLen, pSignature);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pSignature);
    }

    public int ECCVerify(EccPublicKeyBlob pECCPubKeyBlob, byte[] pbData, EccSignatureBlob pSignature) {
        int ret;
        if (this.isEmpty(pECCPubKeyBlob, pbData, pSignature)) {
            return -60003;
        }
        long hDev = 0L;
        int ulDataLen = pbData.length;
        try {
            ret = this.skfChipBinder.ECCVerify(hDev, pECCPubKeyBlob, pbData, ulDataLen, pSignature);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, ResultBean<EccCipherBlob>> ECCExportSessionKey(long hContainer, int ulAlgId, EccPublicKeyBlob pPubKey) {
        int ret;
        if (this.isEmpty(pPubKey)) {
            return Pair.create((Object)-60003, null);
        }
        EccCipherBlob pData = new EccCipherBlob();
        long[] phSessionKey = new long[1];
        ResultBean resultBean = null;
        try {
            ret = this.skfChipBinder.ECCExportSessionKey(hContainer, ulAlgId, pPubKey, pData, phSessionKey);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            resultBean = new ResultBean();
            resultBean.result = pData;
            resultBean.retHandle = phSessionKey[0];
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, resultBean);
    }

    public Pair<Integer, EccCipherBlob> ExtECCEncrypt(EccPublicKeyBlob pECCPubkeyBlob, byte[] pbPlainText) {
        int ret;
        if (this.isEmpty(pECCPubkeyBlob, pbPlainText)) {
            return Pair.create((Object)-60003, null);
        }
        long hDev = 0L;
        int ulPlainTextLen = pbPlainText.length;
        EccCipherBlob pCipherText = new EccCipherBlob();
        try {
            ret = this.skfChipBinder.ExtECCEncrypt(hDev, pECCPubkeyBlob, pbPlainText, ulPlainTextLen, pCipherText);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pCipherText);
    }

    public Pair<Integer, byte[]> ExtECCDecrypt(EccPrivateKeyBlob pECCPriKeyBlob, EccCipherBlob pCipherText) {
        int ret;
        if (this.isEmpty(pECCPriKeyBlob, pCipherText)) {
            return Pair.create((Object)-60003, null);
        }
        long hDev = 0L;
        byte[] pbPlainTextTmp = new byte[pCipherText.cipherLen];
        int[] pulPlainTextLen = new int[1];
        byte[] pbPlainText = null;
        try {
            ret = this.skfChipBinder.ExtECCDecrypt(hDev, pECCPriKeyBlob, pCipherText, pbPlainTextTmp, pulPlainTextLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pbPlainText = new byte[pulPlainTextLen[0]];
            System.arraycopy(pbPlainTextTmp, 0, pbPlainText, 0, pulPlainTextLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbPlainText);
    }

    public Pair<Integer, EccSignatureBlob> ExtECCSign(EccPrivateKeyBlob pECCPriKeyBlob, byte[] pbData) {
        int ret;
        if (this.isEmpty(pECCPriKeyBlob, pbData)) {
            return Pair.create((Object)-60003, null);
        }
        long hDev = 0L;
        int ulDataLen = pbData.length;
        EccSignatureBlob pSignature = new EccSignatureBlob();
        try {
            ret = this.skfChipBinder.ExtECCSign(hDev, pECCPriKeyBlob, pbData, ulDataLen, pSignature);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)pSignature);
    }

    public int ExtECCVerify(EccPublicKeyBlob pECCPubKeyBlob, byte[] pbData, EccSignatureBlob pSignature) {
        int ret;
        if (this.isEmpty(pECCPubKeyBlob, pbData, pSignature)) {
            return -60003;
        }
        long hDev = 0L;
        int ulDataLen = pbData.length;
        try {
            ret = this.skfChipBinder.ExtECCVerify(hDev, pECCPubKeyBlob, pbData, ulDataLen, pSignature);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, ResultBean<EccPublicKeyBlob>> GenerateAgreementDataWithECC(long hContainer, int ulAlgId, byte[] pbID) {
        int ret;
        if (this.isEmpty(new Object[]{pbID})) {
            return Pair.create((Object)-60003, null);
        }
        int ulIDLen = pbID.length;
        EccPublicKeyBlob pTempECCPubKeyBlob = new EccPublicKeyBlob();
        long[] phAgreementHandle = new long[1];
        ResultBean resultBean = null;
        try {
            ret = this.skfChipBinder.GenerateAgreementDataWithECC(hContainer, ulAlgId, pTempECCPubKeyBlob, pbID, ulIDLen, phAgreementHandle);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            resultBean = new ResultBean();
            resultBean.retHandle = phAgreementHandle[0];
            resultBean.result = pTempECCPubKeyBlob;
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, resultBean);
    }

    public Pair<Integer, ResultBean<EccPublicKeyBlob>> GenerateAgreementDataAndKeyWithECC(long hContainer, int ulAlgId, EccPublicKeyBlob pSponsorECCPubKeyBlob, EccPublicKeyBlob pSponsorTempECCPubKeyBlob, byte[] pbID, byte[] pbSponsorID) {
        int ret;
        if (this.isEmpty(pSponsorECCPubKeyBlob, pSponsorTempECCPubKeyBlob, pbID, pbSponsorID)) {
            return Pair.create((Object)-60003, null);
        }
        int ulIDLen = pbID.length;
        int ulSponsorIDLen = pbSponsorID.length;
        EccPublicKeyBlob pTempECCPubKeyBlob = new EccPublicKeyBlob();
        long[] phKeyHandle = new long[1];
        ResultBean resultBean = null;
        try {
            ret = this.skfChipBinder.GenerateAgreementDataAndKeyWithECC(hContainer, ulAlgId, pSponsorECCPubKeyBlob, pSponsorTempECCPubKeyBlob, pTempECCPubKeyBlob, pbID, ulIDLen, pbSponsorID, ulSponsorIDLen, phKeyHandle);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            resultBean = new ResultBean();
            resultBean.retHandle = phKeyHandle[0];
            resultBean.result = pTempECCPubKeyBlob;
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, resultBean);
    }

    public Pair<Integer, Long> GenerateKeyWithECC(long hAgreementHandle, EccPublicKeyBlob pECCPubKeyBlob, EccPublicKeyBlob pTempECCPubKeyBlob, byte[] pbID) {
        int ret;
        if (this.isEmpty(pECCPubKeyBlob, pTempECCPubKeyBlob, pbID)) {
            return Pair.create((Object)-60003, null);
        }
        int ulIDLen = pbID.length;
        long[] phKeyHandle = new long[1];
        try {
            ret = this.skfChipBinder.GenerateKeyWithECC(hAgreementHandle, pECCPubKeyBlob, pTempECCPubKeyBlob, pbID, ulIDLen, phKeyHandle);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)phKeyHandle[0]);
    }

    public Pair<Integer, byte[]> ExportPublicKey(long hContainer, int bSignFlag) {
        int ret;
        byte[] pbBlobTmp = new byte[512];
        int[] pulBlobLen = new int[1];
        byte[] pbBlob = null;
        try {
            ret = this.skfChipBinder.ExportPublicKey(hContainer, bSignFlag, pbBlobTmp, pulBlobLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pbBlob = new byte[pulBlobLen[0]];
            System.arraycopy(pbBlobTmp, 0, pbBlob, 0, pulBlobLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbBlob);
    }

    public Pair<Integer, Long> ImportSessionKey(long hContainer, int ulAlgId, byte[] pbWrapedData) {
        int ret;
        if (this.isEmpty(new Object[]{pbWrapedData})) {
            return Pair.create((Object)-60003, null);
        }
        int ulWrapedLen = pbWrapedData.length;
        long[] phKey = new long[1];
        try {
            ret = this.skfChipBinder.ImportSessionKey(hContainer, ulAlgId, pbWrapedData, ulWrapedLen, phKey);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)phKey[0]);
    }

    public Pair<Integer, Long> SetSymmKey(byte[] pbKey, int ulAlgID) {
        int ret;
        if (this.isEmpty(new Object[]{pbKey})) {
            return Pair.create((Object)-60003, null);
        }
        long[] phKey = new long[1];
        long hDev = 0L;
        try {
            ret = this.skfChipBinder.SetSymmKey(hDev, pbKey, ulAlgID, phKey);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)phKey[0]);
    }

    public int EncryptInit(long hKey, BlockCipherParam EncryptParam) {
        int ret;
        if (this.isEmpty(EncryptParam)) {
            return -60003;
        }
        try {
            ret = this.skfChipBinder.EncryptInit(hKey, EncryptParam);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, byte[]> Encrypt(long hKey, byte[] pbData) {
        int ret;
        if (this.isEmpty(new Object[]{pbData})) {
            return Pair.create((Object)-60003, null);
        }
        int ulDataLen = pbData.length;
        byte[] pbEncryptedDataTmp = new byte[ulDataLen + 16];
        int[] pulEncryptedLen = new int[1];
        byte[] pbEncryptedData = null;
        try {
            ret = this.skfChipBinder.Encrypt(hKey, pbData, ulDataLen, pbEncryptedDataTmp, pulEncryptedLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pbEncryptedData = new byte[pulEncryptedLen[0]];
            System.arraycopy(pbEncryptedDataTmp, 0, pbEncryptedData, 0, pulEncryptedLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbEncryptedData);
    }

    public Pair<Integer, byte[]> EncryptUpdate(long hKey, byte[] pbData) {
        int ret;
        if (this.isEmpty(new Object[]{pbData})) {
            return Pair.create((Object)-60003, null);
        }
        int ulDataLen = pbData.length;
        byte[] pbEncryptedDataTmp = new byte[ulDataLen + 16];
        int[] pulEncryptedLen = new int[1];
        byte[] pbEncryptedData = null;
        try {
            ret = this.skfChipBinder.EncryptUpdate(hKey, pbData, ulDataLen, pbEncryptedDataTmp, pulEncryptedLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pbEncryptedData = new byte[pulEncryptedLen[0]];
            System.arraycopy(pbEncryptedDataTmp, 0, pbEncryptedData, 0, pulEncryptedLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbEncryptedData);
    }

    public Pair<Integer, byte[]> EncryptFinal(long hKey) {
        int ret;
        byte[] pbEncryptedDataTmp = new byte[16];
        int[] pulEncryptedLen = new int[1];
        byte[] pbEncryptedData = null;
        try {
            ret = this.skfChipBinder.EncryptFinal(hKey, pbEncryptedDataTmp, pulEncryptedLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pbEncryptedData = new byte[pulEncryptedLen[0]];
            System.arraycopy(pbEncryptedDataTmp, 0, pbEncryptedData, 0, pulEncryptedLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbEncryptedData);
    }

    public int DecryptInit(long hKey, BlockCipherParam EncryptParam) {
        int ret;
        if (this.isEmpty(EncryptParam)) {
            return -60003;
        }
        try {
            ret = this.skfChipBinder.DecryptInit(hKey, EncryptParam);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, byte[]> Decrypt(long hKey, byte[] pbEncryptedData) {
        int ret;
        if (this.isEmpty(new Object[]{pbEncryptedData})) {
            return Pair.create((Object)-60003, null);
        }
        int ulEncryptedLen = pbEncryptedData.length;
        byte[] pbDataTmp = new byte[ulEncryptedLen];
        int[] pulDataLen = new int[1];
        byte[] pbData = null;
        try {
            ret = this.skfChipBinder.Decrypt(hKey, pbEncryptedData, ulEncryptedLen, pbDataTmp, pulDataLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pbData = new byte[pulDataLen[0]];
            System.arraycopy(pbDataTmp, 0, pbData, 0, pulDataLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbData);
    }

    public Pair<Integer, byte[]> DecryptUpdate(long hKey, byte[] pbEncryptedData) {
        int ret;
        if (this.isEmpty(new Object[]{pbEncryptedData})) {
            return Pair.create((Object)-60003, null);
        }
        int ulEncryptedLen = pbEncryptedData.length;
        byte[] pbDataTmp = new byte[ulEncryptedLen + 16];
        int[] pulDataLen = new int[1];
        byte[] pbData = null;
        try {
            ret = this.skfChipBinder.DecryptUpdate(hKey, pbEncryptedData, ulEncryptedLen, pbDataTmp, pulDataLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pbData = new byte[pulDataLen[0]];
            System.arraycopy(pbDataTmp, 0, pbData, 0, pulDataLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbData);
    }

    public Pair<Integer, byte[]> DecryptFinal(long hKey) {
        int ret;
        byte[] pbDecryptedDataTmp = new byte[16];
        int[] pulDecryptedDataLen = new int[1];
        byte[] pbDecryptedData = null;
        try {
            ret = this.skfChipBinder.DecryptFinal(hKey, pbDecryptedDataTmp, pulDecryptedDataLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pbDecryptedData = new byte[pulDecryptedDataLen[0]];
            System.arraycopy(pbDecryptedDataTmp, 0, pbDecryptedData, 0, pulDecryptedDataLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbDecryptedData);
    }

    public Pair<Integer, Long> DigestInit(int ulAlgID, EccPublicKeyBlob pPubKey, byte[] pucID) {
        int ret;
        if (this.isEmpty(pPubKey, pucID)) {
            return Pair.create((Object)-60003, null);
        }
        long[] phHash = new long[1];
        int ulIDLen = pucID.length;
        long hDev = 0L;
        try {
            ret = this.skfChipBinder.DigestInit(hDev, ulAlgID, pPubKey, pucID, ulIDLen, phHash);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)phHash[0]);
    }

    public Pair<Integer, byte[]> Digest(long hHash, byte[] pbData) {
        int ret;
        if (this.isEmpty(new Object[]{pbData})) {
            return Pair.create((Object)-60003, null);
        }
        int ulDataLen = pbData.length;
        byte[] phHashDataTmp = new byte[64];
        int[] pulHashLen = new int[1];
        byte[] phHashData = null;
        try {
            ret = this.skfChipBinder.Digest(hHash, pbData, ulDataLen, phHashDataTmp, pulHashLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            phHashData = new byte[pulHashLen[0]];
            System.arraycopy(phHashDataTmp, 0, phHashData, 0, pulHashLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, phHashData);
    }

    public int DigestUpdate(long hHash, byte[] pbData) {
        int ret;
        if (this.isEmpty(new Object[]{pbData})) {
            return -60003;
        }
        int ulDataLen = pbData.length;
        try {
            ret = this.skfChipBinder.DigestUpdate(hHash, pbData, ulDataLen);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, byte[]> DigestFinal(long hHash) {
        int ret;
        byte[] pHashDataTmp = new byte[64];
        int[] pulHashLen = new int[1];
        byte[] pHashData = null;
        try {
            ret = this.skfChipBinder.DigestFinal(hHash, pHashDataTmp, pulHashLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pHashData = new byte[pulHashLen[0]];
            System.arraycopy(pHashDataTmp, 0, pHashData, 0, pulHashLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pHashData);
    }

    public Pair<Integer, Long> MacInit(long hKey, BlockCipherParam pMacParam) {
        int ret;
        if (this.isEmpty(pMacParam)) {
            return Pair.create((Object)-60003, null);
        }
        long[] phMac = new long[1];
        try {
            ret = this.skfChipBinder.MacInit(hKey, pMacParam, phMac);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, (Object)phMac[0]);
    }

    public Pair<Integer, byte[]> Mac(long hMac, byte[] pbData) {
        int ret;
        if (this.isEmpty(new Object[]{pbData})) {
            return Pair.create((Object)-60003, null);
        }
        int ulDataLen = pbData.length;
        byte[] pbMacDataTmp = new byte[16];
        int[] pulMacLen = new int[1];
        byte[] pbMacData = null;
        try {
            ret = this.skfChipBinder.Mac(hMac, pbData, ulDataLen, pbMacDataTmp, pulMacLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pbMacData = new byte[pulMacLen[0]];
            System.arraycopy(pbMacDataTmp, 0, pbMacData, 0, pulMacLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbMacData);
    }

    public int MacUpdate(long hMac, byte[] pbData) {
        int ret;
        if (this.isEmpty(new Object[]{pbData})) {
            return -60003;
        }
        int ulDataLen = pbData.length;
        try {
            ret = this.skfChipBinder.MacUpdate(hMac, pbData, ulDataLen);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public Pair<Integer, byte[]> MacFinal(long hMac) {
        int ret;
        byte[] pbMacDataTmp = new byte[16];
        int[] pulMacDataLen = new int[1];
        byte[] pbMacData = null;
        try {
            ret = this.skfChipBinder.MacFinal(hMac, pbMacDataTmp, pulMacDataLen);
            if (ret != 0) {
                return Pair.create((Object)ret, null);
            }
            pbMacData = new byte[pulMacDataLen[0]];
            System.arraycopy(pbMacDataTmp, 0, pbMacData, 0, pulMacDataLen[0]);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return Pair.create((Object)ret, pbMacData);
    }

    public int CloseHandle(long hHandle) {
        int ret;
        try {
            ret = this.skfChipBinder.CloseHandle(hHandle);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public int XdjaUnlockPin(int role, byte[] key, byte[] newPin) {
        int ret;
        if (this.isEmpty(key, newPin)) {
            return -60003;
        }
        try {
            ret = this.skfChipBinder.XdjaUnlockPin(role, key, newPin);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public int XdjaUnlockPinUseUsn(int role, byte[] usn, byte[] usnlockCode, byte[] newPin) {
        int ret;
        if (this.isEmpty(usn, usnlockCode, newPin)) {
            return -60003;
        }
        try {
            ret = this.skfChipBinder.XdjaUnlockPinUseUsn(role, usn, usnlockCode, newPin);
        }
        catch (Exception e) {
            ret = this.handleException(e);
        }
        return ret;
    }

    public String XdjaGetCosInfo() {
        String cosInfo = "";
        try {
            cosInfo = this.skfChipBinder.XdjaGetCosInfo();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return cosInfo;
    }

    private int handleException(Exception e) {
        e.printStackTrace();
        return -1;
    }

    private SuperChip(ISkfChip skfChipBinder1) {
        this.skfChipBinder = skfChipBinder1;
        try {
            this.skfChipBinder.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                public void binderDied() {
                    SuperChip.this.skfChipBinder = null;
                }
            }, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isEmpty(Object ... objects) {
        Object object = null;
        for (Object object1 : objects) {
            object = object1;
            if (object == null) {
                return true;
            }
            if (!(object instanceof byte[]) || ((byte[])object).length != 0) continue;
            return true;
        }
        return false;
    }

    public static final class Builder {
        public SuperChip build(ISkfChip skfChipBinder) {
            if (skfChipBinder == null) {
                return null;
            }
            return new SuperChip(skfChipBinder);
        }
    }
}

